// Define chart data at the top so it's available globally
var lineChartData = {
    labels: generateDayLabels(30), // Use the new function to generate labels
    datasets: [
        {
            label: "Profit",
            data: [2000, 2400, 2100, 4219, 6000, 3000, 2601, 3200, 4100, 5000, 4200, 3900, 3700, 4400, 4800, 5000, 5200, 5300, 5500, 5600, 5700, 5800, 5900, 6000, 6100, 6200, 6300, 6400, 6500, 6600],
            pointBackgroundColor: "rgba(16,133,135,1)",
            pointBorderColor: "#fff",
            tension: 0.4,
            fill: true,
        },
        {
            label: "Deposit",
            data: [1500, 1800, 1600, 1200, 1700, 2000, 1800, 1900, 1950, 2100, 2300, 2500, 2700, 2800, 2900, 3000, 3100, 3200, 3300, 3400, 3500, 3600, 3700, 3800, 3900, 4000, 4100, 4200, 4300, 4400],
            pointBackgroundColor: "rgba(255,100,50,1)",
            pointBorderColor: "#fff",
            tension: 0.4,
            fill: true,
        },
        {
            label: "Withdrawal",
            data: [3000, 3500, 3000, 2400, 3800, 2800, 3200, 3300, 3400, 3500, 3600, 3700, 3800, 3900, 4000, 4100, 4200, 4300, 4400, 4500, 4600, 4700, 4800, 4900, 5000, 5100, 5200, 5300, 5400, 5500],
            pointBackgroundColor: "rgba(50,150,255,1)",
            pointBorderColor: "#fff",
            tension: 0.4,
            fill: true,
        }
    ],
};

// Function to generate labels for the past 'days' days
function generateDayLabels(days) {
    let labels = [];
    let now = new Date();

    for (let i = days - 1; i >= 0; i--) {
        let currentDate = new Date(now.getTime() - i * 24 * 60 * 60 * 1000);
        let day = String(currentDate.getDate()).padStart(2, "0");
        let month = String(currentDate.getMonth() + 1).padStart(2, "0");
        labels.push(`${day}-${month}`);
    }
    return labels;
}

window.addEventListener("load", function () {
    var canvas = document.getElementById("canvas");
    if (!canvas) {
        console.error("Canvas element not found!");
        return;
    }
    
    var ctx = canvas.getContext("2d");
    
    var chart = new Chart(ctx, {
        type: "line",
        data: lineChartData,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: { stepSize: 1000, color: "#747474" },
                },
                x: { ticks: { color: "#C688FA" } },
            },
            plugins: {
                legend: { display: true, position: "top" },
                tooltip: {
                    callbacks: {
                        title: function(tooltipItem) {
                            return `Date: ${tooltipItem[0].label}`;
                        },
                        label: function(tooltipItem) {
                            return `${tooltipItem.dataset.label}: ${tooltipItem.raw} units`;
                        },
                    },
                },
            }
        },
    });
});
