// Define chart data at the top so it's available globally
var lineChartData = {
    labels: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
    datasets: [
        {
            label: "Profit",
            data: [2000, 2400, 2100, 4219, 6000, 3000, 2601],
            pointBackgroundColor: "rgba(16,133,135,1)",
            pointBorderColor: "#fff",
            pointHoverBackgroundColor: "#fff",
            pointHoverBorderColor: "rgba(16,133,135,1)",
            tension: 0.4,
            fill: true,
        },
        {
            label: "Deposit",
            data: [1500, 1800, 1600, 1200, 1700, 2000, 1800],
            pointBackgroundColor: "rgba(255,100,50,1)",
            pointBorderColor: "#fff",
            pointHoverBackgroundColor: "#fff",
            pointHoverBorderColor: "rgba(255,100,50,1)",
            tension: 0.4,
            fill: true,
        },
        {
            label: "Withdrawal",
            data: [3000, 3500, 3000, 2400, 3800, 2800, 3200],
            pointBackgroundColor: "rgba(50,150,255,1)",
            pointBorderColor: "#fff",
            pointHoverBackgroundColor: "#fff",
            pointHoverBorderColor: "rgba(50,150,255,1)",
            tension: 0.4,
            fill: true,
        }
    ],
};

window.addEventListener("load", function () {
    var canvas = document.getElementById("canvas");
    if (!canvas) {
        console.error("Canvas element not found!");
        return;
    }

    var ctx = canvas.getContext("2d");

    // Determine the current day of the week
    var currentDay = new Date().getDay(); // 0 (Sunday) to 6 (Saturday)

    // Rotate the labels and data arrays to place the current day at the right
    function rotateArrayToRightEnd(array, currentDay) {
        return array.slice(currentDay + 1).concat(array.slice(0, currentDay + 1));
    }

    lineChartData.labels = rotateArrayToRightEnd(lineChartData.labels, currentDay);
    lineChartData.datasets.forEach(function(dataset) {
        dataset.data = rotateArrayToRightEnd(dataset.data, currentDay);
    });

    // Function to create gradient background dynamically
    function createGradient(ctx, chart, color1, color2) {
        var chartArea = chart.chartArea;
        if (!chartArea) return null; // Ensure chartArea is available

        var gradient = ctx.createLinearGradient(0, chartArea.top, 0, chartArea.bottom);
        gradient.addColorStop(0, color1); // Top color
        gradient.addColorStop(1, color2); // Bottom color (fully transparent)
        return gradient;
    }

    var chart = new Chart(ctx, {
        type: "line",
        data: lineChartData,
        options: {
            responsive: true,
            maintainAspectRatio: false, // Allow full height usage
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: { stepSize: 1000, color: "#747474" },
                },
                x: { ticks: { color: "#C688FA" } },
            },
            plugins: {
                legend: { display: true, position: "top" },
                tooltip: {
                    callbacks: {
                        title: function(tooltipItem) {
                            return `Day: ${tooltipItem[0].label}`;
                        },
                        label: function(tooltipItem) {
                            return `${tooltipItem.dataset.label}: ${tooltipItem.raw} units`;
                        },
                    },
                },
            },
            animation: {
                onComplete: function () {
                    lineChartData.datasets.forEach((dataset, i) => {
                        dataset.backgroundColor = createGradient(ctx, chart, dataset.borderColor, "rgba(0,0,0,0)");
                    });
                    chart.update();
                },
            },
        },
    });
});
