<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="msapplication-TileColor" content="#07030c">
    <meta name="theme-color" content="#07030c">

    <title> {{ $page_title }} | {{ site('name') }}</title>

    <meta name="author" content="support@rescron.com">
    <meta name="description" content="{{ $short_description }}">
    <meta property="og:url" content="{{ request()->url }}">
    <meta property="og:title" content="{{ $page_title }} | {{ site('name') }}">
    <meta property="og:description" content="{{ $short_description }}">
    <meta property="og:image" content="{{ asset('assets/images/' . site('cover')) }}">
    <meta name="robots" content="{{ site('robot') }}">

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.14.8/dist/cdn.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@glidejs/glide"></script>
    <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>


    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@glidejs/glide/dist/css/glide.core.min.css">
    <link href="https://cdn.jsdelivr.net/npm/@splidejs/splide@3.6.1/dist/css/splide.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">

    <link rel="stylesheet" href="{{ asset('/assets/templates/dome/css/output.css?v=1.2') }}">
    <link rel="stylesheet" href="{{ asset('/assets/templates/dome/css/front_main.css') }}">

    <link rel="shortcut icon" href="{{ asset('assets/images/' . site('favicon')) }}" type="image/x-icon">
    <link rel="apple-touch-icon" href="{{ asset('assets/images/' . site('favicon')) }}" type="image/x-icon">

    <style>
        #navbar::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url('{{ asset('/assets/templates/dome/images/front/close-up-hands-holding-tablet1.png') }}') center/cover no-repeat;
            opacity: 0.5;
            z-index: -1;
        }
    </style>

    @yield('css')
</head>

@php
    $bg_style =
        'style="background-image: url(' .
        asset('/assets/templates/dome/images/front/background_Homepage.png') .
        ') !important;"';
    if (request()->routeIs('about')) {
        $bg_style =
            'style="background-image: url(' .
            asset('/assets/templates/dome/images/front/backgroundAboutUs.png') .
            ') !important;"';
    } elseif (request()->routeIs('pricing')) {
        $bg_style =
            'style="background-image: url(' .
            asset('/assets/templates/dome/images/front/backgroundAiBots.png') .
            ') !important;"';
    } elseif (request()->routeIs('trades')) {
        $bg_style =
            'style="background-image: url(' .
            asset('/assets/templates/dome/images/front/backgroundLiveAi.png') .
            ') !important;"';
    } elseif (request()->routeIs('tos')) {
        $bg_style =
            'style="background-image: url(' .
            asset('/assets/templates/dome/images/front/backgroundTOS.png') .
            ') !important;"';
    } elseif (request()->routeIs('contact')) {
        $bg_style =
            'style="background-image: url(' .
            asset('/assets/templates/dome/images/front/backgroundContactUs.png') .
            ') !important;"';
    } elseif (request()->routeIs('faqs')) {
        $bg_style =
            'style="background-image: url(' .
            asset('/assets/templates/dome/images/front/backgroundContactUs.png') .
            ') !important;"';
    } elseif (request()->routeIs('privacy')) {
        $bg_style =
            'style="background-image: url(' .
            asset('/assets/templates/dome/images/front/backgroundTOS.png') .
            ') !important;"';
    }

@endphp

<body class="bg-black" {!! $bg_style !!}>

    @if (site('preloader') == 1)
        @include('templates.' . site('template') . '.loaders.front_preloader')
    @endif

    <div class="w-full">

        <header class="w-full @if (request()->routeIs('home')) 3xl:min-h-[100vh] xl:min-h-[80vh] min-h-[70vh] @endif ">

            <nav class="fixed top-0 w-full bg-center bg-cover bg-no-repeat z-50" id="navbar">
                <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto xl:py-7 py-3 bg-[#031a45] bg-opacity-5">
                    <div class="mx-auto flex justify-between items-center xl:px-0 px-4 relative"
                        x-data="{
                            mobilenavbar: true,
                        }">
                        <div>
                            <a href="/"><img src="{{ asset('assets/images/' . site('logo_rec')) }}"
                                    alt="logo" class="xl:h-20 h-14"></a>
                        </div>

                        <button class="xl:hidden block p-2 text-white rounded focus:outline-none" id="toggle-sidebar"
                            x-on:click="mobilenavbar = !mobilenavbar">

                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                fill="white">
                                <path d="M4 6h16v2H4zm0 5h16v2H4zm0 5h16v2H4z"></path>
                            </svg>

                        </button>

                        <div class="xl:relative absolute top-16 left-0 xl:top-0 xl:left-auto xl:flex xl:w-auto w-full hidden xl:bg-transparent bg-black bg-opacity-90 xl:h-full h-auto xl:mt-0 mt-2 z-50"
                            id="nav-menu" x-bind:class="{ 'hidden': mobilenavbar, 'block': !mobilenavbar }"
                            x-transition>
                            <ul class="xl:flex flex-col xl:flex-row gap-2 text-white sm:text-center xl:text-left">
                                <li class="xl:hidden flex justify-end">
                                    <a class="p-6" x-on:click="mobilenavbar = !mobilenavbar"></a>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                        viewBox="0 0 24 24" style="fill: rgb(255, 255, 255);">
                                        <path
                                            d="m16.192 6.344-4.243 4.242-4.242-4.242-1.414 1.414L10.535 12l-4.242 4.242 1.414 1.414 4.242-4.242 4.243 4.242 1.414-1.414L13.364 12l4.242-4.242z">
                                        </path>
                                    </svg>
                                    </a>
                                </li>
                                <li><a href="{{ route('home') }}"
                                        class="py-2 px-4 rounded-lg hover:text-[#0040BC] block @if (request()->routeIs('home')) lg:bg-gradient-to-r from-[#95E3FD] to-[#A320D8] @endif">Home</a>
                                </li>
                                <li><a href="{{ route('about') }}"
                                        class="py-2 px-4 rounded-lg hover:text-[#0040BC] block @if (request()->routeIs('about')) lg:bg-gradient-to-r from-[#95E3FD] to-[#A320D8] @endif">About
                                        Us</a></li>
                                <li><a href="{{ route('pricing') }}"
                                        class="py-2 px-4 rounded-lg hover:text-[#0040BC] block @if (request()->routeIs('pricing')) lg:bg-gradient-to-r from-[#95E3FD] to-[#A320D8] @endif">Ai
                                        Bots</a></li>
                                <li><a href="{{ route('trades') }}"
                                        class="py-2 px-4 rounded-lg hover:text-[#0040BC] block @if (request()->routeIs('trades')) lg:bg-gradient-to-r from-[#95E3FD] to-[#A320D8] @endif">Live
                                        Ai
                                        Trades</a></li>
                                <li><a href="{{ route('tos') }}"
                                        class="py-2 px-4 rounded-lg hover:text-[#0040BC] block @if (request()->routeIs('tos')) lg:bg-gradient-to-r from-[#95E3FD] to-[#A320D8] @endif">TOS</a>
                                </li>
                                <li><a href="{{ route('contact') }}"
                                        class="py-2 px-4 rounded-lg hover:text-[#0040BC] block @if (request()->routeIs('contact')) lg:bg-gradient-to-r from-[#95E3FD] to-[#A320D8] @endif">Contact</a>
                                </li>
                                <li><a href="{{ route('faqs') }}"
                                        class="py-2 px-4 rounded-lg hover:text-[#0040BC] block @if (request()->routeIs('faqs')) lg:bg-gradient-to-r from-[#95E3FD] to-[#A320D8] @endif">FAQ</a>
                                </li>

                                <li><a href="{{ route('user.login') }}"
                                        class="py-2 px-4 rounded-lg hover:text-[#0040BC] xl:hidden block @if (request()->routeIs('faqs')) lg:bg-gradient-to-r from-[#95E3FD] to-[#A320D8] @endif">Login</a>
                                </li>

                            </ul>
                        </div>

                        <div class="xl:block hidden w-52">
                            <a href="{{ route('user.login') }}"
                                class="border rounded-full py-4 px-10 block text-center text-white text-lg bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)] hover:text-white">Login</a>
                        </div>
                    </div>
                </div>
            </nav>

            {{-- header --}}
            @yield('header')

        </header>



        {{-- main content --}}
        <main class="">

            @yield('contents')


            <!--Counter-->
            <section class="w-full mb-10 lg:mb-40 bg-black bg-opacity-15 backdrop-blur-md" data-aos="fade-up">
                <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto py-10">
                    <div class="grid lg:grid-cols-4 grid-cols-2 lg:gap-10 gap-4 w-full">
                        <div class="text-center">
                            <p
                                class="@if (request()->routeIs('home')) text-white @else text-[#E39DFF] @endif  font-bold lg:text-5xl text-2xl lg:mb-3">
                                <span class="counter_number">3.5</span> k
                            </p>
                            <p class="text-[#B4B1B1] lg:text-2xl text-xl">Users</p>
                        </div>

                        <div class="text-center">
                            <p
                                class="@if (request()->routeIs('home')) text-white @else text-[#E39DFF] @endif  font-bold lg:text-5xl text-2xl lg:mb-3">
                                USD <span class="counter_number">5.5</span> M+</p>
                            <p class="text-[#B4B1B1] lg:text-2xl text-xl">Deposits</p>
                        </div>

                        <div class="text-center">
                            <p
                                class="@if (request()->routeIs('home')) text-white @else text-[#E39DFF] @endif  font-bold lg:text-5xl text-2xl lg:mb-3">
                                USD <span class="counter_number">10.2</span> M+</p>
                            <p class="text-[#B4B1B1] lg:text-2xl text-xl">Withdrawals</p>
                        </div>

                        <div class="text-center">
                            <p
                                class="@if (request()->routeIs('home')) text-white @else text-[#E39DFF] @endif  font-bold lg:text-5xl text-2xl lg:mb-3">
                                <span class="counter_number">200</span> +
                            </p>
                            <p class="text-[#B4B1B1] lg:text-2xl text-xl">Countries </p>
                        </div>
                    </div>
                </div>
            </section>


        </main>

        <footer class="w-full ">
            <div class="pt-1 bg-gradient-to-r from-[#ffffff4f] from-[60%] to-[#ffffff]"></div>
            <div
                class="w-full bg-[url(../../assets/images/front/background_Footer.png)] bg-cover bg-center bg-no-repeats">
                <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto py-10 px-3">
                    <div class="lg:flex gap-3">
                        <div class="w-full mb-6">
                            <div class="mb-4">
                                <a href="{{ route('home') }}"><img
                                        src="{{ asset('assets/images/' . site('logo_rec')) }}" alt="logo"
                                        class="lg:h-20 h-12 mb-4"></a>
                                <p class="text-[#8C8787] px-6">All Servers Operational</p>
                            </div>
                            <div class="lg:px-6 py-2">
                                <ul class="flex gap-4">
                                    @php
                                        $socialMedia = [
                                            'instagram',
                                            'facebook',
                                            'pinterest',
                                            'twitter',
                                            'youtube',
                                            'linkedin',
                                            'snapchat',
                                            'tiktok',
                                            'reddit',
                                            'whatsapp',
                                        ];
                                    @endphp
                                    @foreach ($socialMedia as $media)
                                        @if (site($media))
                                            <li>
                                                <div class="p-2 bg-[#F9F8F8] rounded-lg bg-opacity-20">
                                                    <a href="{{ site($media) }}">
                                                        <img src="{{ asset('/assets/templates/dome/images/front/icon/white_social_icon_' . $media . '.svg') }}"
                                                            alt="icon" style="width: 25px; height: 25px;">
                                                    </a>
                                                </div>
                                            </li>
                                        @endif
                                    @endforeach
                                </ul>
                            </div>
                        </div>

                        <div class="w-full grid lg:grid-cols-3 grid-cols-2">
                            <div class="col-span-1">
                                <p class="text-white text-2xl">Company</p>
                                <ul class="py-4 space-y-4">
                                    <li><a href="{{ route('about') }}" class="text-[#A39D9D] hover:text-white">About
                                            Us</a>
                                    </li>
                                    <li><a href="{{ route('about') }}" class="text-[#A39D9D] hover:text-white">Our
                                            Vision</a>
                                    </li>
                                    <li><a href="{{ route('about') }}" class="text-[#A39D9D] hover:text-white">Our
                                            Mission</a>
                                    </li>
                                    <li><a href="{{ route('contact') }}"
                                            class="text-[#A39D9D] hover:text-white">Contact
                                            Us</a></li>
                                </ul>
                            </div>

                            <div class="col-span-1">
                                <p class="text-white text-2xl">Resources</p>
                                <ul class="py-4 space-y-4">
                                    <li><a href="{{ route('tos') }}" class="text-[#A39D9D] hover:text-white">TOS</a>
                                    </li>
                                    <li><a href="{{ route('privacy') }}"
                                            class="text-[#A39D9D] hover:text-white">Privacy
                                            Policy</a></li>
                                    <li><a href="{{ route('about') }}"
                                            class="text-[#A39D9D] hover:text-white">Community</a>
                                    </li>
                                    <li><a href="{{ route('faqs') }}" class="text-[#A39D9D] hover:text-white">FAQ</a>
                                    </li>
                                </ul>
                            </div>

                            <div class="lg:col-span-1 col-span-2">
                                <p class="text-white text-2xl">Contact Us</p>
                                <ul class="py-4 space-y-4">
                                    <li>
                                        <div class="flex gap-4">
                                            <img src="{{ asset('/assets/templates/valent/images/front_icon/gray_mdi_location.svg') }}"
                                                alt="icon">
                                            <p class="text-[#A39D9D]"> {{ site('address') }},
                                                {{ site('city') }},{{ site('state') }}, {{ site('country') }}</p>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="flex gap-4">
                                            <img src="{{ asset('/assets/templates/valent/images/front_icon/gray_call-sharp.svg') }}"
                                                alt="icon">
                                            <p class="text-[#A39D9D]">{{ site('phone') }}</p>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="flex gap-4">
                                            <img src="{{ asset('/assets/templates/valent/images/front_icon/gray_email.svg') }}"
                                                alt="icon">
                                            <p class="text-[#A39D9D]">{{ site('email') }}</p>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </footer>


        {{-- cookie consent --}}
        <div class="w-full fixed z-50 bottom-0 left-0 bg-white bg-opacity-15 backdrop-blur-md hidden"
            id="cookie-consent">
            <div class="w-full bg-purple-500 p-5">
                <div class="w-full grid grid-cols-1 gap-3  md:flex space-x-2 justify-center items-center text-white">
                    <p class="text-center">We use cookies to tailor your experience on {{ site('name') }}. Learn more
                        in
                        our <a href="{{ route('privacy') }}" class="border-b">privacy policy</a></p>
                    <div class="text-center py-6">
                        <a id="consented"
                            class="border rounded-full py-4 px-10 block text-center text-white text-lg bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)] hover:text-white"
                            role="button" style="width: 400px; margin: 0px auto;">
                            <span>Accept Cookies</span>

                        </a>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/Counter-Up/1.0.0/jquery.counterup.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/waypoints/4.0.1/jquery.waypoints.js"></script>

    <script src="{{ asset('/assets/templates/dome/scripts/front_main.js') }}"></script>

    <script>
        ///counter up 
        $(".counter_number").counterUp({
            time: 3000
        });


        //cookies
        window.onload = function() {
            // Check if the "cookie-consent" cookie exists
            if (!document.cookie.includes('cookie-consent')) {
                $('#cookie-consent').removeClass('hidden');
            }
        };

        function setCookie(cookieName, cookieValue) {
            var expirationDate = new Date();
            expirationDate.setFullYear(expirationDate.getFullYear() + 10); // Set expiration date to 10 years from now

            var cookieString = cookieName + '=' + cookieValue + '; expires=' + expirationDate.toUTCString() + '; path=/';

            document.cookie = cookieString;
        }


        $('#consented').on('click', function(e) {
            e.preventDefault();
            setCookie('cookie-consent', true);
            $('#cookie-consent').addClass('hidden');
        });
    </script>

    @yield('scripts')

    @stack('scripts')

    {{-- livechat --}}
    {!! json_decode(site('livechat')) !!}
    </script>

</body>

</html>
