<style>
    #preloader {
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh;
        width: 100%;
        margin: 0;
        background-color: #0e111d;
        z-index: 9999;
        /* Ensure it is above everything */
        position: fixed;
    }

    .preloader-container {
        position: relative;
        width: 100px;
        height: 100px;
    }

    .bar {
        position: absolute;
        bottom: 0;
        background-color: #A320D8;
        width: 12px;
        border-radius: 2px 2px 0 0;
        transform-origin: bottom;
        animation: barAnimation 1.5s infinite ease-in-out;
    }

    .bar1 {
        height: 20px;
        left: 0;
        animation-delay: 0s;
    }

    .bar2 {
        height: 35px;
        left: 20px;
        animation-delay: 0.2s;
    }

    .bar3 {
        height: 50px;
        left: 40px;
        animation-delay: 0.4s;
    }

    .bar4 {
        height: 65px;
        left: 60px;
        animation-delay: 0.6s;
    }

    .bar5 {
        height: 80px;
        left: 80px;
        animation-delay: 0.8s;
    }

    .circle {
        position: absolute;
        width: 12px;
        height: 12px;
        background-color: #3F7DF2;
        border-radius: 50%;
        left: 80px;
        top: -12px;
        animation: circleAnimation 1.5s infinite ease-in-out;
        animation-delay: 0.8s;
    }

    @keyframes barAnimation {

        0%,
        100% {
            transform: scaleY(1);
            opacity: 1;
        }

        50% {
            transform: scaleY(0.6);
            opacity: 0.6;
        }
    }

    @keyframes circleAnimation {

        0%,
        100% {
            transform: translateY(0);
            opacity: 1;
        }

        50% {
            transform: translateY(10px);
            opacity: 0.6;
        }
    }

    .loading-text {
        position: absolute;
        bottom: -30px;
        width: 100%;
        text-align: center;
        color: white;
        font-family: Arial, sans-serif;
        animation: fadeInOut 1.5s infinite ease-in-out;
    }

    @keyframes fadeInOut {

        0%,
        100% {
            opacity: 1;
        }

        50% {
            opacity: 0.5;
        }
    }

    /* Hide preloader when content is loaded */
    .hider {
        opacity: 0;
        visibility: hidden;
        transition: opacity 0.5s ease-out, visibility 0.5s ease-out;
    }
</style>


<div id="preloader">
    <div class="preloader-container">
        <div class="bar bar1"></div>
        <div class="bar bar2"></div>
        <div class="bar bar3"></div>
        <div class="bar bar4"></div>
        <div class="bar bar5"></div>
        <div class="circle"></div>
        <div class="loading-text">Loading...</div>
    </div>
</div>


<script>
    window.addEventListener('load', function() {
        setTimeout(function() {
            const preloader = document.getElementById('preloader');
            preloader.style.opacity = '0';
            setTimeout(() => preloader.style.display = 'none', 500);
        }, 3000);
    });
</script>
