<style>
    #preloader {
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh;
        background-color: #000000;
    }

    .chart-container {
        display: flex;
        align-items: flex-end;
        gap: 5px;
        width: 200px;
        height: 100px;
        /* background: #fff; */
        padding: 10px;
        border-radius: 5px;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    }

    .bar {
        width: 15px;
        background: linear-gradient(to top, #0b1e36, #A320D8);
        transition: height 1s ease-in-out, background-color 1s ease-in-out;
    }
</style>

<div id="preloader" class="top-0 bottom-0 fixed left-0 w-full h-screen z-50 p-10">

    <div class="chart-container" id="chart"></div>
</div>


<script>
    function generateBars() {
        let chart = $('#chart');
        chart.children().each(function() {
            let height = Math.random() * 80 + 10; // Random height between 10 and 90
            $(this).css('height', height + 'px');
        });
    }

    $(document).ready(function() {
        for (let i = 0; i < 10; i++) {
            $('#chart').append('<div class="bar"></div>');
        }
        generateBars();
        setInterval(generateBars, 1000);
    });
</script>

</div>
