@php
    use App\Models\Bot;

    $page_title = 'FAQ';
    $short_description = 'Below are some frequently asked questions from our users';
    $faqs = [
        [
            'question' => 'What is ' . site('name') . '?',
            'answer' =>
                site('name') .
                ' is an advanced trading platform that utilizes AI technology to analyze market trends and execute trades with high precision.',
        ],
        [
            'question' => 'How can I get started with ' . site('name') . '?',
            'answer' =>
                'Getting started is simple. Sign up for an account, complete the verification process, and you can begin trading.',
        ],
        [
            'question' => 'Is my personal information secure with ' . site('name') . '?',
            'answer' =>
                'Yes, we take data security seriously. We employ industry-standard measures to protect your information.',
        ],
        [
            'question' => 'Can I trade on ' . site('name') . ' from anywhere?',
            'answer' =>
                'Absolutely ' . site('name') . ' allows you to trade from anywhere with an internet connection.',
        ],

        [
            'question' => 'Do I need prior trading experience to use ' . site('name') . '?',
            'answer' =>
                'No, ' .
                site('name') .
                ' is designed for both beginners and experienced traders. We offer educational resources to help you get started.',
        ],
        [
            'question' => 'What fees are associated with using ' . site('name') . '?',
            'answer' =>
                'We charge competitive fees, which are transparently displayed on our platform. There are no hidden charges.',
        ],
        [
            'question' => 'Can I withdraw my profits easily?',
            'answer' =>
                'Yes, withdrawing your profits is straightforward. You can initiate withdrawals through your account.',
        ],
        [
            'question' => 'Is customer support available?',
            'answer' =>
                'Absolutely. Our customer support team is here to assist you with any questions or issues you may have.',
        ],
        [
            'question' => 'How often are trading signals generated?',
            'answer' =>
                site('name') .
                ' generates trading signals continuously, ensuring you have access to up-to-date market information.',
        ],
    ];

@endphp

{{-- layout --}}
@extends('templates.' . site('template') . '.layouts.front')



@section('css')
@endsection



@section('header')
    <div class="w-full flex-1 lg:py-32">
        <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto px-3 lg:pt-52 pt-32" data-aos="fade-up">


            <div class="block max-w-screen-lg mx-auto lg:mb-24 mb-10">
                <div class="flex justify-center items-center gap-3">
                    <div class="line"></div>
                    <div class="pricing-text text-[#ffffff] lg:text-6xl text-2xl"><span class="font-bold">FAQ</span></div>
                    <div class="line2"></div>
                </div>

                <div class="block text-center py-3">
                    <p class="lg:text-2xl text-lg text-white font-extralight">
                        <a href="" class="text-[#D8D8D8] text-opacity-45">Home</a> / <a href="">FAQ</a>
                    </p>
                </div>
            </div>

            <div class="block max-w-screen-lg mx-auto mb-10 p-2">
                <p class="text-center text-[#95E3FD] uppercase py-5">FAQ</p>
                <p class="text-center lg:text-6xl text-2xl lg:mb-3 lg:max-w-screen-lg">
                    <span
                        class="bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[20%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">Frequently
                        Asked <b class="font-bold"> Questions</b></span>
                </p>

                <p class="lg:text-2xl text-lg text-white font-extralight text-center">Below are some frequently asked
                    questions from our users</p>
            </div>


        </div>
    </div>
@endsection



@section('contents')
    {{-- faq --}}
    <section class="w-full mb-10" data-aos="fade-up">
        <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto px-3 py-10">
            <div class="max-w-screen-lg mx-auto">
                <ul class="w-full">

                    @foreach ($faqs as $faq)
                        <li class="mb-5" x-data="{
                            expanded: false,
                            showAdd: false,
                        }">
                            <div class="border-green-500 border-opacity-15"
                                x-bind:class="expanded ? 'border-0' : 'border-b'">
                                <p class="text-lg stext-2xl flex gap-x-20 mb-6"
                                    x-on:click="expanded = !expanded; showAdd = !showAdd">
                                    <span x-bind:class="expanded ? 'text-[#E39DFF]' : 'text-[#95e3fdad]'">
                                        {{ $faq['question'] }} </span>
                                    <img x-bind:src="showAdd ?
                                        '{{ asset('assets/templates/dome/images/front/icon/pink_subtract_sign.svg') }}' :
                                        '{{ asset('assets/templates/dome/images/front/icon/pink_add_sign.svg') }}'"
                                        alt="icon">

                                </p>
                                <div class="w-full pl-8" x-cloak x-transition x-show="expanded">
                                    <div class="w-full border-l-4 border-[#95E3FD] border-dashed px-10 overflow-hidden">
                                        <p class="text-white">{{ $faq['answer'] }}</p>
                                    </div>
                                </div>
                            </div>
                        </li>
                    @endforeach

                </ul>
            </div>
        </div>
    </section>
@endsection

@section('scripts')
@endsection
