@php
    use App\Models\Bot;

    $page_title = 'Terms of Service';
    $short_description =
        'Prior to availing any of our services, we kindly request that you review and acknowledge our Acceptable Use Terms of Service. Your utilization of our services constitutes your agreement to abide by the terms and conditions outlined therein. We appreciate your understanding and compliance.';

@endphp

{{-- layout --}}
@extends('templates.' . site('template') . '.layouts.front')


@section('css')
@endsection

@section('header')
    <div class="w-full flex-1 lg:py-32">
        <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto px-3 lg:pt-52 pt-32" data-aos="fade-up">


            <div class="block max-w-screen-lg mx-auto lg:mb-24 mb-10">
                <div class="flex justify-center items-center gap-3">
                    <div class="line"></div>
                    <div class="pricing-text text-[#ffffff] lg:text-6xl text-2xl"><span class="font-bold">TOS</span></div>
                    <div class="line2"></div>
                </div>

                <div class="block text-center py-3">
                    <p class="lg:text-2xl text-lg text-white font-extralight">
                        <a href="" class="text-[#D8D8D8] text-opacity-45">Home</a> / <a href="">TOS</a>
                    </p>
                </div>
            </div>

            <div class="block max-w-screen-lg mx-auto mb-10 p-2">
                <p class="text-center text-[#95E3FD] uppercase py-5">Terms of Services</p>
                <p class="text-center lg:text-6xl text-2xl lg:mb-3 lg:max-w-screen-lg">
                    <span
                        class="bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[20%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">Terms
                        of <b class="font-bold">Services</b></span>
                </p>

                <p class="lg:text-2xl text-lg text-white font-extralight text-center">Prior to availing any of our services,
                    we kindly request that you review and acknowledge our Terms of Service. Your utilization of our services
                    constitutes your agreement to abide by the terms and conditions outlined therein. </p>
            </div>


        </div>
    </div>
@endsection


@section('contents')
    {{-- tos --}}
    <section class="w-full mb-10 " data-aos="fade-up">
        <div class="lg:w-[70%] mx-auto lg:py-10 p-4">
            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Acceptance of Terms
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    Welcome to {{ site('name') }}! By accessing or using our services, including but not limited to our
                    website,
                    trading platform, and any associated software or applications (collectively referred to as the
                    "Services"), you agree to be bound by these Terms of Service ("Terms"). If you do not agree to these
                    Terms, please do not use our Services.
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Description of Services
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    {{ site('name') }} provides a trading platform that utilizes advanced AI technology to analyze market
                    trends and
                    execute trades. Our Services are designed to facilitate trading activities, and we do not provide
                    financial advice. You are solely responsible for your trading decisions.
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Eligibility
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    You must be at least 18 years old and have the legal capacity to enter into this agreement to use our
                    Services. By using our Services, you represent and warrant that you meet these eligibility criteria.
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Registration and Account Security
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    To access certain features of our Services, you may need to register for an account. You agree to
                    provide accurate, current, and complete information during the registration process and to keep your
                    account information updated. You are responsible for maintaining the confidentiality of your account
                    credentials and for all activities that occur under your account. You must immediately notify us of any
                    unauthorized use of your account.
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Privacy Policy
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    Your use of our Services is also governed by our Privacy Policy. Please review our Privacy Policy to
                    understand how we collect, use, and protect your personal information.
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Prohibited Activities
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    Welcome to {{ site('name') }}! By accessing or using our services, including but not limited to our
                    website,
                    trading platform, and any associated software or applications (collectively referred to as the
                    "Services"), you agree to be bound by these Terms of Service ("Terms"). If you do not agree to these
                    Terms, please do not use our Services.
                </p>

                <p class="lg:text-lg text-white font-extralight tracking-wider">
                <ul class="list-disc text-white px-5">
                    <li>You agree not to engage in any of the following prohibited activities while using our Services:</li>
                    <li>Violating any applicable laws or regulations.</li>
                    <li>Impersonating any person or entity or providing false information.</li>
                    <li>Attempting to gain unauthorized access to our Services or computer systems.</li>
                    <li>Interfering with the proper functioning of our Services.</li>
                    <li>Engaging in any activity that could harm, disable, or overburden our infrastructure.</li>
                </ul>
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Termination of Services
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    We reserve the right to terminate or suspend your access to our Services at our discretion, without
                    notice, for any reason, including if we believe you have violated these Terms. You may also terminate
                    your account at any time by discontinuing use of our Services.
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Disclaimer of Warranties
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    Our Services are provided "as is" and "as available" without warranties of any kind, either express or
                    implied. We do not guarantee the accuracy, reliability, or availability of our Services or the results
                    obtained through their use. You use our Services at your own risk.
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Limitation of Liability
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    To the fullest extent permitted by applicable law, {{ site('name') }} and its affiliates, officers,
                    directors,
                    employees, and agents shall not be liable for any indirect, incidental, special, consequential, or
                    punitive damages, or any loss of profits or revenues, whether incurred directly or indirectly, or any
                    loss of data, use, goodwill, or other intangible losses, resulting from
                <ul class="list-disc text-white px-5">
                    <li>(a) your use or inability to use our Services, </li>
                    <li>(b) any unauthorized access to or use of our servers and/or any personal information stored therein,
                    </li>
                    <li>(c) any interruption or cessation of our Services, </li>
                    <li>(d) any bugs, viruses, or other harmful code that may be transmitted to or through our Services, or
                    </li>
                    <li>(e) any errors, inaccuracies, omissions, or any other aspect of our Services.</li>
                </ul>
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Intellectual Property
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    All content included in or made available through our Services, including text, graphics, logos, button
                    icons, images, audio clips, digital downloads, and data compilations, is the property of
                    {{ site('name') }} or
                    its content suppliers and is protected by United States and international copyright laws.
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Changes to Terms
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    We reserve the right to modify or revise these Terms at any time. The most current version of these
                    Terms will be posted on our website. Your continued use of our Services following the posting of any
                    changes constitutes your acceptance of those changes.
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Governing Law
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    These Terms are governed by and construed in accordance with the laws of the State of England, without
                    regard to its conflict of law principles.
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Contact Information
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    If you have any questions about these Terms or our Services, please contact us at {{ site('email') }}.
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    User Responsibilities
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    As a user of {{ site('name') }}'s Services, you agree to:
                <ul class="list-disc text-white px-5">
                    <li>Comply with all applicable laws and regulations related to trading and financial transactions.</li>
                    <li>Keep your account information, including passwords, secure and confidential.</li>
                    <li>Use our Services only for lawful purposes.</li>
                    <li>Refrain from attempting to disrupt or interfere with the proper functioning of our Services.</li>
                    <li>Report any security breaches or unauthorized access to our Services promptly.</li>
                </ul>
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Account Suspension and Termination
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    {{ site('name') }} reserves the right to suspend or terminate user accounts for violations of these
                    Terms or for
                    any other reason, at its sole discretion.
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Third-Party Links and Services
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    Our Services may contain links to third-party websites or services. {{ site('name') }} does not endorse
                    or
                    control these third-party websites or services and is not responsible for their content or practices.
                    Use of third-party websites or services is at your own risk.
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Indemnification
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    You agree to indemnify and hold {{ site('name') }}, its affiliates, officers, directors, employees, and
                    agents
                    harmless from any claims, losses, damages, liabilities, and expenses (including attorney's fees) arising
                    from or related to your use of our Services or violation of these Terms.
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Dispute Resolution
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    Any disputes arising from or relating to these Terms or your use of our Services shall be resolved
                    through arbitration in accordance with the rules of the England Arbitration Association. The arbitration
                    shall take place in London, London, and the decision of the arbitrator shall be final and binding.
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Entire Agreement
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    These Terms constitute the entire agreement between you and {{ site('name') }} with respect to the
                    subject
                    matter hereof and supersedes all prior or contemporaneous communications and proposals, whether oral or
                    written, between the parties.
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Assignment
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    You may not assign or transfer these Terms, in whole or in part, without the prior written consent of
                    {{ site('name') }}. {{ site('name') }} may freely assign these Terms without restriction.
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Waiver and Severability
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    The failure of {{ site('name') }} to enforce any right or provision of these Terms shall not
                    constitute a waiver
                    of such right or provision. If any provision of these Terms is found by a court of competent
                    jurisdiction to be invalid, the parties nevertheless agree that the court should endeavor to give effect
                    to the parties' intentions as reflected in the provision, and the other provisions of these Terms remain
                    in full force and effect.
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    No Third-Party Beneficiaries
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    These Terms do not create any third-party beneficiary right
                </p>
            </div>

            <div class="w-full text-justify mb-10">
                <p
                    class="font-bold uppercase lg:text-2xl text-xl lg:mb-6 mb-4 bg-gradient-to-r from-[#D198F9] via-[#0E63B7] via-[10%] to-[#95E3FD] to-[30%] bg-clip-text text-transparent">
                    Contact Us
                </p>
                <p class="lg:text-lg text-white font-extralight tracking-wider">
                    If you have any questions or concerns about these Terms, please contact us at <span
                        class="text-[#E39DFF]">{{ site('email') }}.</span>
                </p>
            </div>

        </div>
    </section>
@endsection


@section('scripts')
@endsection
