@php

    $page_title = 'Live AI trading';
    $short_description = 'Watch live trading done by our trading bot as the execute these trades';

@endphp

{{-- layout --}}
@extends('templates.'. site('template') .'.layouts.front')


@section('css')
@endsection

@section('header')
<div class="w-full flex-1 lg:py-32">
    <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto px-3 lg:pt-52 pt-32" data-aos="fade-up">


      <div class="block max-w-screen-lg mx-auto lg:mb-24 mb-10">
        <div class="flex justify-center items-center gap-3">
          <div class="line"></div>
          <div class="pricing-text text-[#ffffff] lg:text-6xl text-2xl"><span class="font-bold">Live</span> Ai</div>
          <div class="line2"></div>
        </div>

        <div class="block text-center py-3">
          <p class="lg:text-2xl text-lg text-white font-extralight"> 
            <a href="" class="text-[#D8D8D8] text-opacity-45">Home</a> / <a href="">Live Ai</a>
          </p>
        </div>
      </div>

      <div class="block max-w-screen-lg mx-auto mb-10 p-2">
        <p class="text-center text-[#95E3FD] uppercase py-5">Live Ai</p>
        <p class="text-center lg:text-6xl text-2xl lg:mb-3 lg:max-w-screen-lg">
          <span class="bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[20%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">Live AI <b class="font-bold">Trading</b></span>
        </p>

        <p class="lg:text-2xl text-lg text-white font-extralight text-center">Watch live trading done by our trading bot as the execute these trades</p>
      </div>


    </div>
  </div>
@endsection


@section('contents')
    {{-- live trade --}}
    <section class="w-full mb-10 " data-aos="fade-up">
        <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto px-3 lg:py-10">
  
          <div class="block max-w-screen-lg mx-auto">
            <div class="flex justify-center items-center gap-3">
              <div class="line"></div>
              <div class="pricing-text text-[#95E3FD]">BOTS</div>
              <div class="line2"></div>
            </div>
          </div>
  
          <div class="flex justify-center w-full mb-5">
            <p class="text-center font-bold lg:text-6xl text-2xl lg:mb-3 lg:max-w-screen-lg">
              <span class="font-bold bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[20%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">Live Trades</span>
            </p>
          </div>
  
          <div class="w-full bg-blue-200 bg-opacity-5 border border-opacity-25 border-[#0E63B7] p-10">
  
            <div class="block overflow-auto w-full" style="max-height: 80vh;">
              <table class="w-full">
                <tbody id="tradeTableBody"></tbody> 
              </table>
            </div>
  
          </div>
  
        </div> 
      </section>
@endsection

@section('scripts')
    {{-- recent trades table data --}}
    <script>
        let tradeData = @json(recentTradesAll());

        const tradeData1 = [{
                time: "2025-01-30T07:40:31Z",
                location: "Macao",
                network: "490.25",
                aibot: "GYRON-8MIG",
                market: "SPELLUSDT",
                price: "8,486.11",
                trend: "-4.25"
            },
            {
                time: "2025-01-30T07:40:31Z",
                location: "Macao",
                network: "490.25",
                aibot: "GYRON-8MIG",
                market: "SPELLUSDT",
                price: "8,486.11",
                trend: "+4.25"
            },
            {
                time: "2025-01-30T07:40:31Z",
                location: "Macao",
                network: "490.25",
                aibot: "GYRON-8MIG",
                market: "SPELLUSDT",
                price: "8,486.11",
                trend: "+4.25"
            },
            {
                time: "2025-01-30T07:40:31Z",
                location: "Macao",
                network: "490.25",
                aibot: "GYRON-8MIG",
                market: "SPELLUSDT",
                price: "8,486.11",
                trend: "+4.25"
            },
            {
                time: "2025-01-30T07:40:31Z",
                location: "Macao",
                network: "490.25",
                aibot: "GYRON-8MIG",
                market: "SPELLUSDT",
                price: "8,486.11",
                trend: "+4.25"
            },
            {
                time: "2025-01-30T07:40:31Z",
                location: "Macao",
                network: "490.25",
                aibot: "GYRON-8MIG",
                market: "SPELLUSDT",
                price: "8,486.11",
                trend: "+4.25"
            },
            {
                time: "2025-01-30T07:40:31Z",
                location: "Macao",
                network: "490.25",
                aibot: "GYRON-8MIG",
                market: "SPELLUSDT",
                price: "8,486.11",
                trend: "-4.25"
            },
            {
                time: "2025-01-30T07:40:31Z",
                location: "Macao",
                network: "490.25",
                aibot: "GYRON-8MIG",
                market: "SPELLUSDT",
                price: "8,486.11",
                trend: "+4.25"
            },
            {
                time: "2025-01-30T07:40:31Z",
                location: "Macao",
                network: "490.25",
                aibot: "GYRON-8MIG",
                market: "SPELLUSDT",
                price: "8,486.11",
                trend: "+4.25"
            },
            {
                time: "2025-01-30T07:40:31Z",
                location: "Macao",
                network: "490.25",
                aibot: "GYRON-8MIG",
                market: "SPELLUSDT",
                price: "8,486.11",
                trend: "+4.25"
            },
            {
                time: "2025-01-30T07:40:31Z",
                location: "Macao",
                network: "490.25",
                aibot: "GYRON-8MIG",
                market: "SPELLUSDT",
                price: "8,486.11",
                trend: "-4.25"
            },
            {
                time: "2025-01-30T07:40:31Z",
                location: "Macao",
                network: "490.25",
                aibot: "GYRON-8MIG",
                market: "SPELLUSDT",
                price: "8,486.11",
                trend: "+4.25"
            },
            {
                time: "2025-01-30T07:40:31Z",
                location: "Macao",
                network: "490.25",
                aibot: "GYRON-8MIG",
                market: "SPELLUSDT",
                price: "8,486.11",
                trend: "+4.25"
            },
            {
                time: "2025-01-30T07:40:31Z",
                location: "Macao",
                network: "490.25",
                aibot: "GYRON-8MIG",
                market: "SPELLUSDT",
                price: "8,486.11",
                trend: "-4.25"
            },
            {
                time: "2025-01-30T07:40:31Z",
                location: "Macao",
                network: "490.25",
                aibot: "GYRON-8MIG",
                market: "SPELLUSDT",
                price: "8,486.11",
                trend: "+4.25"
            },
            {
                time: "2025-01-30T07:40:31Z",
                location: "Macao",
                network: "490.25",
                aibot: "GYRON-8MIG",
                market: "SPELLUSDT",
                price: "8,486.11",
                trend: "-4.25"
            },
            {
                time: "2025-01-30T07:40:31Z",
                location: "Macao",
                network: "490.25",
                aibot: "GYRON-8MIG",
                market: "SPELLUSDT",
                price: "8,486.11",
                trend: "+4.25"
            },
        ];

        function updateTradeTable() {
            const tableBody = document.getElementById("tradeTableBody");
            tableBody.innerHTML = ""; // Clear existing rows

            tradeData.forEach((trade) => {
                const row = document.createElement("tr");
                row.className = `border-b border-opacity-25 border-blue-200 py-6 ${
            trade.profit.startsWith("-") ? "text-[#EA0A0E]" : "text-[#00AA39]"
        }`;

                row.innerHTML = `
            <td class="p-2 py-6"><p class="px-4">${new Date().toLocaleTimeString()}</p></td>
            <td class="p-2 py-6 text-right"><p class="px-4">${trade.country}</p></td>
            <td class="p-2 py-6 text-right"><p class="px-4">${trade.exchange}</p></td>
            <td class="p-2 py-6 text-right"><p class="px-4">${trade.bot}</p></td>
            <td class="p-2 py-6 text-right"><p class="px-4">${trade.pair}</p></td>
            <td class="p-2 py-6 text-right"><p class="px-4">$ ${trade.amount}</p></td>
            <td class="p-2 py-6 text-right"><p class="px-4">${trade.profit}</p></td>
        `;

                tableBody.appendChild(row);
            });
        }

        // Function to swap first row to last every 2 seconds
        function rotateRows() {
            if (tradeData.length > 1) {
                const firstRow = tradeData.shift(); // Remove first row
                tradeData.push(firstRow); // Add it to the end
                updateTradeTable(); // Refresh the table with new order
            }
        }

        // Initial table setup
        updateTradeTable();

        // Start row rotation every 2 seconds
        setInterval(rotateRows, 1000);
    </script>
@endsection
