<div class="flex justify-center items-center mt-4 gap-4 py-10 text-white">
    @if ($paginator->onFirstPage())
        <span class="px-3 py-1 border-b border-[#40DDFF] rounded-md" aria-disabled="true">
            <img src="{{ asset('/assets/templates/dome/images/dash/icon/ep_arrow-left.svg') }}" alt="">
        </span>
    @else
        <a href="{{ $paginator->previousPageUrl() }}" rel="prev"
            class="px-2 py-1 border-b border-[#40DDFF] rounded-md paginator-link flex items-center justify-center"
            aria-disabled="true">
            <img src="{{ asset('/assets/templates/dome/images/dash/icon/ep_arrow-left.svg') }}" alt="">
        </a>
    @endif

    <!-- Pagination Links -->
    {{-- @php
        $pageCount = $paginator->lastPage();
        $currentPage = $paginator->currentPage();
        $startIndex = $currentPage <= 2 ? 1 : max($currentPage - 2, 1);
        $endIndex = $currentPage <= 2 ? min($pageCount, 6) : min($currentPage + 2, $pageCount);
    @endphp --}}
    @php
        $pageCount = $paginator->lastPage();
        $currentPage = $paginator->currentPage();

        if ($currentPage <= 2) {
            $startIndex = 1;
            $endIndex = min(3, $pageCount);
        } else {
            $startIndex = $currentPage - 1;
            $endIndex = min($currentPage + 1, $pageCount);
        }
    @endphp

    @for ($i = $startIndex; $i <= $endIndex; $i++)
        @if ($i == $currentPage)
            <div
                class="px-2 py-1 text-white border-l border-l-[#40DDFF] border-b border-b-[#40DDFF] border-r border-r-[#D386F2] border-t border-t-[#D386F2] rounded-md not-allowed-cursor">
                <span>{{ $i }}</span>
            </div>
        @else
            <a class="px-2 py-1 border-b border-[#40DDFF] rounded-md paginator-link  flex items-center justify-center"
                href="{{ $paginator->url($i) }}">{{ $i }}</a>
        @endif
    @endfor

    @if ($currentPage < $pageCount - 1)
        <div class="disabled px-3 py-1 border-b border-[#40DDFF] rounded-md"><span>...</span></div>
        <a href="{{ $paginator->url($pageCount) }}"
            class="px-3 py-1 border-b border-[#40DDFF] rounded-md paginator-link  flex items-center justify-center">
            {{ $pageCount }}
        </a>
    @endif


    @if ($paginator->hasMorePages())
        <a href="{{ $paginator->nextPageUrl() }}" rel="next"
            class="px-2 py-1 border-l border-l-[#40DDFF] border-b border-b-[#40DDFF] border-r border-r-[#D386F2] border-t border-t-[#D386F2] rounded-md paginator-link  flex items-center justify-center">
            <img src="{{ asset('/assets/templates/dome/images/dash/icon/ep_arrow-right.svg') }}" alt="">
        </a>
    @else
        <span class="px-3 py-1 border-b border-[#40DDFF] rounded-md">
            <img src="{{ asset('/assets/templates/dome/images/dash/icon/ep_arrow-right.svg') }}" alt="">
        </span>
    @endif

</div>
