@extends('templates.' . site('template') . '.layouts.auth')

@section('css')
@endsection


@section('contents')
    {{-- Main login secton --}}
    <div class="min-h-screen w-full flex items-center justify-center" data-aos="zoom-in-up">

        <div class="block w-full">

            <div class="max-w-screen-sm mx-auto p-4" data-aos="fade-right">

                <a href="{{ route('home') }}" class="text-white flex gap-2  py-2 px-4 rounded-md w-32 mb-10">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                        style="fill: #ffffff;transform: ;msFilter:;">
                        <path d="M12.707 17.293 8.414 13H18v-2H8.414l4.293-4.293-1.414-1.414L4.586 12l6.707 6.707z"></path>
                    </svg>
                    <span class="text-white">Back</span>
                </a>

                <div class="px-4 lg:px-10 mt-6 space-y-6">
                    <p id="noticeMsgOtp" class="hidden noticeMsg"
                        style="position: relative; background-color: #f8f9fa; padding: 16px; border-left: 8px solid #A22ADA; border-radius: 6px; box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1); max-width: 400px; margin: 20px auto; ">
                    </p>
                </div>


                <div class="@if (user()) hidden @endif" id="loginFormContainer">
                    <div class="text-white mb-10 text-center">
                        <p class="text-4xl mb-4 font-thin"><span
                                class="bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)] bg-clip-text text-transparent">Welcome
                                <span class="font-bold">Back</span></span></p>
                        <p class="text-lg">Please enter your details</p>
                    </div>

                    <form action="{{ route('user.login-validate') }}" method="POST" id="loginForm">
                        @csrf
                        <div class="w-full mb-10">
                            <label for="email" class="text-white">Email Address</label>
                            <div class="w-full text-white border p-3 rounded-2xl mt-4">
                                <div class="w-full">
                                    <input type="text" id="email" name="email"
                                        class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                        placeholder="Enter Email Address" required
                                        @if (env('DEMO_MODE')) value="user@user.com" @endif>
                                </div>
                            </div>

                            <span>
                                @error('email')
                                    {{ $message }}
                                @enderror
                            </span>
                        </div>

                        <div class="w-full mb-10">
                            <label for="password" class="text-white">Password</label>
                            <div class="w-full text-white border p-3 rounded-2xl mt-4">
                                <div class="w-full">
                                    <input type="password" id="password" name="password"
                                        class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                        placeholder="Enter Password"
                                        @if (env('DEMO_MODE')) value="password" @endif>
                                </div>
                            </div>

                            <span>
                                @error('password')
                                    {{ $message }}
                                @enderror
                            </span>
                        </div>

                        <div class="w-full  mb-20 flex justify-between text-white">
                            <div class="flex gap-3 hover:text-[#832ED1]">
                                <input type="checkbox" id="remember" class="peer hidden" />
                                <div
                                    class="h-5 w-5 rounded bg-[url('../../../assets/images/front/icon/gradient-CheckboxInteraction.svg')] peer-checked:bg-green-500 bg-cover bg-center transition-colors duration-300">
                                </div>
                                <label for="remember">Remember me</label>
                            </div>
                            <a href="{{ route('user.forgot-password.index') }}">Forgot password</a>
                        </div>

                        <div class="w-full mb-4">
                            <div class="text-center">
                                <button type="submit" id="loginBtn"
                                    class="border text-white rounded-full px-10 py-4 w-full bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]">Login</button>
                            </div>
                        </div>

                        <div class="w-full mb-4">
                            <p class="text-center text-[#B4B1B1]"> Don’t have an account? <a
                                    href="{{ route('user.register') }}" class="text-white"> Sign Up</a></p>
                        </div>

                    </form>

                </div>

                <div class="@if (!user()) hidden @endif" id="verifyFormContainer">
                    <div class="text-white mb-10 text-center">
                        <p class="text-4xl mb-4 font-thin"><span
                                class="bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)] bg-clip-text text-transparent">Input
                                <span class="font-bold">OTP</span></span></p>
                        <p class="text-lg">Enter the OTP Sent to your Email</p>
                    </div>

                    <form action="{{ route('user.login-verify') }}" method="POST" id="verifyForm">
                        @csrf
                        <div class="w-full mb-20 flex items-center justify-center">

                            <div class="flex lg:gap-10 gap-6 text-white">
                                <input type="number" maxlength="1" name="otp[]" autofocus
                                    class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                                <input type="number" maxlength="1" name="otp[]"
                                    class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                                <input type="number" maxlength="1" name="otp[]"
                                    class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                                <input type="number" maxlength="1" name="otp[]"
                                    class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                                <input type="number" maxlength="1" name="otp[]"
                                    class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                                <input type="number" maxlength="1" name="otp[]"
                                    class="otp-input w-10 h-10 text-center text-xl bg-transparent border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-500 focus:outline-none" />
                            </div>
                            <input type="hidden" name="otp" id="otp" value="" required maxlength="6">

                            <span>
                                @error('otp')
                                    {{ $message }}
                                @enderror
                            </span>

                        </div>

                        <div class="w-full mb-4">
                            <div class="text-center">
                                <button type="submit" id="verifyBtn"
                                    class="border text-white rounded-full px-10 py-4 w-full bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]">Send
                                    Code</button>
                            </div>
                        </div>

                        <div class="text-center text-white py-5">
                            <button type="button" class="hover:text-purple-700" id="resendBtn">Resend OTP</button>
                        </div>

                    </form>
                </div>

            </div>
        </div>

    </div>
@endsection

@section('scripts')
    <script>
        $('#noticeMsgLogin').text("verifyText").show();

        $(document).ready(function() {

            $('#loginForm').submit(function(e) {
                e.preventDefault();

                var form = $(this);
                var formData = form.serialize();
                var clicked = $('#loginBtn');

                //disable the submit button
                clicked.addClass('relative disabled');
                clicked.append('<span class="button-spinner"></span>');
                clicked.prop('disabled', true);

                //custom styling
                clicked.addClass('disabled-button');
                clicked.removeClass(
                    'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                );

                $.ajax({
                    url: form.attr('action'),
                    type: 'POST',
                    data: formData,
                    dataType: 'json',
                    success: function(response) {
                        var verifyText = response.message;
                        var verify = response.verify;
                        $('.noticeMsg').html(verifyText).show();

                        if (verify == 1) {
                            //hide register form and display verification form
                            $('#loginFormContainer').hide();
                            $('#verifyFormContainer').show();

                            //update page title
                            $('#page-title').html('Verify OTP');
                        } else {
                            var url = '{{ route('user.dashboard') }}';
                            window.location.href = url;
                        }




                    },
                    error: function(xhr, status, error) {
                        $('#loginBtn').show();
                        var errors = xhr.responseJSON.errors;

                        if (errors) {
                            $.each(errors, function(field, messages) {
                                var fieldErrors = '';
                                $.each(messages, function(index, message) {
                                    fieldErrors += message + '<br>';
                                });


                                toastNotify('error', fieldErrors);
                            });
                        } else {
                            toastNotify('error', 'An error occured, please try again later');
                        }


                    },
                    complete: function() {
                        clicked.removeClass('disabled');
                        clicked.find('.button-spinner').remove();
                        clicked.prop('disabled', false);

                        //custom styling
                        clicked.removeClass('disabled-button');
                        clicked.addClass(
                            'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                        );

                    }

                });
            });


            //otp form
            $('#verifyForm').submit(function(e) {
                e.preventDefault();

                var form = $(this);
                var formData = form.serialize();
                var clicked = $('#verifyBtn');

                //disable the submit button
                clicked.addClass('relative disabled');
                clicked.append('<span class="button-spinner"></span>');
                clicked.prop('disabled', true);

                //custom styling
                clicked.addClass('disabled-button');
                clicked.removeClass(
                    'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                );

                $.ajax({
                    url: form.attr('action'),
                    type: 'POST',
                    data: formData,
                    dataType: 'json',
                    success: function(response) {
                        var verifyText = response.message;

                        $('.noticeMsg').text(verifyText).show();
                        console.log(verifyText);

                        var url = '{{ route('user.dashboard') }}';
                        window.location.href = url;

                    },
                    error: function(xhr, status, error) {
                        $('#verifyBtn').show();
                        var errors = xhr.responseJSON.errors;

                        if (errors) {
                            $.each(errors, function(field, messages) {
                                var fieldErrors = '';
                                $.each(messages, function(index, message) {
                                    fieldErrors += message + '<br>';
                                });


                                toastNotify('error', fieldErrors);
                            });
                        } else {
                            toastNotify('success', 'An error occured, please try again later');
                        }


                    },
                    complete: function() {
                        clicked.removeClass('disabled');
                        clicked.find('.button-spinner').remove();
                        clicked.prop('disabled', false);

                        //custom styling
                        clicked.removeClass('disabled-button');
                        clicked.addClass(
                            'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                        );


                    }

                });
            });

        });
    </script>


    <script>
        const resendBtn = document.getElementById('resendBtn');
        const loginBtn = document.getElementById('loginBtn');
        let isClickable = true;
        let countdown;

        function startCountdown() {
            if (isClickable) {
                isClickable = false;
                resendBtn.disabled = true;

                let secondsLeft = 120; // 2 minutes
                countdown = setInterval(() => {
                    if (secondsLeft > 0) {
                        const minutes = Math.floor(secondsLeft / 60);
                        const seconds = secondsLeft % 60;
                        const formattedTime = `${minutes}:${seconds.toString().padStart(2, '0')}`;
                        resendBtn.textContent = `Resend Again in ${formattedTime}`;
                        secondsLeft--;
                    } else {
                        resendBtn.textContent = 'Resend OTP';
                        resendBtn.disabled = false;
                        isClickable = true;
                        clearInterval(countdown);
                    }
                }, 1000); // Update every 1 second
            }
        }

        resendBtn.addEventListener('click', () => {
            startCountdown();
            // Define the CSRF token
            var csrfToken = '{{ csrf_token() }}';

            // Add the CSRF token to the request headers
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': csrfToken
                }
            });

            // Send the AJAX request
            $.ajax({
                url: "{{ route('user.resend-otp') }}",
                type: 'POST',
                dataType: 'json',
                success: function(response) {
                    var verifyText = response.message;

                    toastNotify('success', verifyText);

                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;

                    if (errors) {
                        $.each(errors, function(field, messages) {
                            var fieldErrors = '';
                            $.each(messages, function(index, message) {
                                fieldErrors += message + '<br>';
                            });

                            toastNotify('error', fieldErrors);

                        });
                    } else {

                        toastNotify('error', 'An error occured, please try again later');

                    }
                }
            });




        });

        loginBtn.addEventListener('click', () => {
            startCountdown();
        });
    </script>

    {{-- <script>

                ////// Concatenate all input values
        $(document).ready(function() {
            $('.otp-input').on('input', function() {
                let otpValue = '';

                // Concatenate all input values
                $('.otp-input').each(function() {
                    otpValue += $(this).val();
                });

                // Set the hidden input value
                $('#otp').val(otpValue);
            });
        });


        
        $(document).ready(function() {
        
            const $inputs = $(".otp-input");

            $inputs.on("input", function(e) {
                const $this = $(this);
                const value = $this.val();

                if (value.length === 1) {
                    $this.next(".otp-input").focus();
                }
            });

            $inputs.on("keydown", function(e) {
                const $this = $(this);

                if (e.key === "Backspace" && !$this.val()) {
                    $this.prev(".otp-input").focus();
                }
            });

            $inputs.on("paste", function(e) {
                const pasteData = e.originalEvent.clipboardData.getData('text').slice(0, 4);

                $inputs.each(function(index) {
                    $(this).val(pasteData[index] || "");
                });
                $inputs.eq(pasteData.length).focus();
                e.preventDefault();
            });
        });
    </script> --}}

    <script>
        ////// Concatenate all input values
        $(document).ready(function() {
            $('.otp-input').on('input', function() {
                let otpValue = '';

                // Concatenate all input values
                $('.otp-input').each(function() {
                    otpValue += $(this).val();
                });

                // Set the hidden input value
                $('#otp').val(otpValue);
            });
        });


        $(document).ready(function() {
            const $inputs = $(".otp-input");

            $inputs.on("input", function(e) {
                const $this = $(this);
                const value = $this.val();

                // Allow only 1 character
                if (value.length > 1) {
                    $this.val(value.charAt(0)); // Keep only the first character
                }

                // Move focus to the next input if a character is entered
                if (value.length === 1) {
                    $this.next(".otp-input").focus();
                }
            });

            $inputs.on("keydown", function(e) {
                const $this = $(this);

                if (e.key === "Backspace" && !$this.val()) {
                    $this.prev(".otp-input").focus();
                }
            });

            $inputs.on("paste", function(e) {
                const pasteData = e.originalEvent.clipboardData.getData('text').slice(0, $inputs.length);

                // Fill inputs with pasted data, ensuring only one character per input
                $inputs.each(function(index) {
                    $(this).val(pasteData[index] || "");
                });

                // Focus on the next input after the last pasted character
                $inputs.eq(pasteData.length).focus();
                e.preventDefault();
            });
        });
    </script>
@endsection
