@extends('templates.' . site('template') . '.layouts.user')

@section('contents')
    <section class="w-full py-6" data-aos="fade-up">
        <div class="max-w-screen-2xl mx-auto mb-5">

            <div class="lg:flex justify-between items-center px-3">
                <div class="block lg:mb-3 mb-10">
                    <p
                        class="text-xl lg:text-2xl font-bold mb-6 bg-gradient-to-r from-[#3F7DF2] via-[#60A4F6] to-[#A320D8] to-[10%] bg-clip-text text-transparent">
                        AI Bots</p>
                    <div class="flex gap-4 space-y-2 text-white text-sm">
                        <button id="myAiBotsBtn" class="block ai_button_gradient_small">My Ai Bot</button>
                        <button id="aiTradingHistoryBtn" class="block">Ai Trading History</button>
                        <button id="dailySummaryBtn" class="block">Daily Summary</button>
                    </div>
                </div>

                <div class="block mb-3">
                    <button id="openAiBotActivationModal"
                        class="lg:w-60 border rounded-full lg:py-4 py-2 lg:px-10 px-5 block text-center text-white text-lg bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)] hover:text-white">Activate
                        Ai Bot</button>
                </div>
            </div>

        </div>
    </section>

    <section class="lg:w-full w-screen py-6" data-aos="fade-up">
        <div class="max-w-screen-2xl mx-auto mb-5">

            <!--my ai bots table-->
            <div id="myAiBots" class="overflow-x-auto text-white">
                <div id="bots">
                    <table class="w-full border-collapse table-auto">
                        <thead class="text-left h-14" data-bot_count="{{ $activations->total() }}" id="botTable">
                            <tr>
                                <th class="px-6 py-2 font-light  min-w-80">My Bots</th>
                                <th class="px-6 py-2 font-light  min-w-52">Portfolio/DT</th>
                                <th class="px-6 py-2 font-light  min-w-52">Portfolio Balance</th>
                                <th class="text-right px-6 py-2 font-light  min-w-52">Count Down</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($activations as $bot)
                                <tr class="border-b border-opacity-25 border-blue-200">
                                    <td class="py-2 px-6">
                                        <div class="flex items-center gap-4 ">
                                            <img src="{{ asset('storage/bots/' . $bot->bot->logo) }}"
                                                class="w-14 h-14 rounded-full" alt="bot">
                                            <div class="block">
                                                <p class="flex gap-2">
                                                    {{ $bot->bot->name }}
                                                    @if ($bot->status == 'active')
                                                        <svg width="24" height="25" viewBox="0 0 24 25"
                                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path opacity="0.3" fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M10.6319 1.64199C10.9859 1.28847 11.4595 1.08045 11.9593 1.05897C12.4591 1.0375 12.9489 1.20413 13.3319 1.52599L13.4599 1.64299L15.3599 3.54199H18.0459C18.5503 3.54209 19.036 3.73277 19.4058 4.07583C19.7756 4.4189 20.002 4.88901 20.0399 5.39199L20.0459 5.54199V8.22799L21.9459 10.128C22.2997 10.482 22.5079 10.9559 22.5293 11.4559C22.5508 11.956 22.384 12.4459 22.0619 12.829L21.9449 12.956L20.0449 14.856V17.542C20.045 18.0466 19.8545 18.5326 19.5114 18.9025C19.1683 19.2725 18.698 19.4992 18.1949 19.537L18.0459 19.542H15.3609L13.4609 21.442C13.1068 21.7958 12.633 22.004 12.1329 22.0255C11.6329 22.0469 11.1429 21.8801 10.7599 21.558L10.6329 21.442L8.73287 19.542H6.04587C5.54129 19.5422 5.0553 19.3516 4.68532 19.0085C4.31534 18.6654 4.08871 18.1951 4.05087 17.692L4.04587 17.542V14.856L2.14587 12.956C1.79206 12.602 1.58387 12.1281 1.56239 11.6281C1.54091 11.128 1.70772 10.6381 2.02987 10.255L2.14587 10.128L4.04587 8.22799V5.54199C4.04596 5.03759 4.23664 4.55185 4.57971 4.18208C4.92277 3.81231 5.39289 3.58582 5.89587 3.54799L6.04587 3.54199H8.73187L10.6319 1.64199Z"
                                                                fill="#00AA39" />
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M15.1255 8.52497L10.8815 12.769L9.11345 11.001C8.92581 10.8135 8.67137 10.7082 8.4061 10.7083C8.14083 10.7084 7.88646 10.8138 7.69895 11.0015C7.51144 11.1891 7.40616 11.4436 7.40625 11.7088C7.40634 11.9741 7.51181 12.2285 7.69945 12.416L10.1035 14.82C10.2056 14.9222 10.3269 15.0032 10.4604 15.0586C10.5939 15.1139 10.737 15.1423 10.8815 15.1423C11.0259 15.1423 11.169 15.1139 11.3025 15.0586C11.436 15.0032 11.5573 14.9222 11.6595 14.82L16.5395 9.93897C16.7216 9.75037 16.8224 9.49777 16.8201 9.23557C16.8178 8.97338 16.7127 8.72256 16.5273 8.53716C16.3419 8.35175 16.0911 8.24658 15.8289 8.2443C15.5667 8.24202 15.3141 8.34282 15.1255 8.52497Z"
                                                                fill="#F0FCFF" />
                                                        </svg>
                                                    @else
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5"
                                                            fill="#6b7280" class="bi bi-patch-exclamation-fill"
                                                            viewBox="0 0 16 16">
                                                            <path
                                                                d="M10.067.87a2.89 2.89 0 0 0-4.134 0l-.622.638-.89-.011a2.89 2.89 0 0 0-2.924 2.924l.01.89-.636.622a2.89 2.89 0 0 0 0 4.134l.637.622-.011.89a2.89 2.89 0 0 0 2.924 2.924l.89-.01.622.636a2.89 2.89 0 0 0 4.134 0l.622-.637.89.011a2.89 2.89 0 0 0 2.924-2.924l-.01-.89.636-.622a2.89 2.89 0 0 0 0-4.134l-.637-.622.011-.89a2.89 2.89 0 0 0-2.924-2.924l-.89.01-.622-.636zM8 4c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 4.995A.905.905 0 0 1 8 4zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                                        </svg>
                                                    @endif
                                                </p>
                                                <p class="flex gap-2 text-sm">
                                                    <span class="text-[#EA0A0E]">PNL</span>
                                                    @if ($bot->profit < 0)
                                                        <span
                                                            class="text-[#EA0A0E] flex space-x-1"><span>{{ ($bot->profit / $bot->capital) * 100 }}%</span>
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                                fill="currentColor" class="w-6 h-6">
                                                                <path fill-rule="evenodd"
                                                                    d="M1.72 5.47a.75.75 0 011.06 0L9 11.69l3.756-3.756a.75.75 0 01.985-.066 12.698 12.698 0 014.575 6.832l.308 1.149 2.277-3.943a.75.75 0 111.299.75l-3.182 5.51a.75.75 0 01-1.025.275l-5.511-3.181a.75.75 0 01.75-1.3l3.943 2.277-.308-1.149a11.194 11.194 0 00-3.528-5.617l-3.809 3.81a.75.75 0 01-1.06 0L1.72 6.53a.75.75 0 010-1.061z"
                                                                    clip-rule="evenodd" />
                                                            </svg>
                                                        </span>
                                                    @else
                                                        <span
                                                            class="text-[#00AA39] flex space-x-1"><span>+{{ ($bot->profit / $bot->capital) * 100 }}%</span>
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                                fill="currentColor" class="w-6 h-6">
                                                                <path fill-rule="evenodd"
                                                                    d="M15.22 6.268a.75.75 0 01.968-.432l5.942 2.28a.75.75 0 01.431.97l-2.28 5.941a.75.75 0 11-1.4-.537l1.63-4.251-1.086.483a11.2 11.2 0 00-5.45 5.174.75.75 0 01-1.199.19L9 12.31l-6.22 6.22a.75.75 0 11-1.06-1.06l6.75-6.75a.75.75 0 011.06 0l3.606 3.605a12.694 12.694 0 015.68-4.973l1.086-.484-4.251-1.631a.75.75 0 01-.432-.97z"
                                                                    clip-rule="evenodd" />
                                                            </svg>
                                                        </span>
                                                    @endif
                                                </p>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="py-2 px-6">
                                        <p>{{ formatAmount($bot->capital) }}</p>
                                        <p class="text-xs text-[#FC8B09]">Activation Date/Time</p>
                                        <p class="text-xs"> <span
                                                class="local-time">{{ date('d-m-y H:i:s', strtotime($bot->created_at)) }}</span>
                                        </p>
                                    </td>

                                    <td class="py-2 px-6">
                                        <p>
                                            <span>{{ formatAmount($bot->balance) }}</span>
                                        </p>
                                    </td>

                                    <td class="py-2 text-right px-6">
                                        <span
                                            class="rounded-lg bg-gray-400 bg-opacity-15 w-auto p-2  @if ($bot->expires_in < time()) text-[#EA0A0E] @else text-[#309AFF] @endif ">
                                            <a role="button" class="cursor-pointer"
                                                id="{{ 'bot_timer_' . $loop->iteration }}">time
                                            </a>
                                        </span>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td
                                        class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg border border-slate-800 hover:border-slate-600 cursor-pointer">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-orange-500"
                                            fill="currentColor" class="bi bi-exclamation-triangle-fill" viewBox="0 0 16 16">
                                            <path
                                                d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                        </svg>
                                        <span>You have not activated any bot</span>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>

                    <div class="cursor-pointer simple-pagination" data-paginator="bots">
                        {{ $activations->links('templates.' . site('template') . '.paginations.simple') }}
                    </div>
                </div>
            </div>

            <!--ai trading history-->
            <div id="aiTradingHistory" class="hidden mb-10 w-full lg:px-6">

                <div id="bot-history">
                    <!--Al Trading View chart-->
                    <div class="w-full py-6 mb-6" data-aos="fade-up">
                        <div class="block mb-3 text-white">
                            <h1
                                class="text-xl lg:text-2xl font-bold mb-6 bg-gradient-to-tr from-[#3F7DF2] from-[10%] via-[#60A4F6] via-[20%] via-[#95E3FD] via-[30%] to-[#A320D8] to-[40%] bg-clip-text text-transparent">
                                AI Trading Overview (7 Day PNL)</h1>
                            <div class="bg-cover bg-no-repeat bg-center">
                                <canvas id="canvas" class="w-full min-h-[50vh]"></canvas>
                            </div>
                        </div>
                    </div>
                    <!--end ai tradeing view chart-->

                    <div id="bot-history-grid">
                        <div data-aos="zoom-in" id="ai_trading_overview_table"
                            class="block mb-10 border-t border-[#A320D8] text-white rounded-2xl overflow-auto h-[80vh] w-full py-10">
                            <table class="w-full table-auto min-w-[800px]">
                                <thead class="text-center">
                                    <th class="p-6 text-left  font-light">AI Bots</th>
                                    <th class="p-6 text-right  font-light">PNL</th>
                                    <th class="p-6 text-left font-light">Entry Price</th>
                                    <th class="p-6 text-left font-light">Exiting Price</th>
                                    <th class="p-6 text-left font-light">Trading Pair</th>
                                    <th></th>
                                </thead>
                                <tbody>
                                    @forelse ($histories as $history)
                                        <tr class="border-b border-opacity-25 border-blue-500">
                                            <td class="p-6">
                                                <div class="flex items-center gap-4 ">
                                                    <img src="{{ asset('storage/bots/' . $history->botActivation->bot->logo) }}"
                                                        alt="bot" class="w-12 h-14 rounded-full">
                                                    <div class="block">
                                                        <p class="font-bold">{{ $history->botActivation->bot->name }}</p>
                                                        <p class=" text-gray-200 text-sm">
                                                            <span>{{ date('d-m-y', $history->timestamp) }}</span> /
                                                            <span>{{ date('H:i:s', $history->timestamp) }}</span>
                                                        </p>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="text-right p-6 text-sm">
                                                @if ($history->profit < 0)
                                                    <p class="text-[#D91414]">
                                                        -{{ formatAmount(str_replace('-', '', $history->profit)) }}</ </p>
                                                    @else
                                                    <p class="text-[#00AA39]">
                                                        +{{ formatAmount($history->profit) }}
                                                    </p>
                                                @endif

                                                <div class="flex gap-4 justify-end">
                                                    @if ($history->profit < 0)
                                                        <p class="flex justify-end items-center text-[#D91414]">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                                fill="currentColor" class="w-6 h-6">
                                                                <path fill-rule="evenodd"
                                                                    d="M1.72 5.47a.75.75 0 011.06 0L9 11.69l3.756-3.756a.75.75 0 01.985-.066 12.698 12.698 0 014.575 6.832l.308 1.149 2.277-3.943a.75.75 0 111.299.75l-3.182 5.51a.75.75 0 01-1.025.275l-5.511-3.181a.75.75 0 01.75-1.3l3.943 2.277-.308-1.149a11.194 11.194 0 00-3.528-5.617l-3.809 3.81a.75.75 0 01-1.06 0L1.72 6.53a.75.75 0 010-1.061z"
                                                                    clip-rule="evenodd" />
                                                            </svg>
                                                        </p>
                                                        <p class="flex justify-end items-center text-[#D91414]">
                                                            {{ number_format((($history->exit_price - $history->entry_price) / $history->entry_price) * 100, 2) }}%
                                                        </p>
                                                    @else
                                                        <p class="flex justify-end items-center text-[#00AA39]">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                                fill="currentColor" class="w-6 h-6">
                                                                <path fill-rule="evenodd"
                                                                    d="M15.22 6.268a.75.75 0 01.968-.432l5.942 2.28a.75.75 0 01.431.97l-2.28 5.941a.75.75 0 11-1.4-.537l1.63-4.251-1.086.483a11.2 11.2 0 00-5.45 5.174.75.75 0 01-1.199.19L9 12.31l-6.22 6.22a.75.75 0 11-1.06-1.06l6.75-6.75a.75.75 0 011.06 0l3.606 3.605a12.694 12.694 0 015.68-4.973l1.086-.484-4.251-1.631a.75.75 0 01-.432-.97z"
                                                                    clip-rule="evenodd" />
                                                            </svg>
                                                        </p>
                                                        <p class="flex justify-end items-center text-[#00AA39]">
                                                            +{{ number_format((($history->exit_price - $history->entry_price) / $history->entry_price) * 100, 2) }}%
                                                        </p>
                                                    @endif

                                                </div>
                                            </td>
                                            <td class="text-left p-6 text-sm">
                                                <p>{{ $history->entry_price }}</p>
                                            </td>
                                            <td class="text-left p-6 text-sm">
                                                <p>{{ $history->exit_price }}</p>
                                            </td>
                                            <td class="text-left p-6">
                                                <p class="px-3">{{ $history->pair }}</p>
                                            </td>
                                            <td class="text-left p-6 text-sm">
                                                <div class="flex gap-6">
                                                    <div class="flex items-center gap-2 rounded-lg lg:w-auto w-36 bg-[#E39DFF] bg-opacity-20 py-2 px-4"
                                                        style="cursor: pointer;">
                                                        <img src="{{ asset('/assets/templates/dome/images/dash/icon/pink-eye-Group.svg') }}"
                                                            alt="icon" class="w-4 h-5">
                                                        <span class="view-chart cursor-pointer text-xs text-[#E39DFF]"
                                                            data-pair="{{ $history->pair }}">View Chart</span>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td
                                                class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg border border-slate-800 hover:border-slate-600 cursor-pointer">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-orange-500"
                                                    fill="currentColor" class="bi bi-exclamation-triangle-fill"
                                                    viewBox="0 0 16 16">
                                                    <path
                                                        d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                                </svg>
                                                <span>You have not activated any bot</span>
                                            </td>
                                        </tr>
                                    @endforelse

                                </tbody>
                            </table>
                        </div>

                        <div class="cursor-pointer simple-pagination" data-paginator="bot-history-grid">
                            {{ $histories->links('templates.' . site('template') . '.paginations.simple') }}
                        </div>
                    </div>
                </div>

            </div>

            <!--daily summary-->
            <div id="dailySummary" class="hidden mb-10 overflow-auto w-full text-white">
                <div id="daily_summary">
                    <table class="w-full table-auto min-w-[800px]">
                        <thead class="text-left  h-14">
                            <th class="px-6 font-light">Date/Time</th>
                            <th class="px-6 font-light">Amount</th>
                            <th class="px-6 text-right font-light">PNL</th>
                        </thead>
                        <tbody>
                            @forelse ($daily_data as $date => $summary)
                                @if ($summary['profit'] != 0)
                                    <tr class="border-b border-opacity-25 border-blue-200 mb-4">
                                        <td class="py-4 lg:w-96 w-64 px-6">
                                            <p>{{ $date }}</p>
                                        </td>
                                        <td class="py-2 lg:w-96 w-64 px-6">
                                            <p>
                                                @if ($summary['profit'] < 0)
                                                    <span class="text-[#EA0A0E]">
                                                        -{{ formatAmount(str_replace('-', '', $summary['profit'])) }}
                                                    </span>
                                                @else
                                                    <span class="text-[#00AA39]">
                                                        <span>+{{ formatAmount($summary['profit']) }}</span>
                                                    </span>
                                                @endif
                                            </p>
                                        </td>
                                        <td class="pb-6 pt-10 text-right lg:w-96 w-64 px-6">
                                            @if ($summary['profit'] < 0)
                                                <div class="flex justify-end items-center gap-2 text-[#EA0A0E]">
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                        fill="currentColor" class="w-6 h-6">
                                                        <path fill-rule="evenodd"
                                                            d="M1.72 5.47a.75.75 0 011.06 0L9 11.69l3.756-3.756a.75.75 0 01.985-.066 12.698 12.698 0 014.575 6.832l.308 1.149 2.277-3.943a.75.75 0 111.299.75l-3.182 5.51a.75.75 0 01-1.025.275l-5.511-3.181a.75.75 0 01.75-1.3l3.943 2.277-.308-1.149a11.194 11.194 0 00-3.528-5.617l-3.809 3.81a.75.75 0 01-1.06 0L1.72 6.53a.75.75 0 010-1.061z"
                                                            clip-rule="evenodd" />
                                                    </svg>
                                                    <span>{{ number_format($summary['profit_percent'], 2) }}%</span>
                                                </div>
                                            @else
                                                <div class="flex justify-end items-center gap-2 text-[#00AA39]">
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                        fill="currentColor" class="w-6 h-6">
                                                        <path fill-rule="evenodd"
                                                            d="M15.22 6.268a.75.75 0 01.968-.432l5.942 2.28a.75.75 0 01.431.97l-2.28 5.941a.75.75 0 11-1.4-.537l1.63-4.251-1.086.483a11.2 11.2 0 00-5.45 5.174.75.75 0 01-1.199.19L9 12.31l-6.22 6.22a.75.75 0 11-1.06-1.06l6.75-6.75a.75.75 0 011.06 0l3.606 3.605a12.694 12.694 0 015.68-4.973l1.086-.484-4.251-1.631a.75.75 0 01-.432-.97z"
                                                            clip-rule="evenodd" />
                                                    </svg>
                                                    <span>+{{ number_format($summary['profit_percent'], 2) }}%</span>
                                                </div>
                                            @endif
                                        </td>
                                    </tr>
                                @endif
                            @empty
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>


        </div>
    </section>

    <!-- activate ai bot Modal -->
    <div id="aiBotActivationModal"
        class="hidden #fixed absolute z-50 inset-0  bg-opacity-50 flex items-center justify-center lg:px-6 px-2">
        <div
            class="border-t border-t-[#A320D8] border-r border-r-[#A320D8] border-b border-b-[#3F7DF2] border-l border-l-[#3F7DF2] bg-[#E39DFF] bg-opacity-10 backdrop-blur-lg rounded-xl lg:w-3/5 w-full lg:p-10 p-4 relative mt-20 lg:mr-20">

            <div class="flex justify-between items-center lg:mb-10 mb-4">
                <h2 class="text-xl font-semibold mb-4 text-white">Ai Bot Activation</h2>
                <button id="closeAiBotActivationModal" class="text-gray-400 hover:text-gray-600">
                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/pink-close-line-icons_close.svg') }}"
                        alt="close">
                </button>
            </div>

            <!-- Modal Content -->
            <div class="w-full  overflow-y-auto overflow-auto text-white">
                <table class="w-full table table-auto">
                    @forelse ($bots as $bot)
                        <tr data-target="{{ $bot->code }}" class="border-b border-opacity-15 border-blue-200">
                            <td class="flex gap-4 p-3 w-auto">
                                <img src="{{ asset('storage/bots/' . $bot->logo) }}" alt="icon"
                                    class="h-10 w-10 rounded-full">
                                <div>
                                    <p class="text-lg font-bold">{{ $bot->name }}</p>
                                    <p>{{ $bot->duration . $bot->duration_type }} trading period</p>
                                    <dl class="lg:hiddens">
                                        <dt class="sr-only"></dt>
                                        <dd class="text-gray-200 text-sm">
                                            {{ formatAmount($bot->min) . ' - ' . formatAmount($bot->max) }}</dd>
                                    </dl>
                                </div>
                            </td>
                            <td class="w-auto lg:table-cell hidden">
                                <p>{{ formatAmount($bot->min) . ' - ' . formatAmount($bot->max) }}</p>
                            </td>
                            <td class="w-auto">
                                <p>{{ $bot->daily_min . '% - ' . $bot->daily_max . '%' }}</p>
                            </td>
                            <td class="w-auto">
                                <a role="button" data-bot_id="{{ $bot->id }}" data-bot_name="{{ $bot->name }}"
                                    data-bot_min="{{ formatAmount($bot->min) }}"
                                    data-bot_max="{{ formatAmount($bot->max) }}"
                                    class="bot bg-[#E39DFF] rounded-full p-2 bg-opacity-20 text-xs px-3">Activate</a>
                            </td>
                        </tr>
                    @empty
                    @endforelse
                </table>
            </div>

        </div>
    </div>
    <!--activate ai bot modal-->



    <div class="w-full">
        <div class="hidden #fixed absolute z-50 inset-0 bg-opacity-50 flex items-center justify-center lg:px-6 px-2"
            id="aiBotActivateModal">
            <div id="modalDisplay"
                class="border-t border-t-[#A320D8] border-r border-r-[#A320D8] border-b border-b-[#3F7DF2] border-l border-l-[#3F7DF2] bg-[#60A4F6] bg-opacity-10 backdrop-blur-lg rounded-xl lg:w-3/5 w-full lg:p-10 p-4 relative lg:mr-20">



            </div>
        </div>
    </div>

@endsection

@section('scripts')
    <script>
        //toggle for ai activation modal
        $(document).ready(function() {
            $('#openAiBotActivationModal').click(function() {
                $('#aiBotActivationModal').removeClass('hidden')
            });

            $('#aiBotActivationModal').on('click', '#closeAiBotActivationModal', function() {
                // You can add code to hide the modal here.
                $('#aiBotActivationModal').addClass('hidden');
            });

            $('#aiBotActiveModal').on('click', '#closeAiBotActiveModal', function() {
                // You can add code to hide the modal here.
                $('#aiBotActiveModal').addClass('hidden');
            });

            /////////////
            $('#aiBotActivateModal').on('click', '#closeAiBotActivateModal', function() {
                // You can add code to hide the modal here.
                $('#aiBotActivateModal').addClass('hidden');
            });
        });
    </script>

    <script>
        ////////////////////// trading view chart
        var lineChartData = {
            labels: [], // This will be populated dynamically with date ranges
            datasets: [{
                label: "Profit",
                data: @json($profits).reverse(), // Random data for past 30 days (24 hours per day)
                pointBackgroundColor: "rgba(16,133,135,1)",
                pointBorderColor: "#fff",
                pointHoverBackgroundColor: "#fff",
                pointHoverBorderColor: "rgba(16,133,135,1)",
                tension: 0.4,
                fill: true,
            }],
        };

        // Generate day ranges for the past 30 days
        function generateDayLabels(days) {
            let labels = [];
            let now = new Date();

            for (let i = days - 1; i >= 0; i--) {
                let currentDate = new Date(now.getTime() - i * 24 * 60 * 60 * 1000); // Subtract i days from now

                // Format start and end days (the same for each day in this case)
                let startDay = String(currentDate.getDate()).padStart(2, "0");
                let endDay = String(currentDate.getDate()).padStart(2, "0");

                // Combine into (DD-DD)
                //labels.push(`(${startDay}-${endDay})`);
                labels.push(`${startDay}-${endDay}`);
            }
            return labels;
        }

        // Populate the labels with corresponding date ranges for the past 30 days
        lineChartData.labels = generateDayLabels(30); // 30 days

        // Ensure the DOM is fully loaded before executing the script
        window.addEventListener("load", function() {
            var canvas = document.getElementById("canvas");
            if (!canvas) {
                console.error("Canvas element not found!");
                return;
            }

            var ctx = canvas.getContext("2d");

            // Create a gradient for the first line (Profit)
            var gradientProfit = ctx.createLinearGradient(0, 0, canvas.width, 0); // Horizontal gradient
            gradientProfit.addColorStop(0, "rgba(16,133,135,1)");
            gradientProfit.addColorStop(1, "rgba(255,100,50,1)");

            // Assign the gradients to the datasets' borderColors
            lineChartData.datasets[0].borderColor = gradientProfit;

            // Create the chart
            new Chart(ctx, {
                type: "line",
                data: lineChartData,
                options: {
                    responsive: true,
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                stepSize: 1000, // Interval between steps
                                color: "#1ED6FF",
                            },
                        },
                        x: {
                            ticks: {
                                color: "#1ED6FF",
                                maxRotation: 90,
                                minRotation: 45,
                            },
                        },
                    },
                    plugins: {
                        legend: {
                            display: true,
                            position: "top",
                        },
                    },
                },
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $("#myAiBotsBtn").on("click", function() {
                $("#myAiBots").slideDown().removeClass('hidden');
                $("#aiTradingHistory, #dailySummary").slideUp().addClass('hidden');

                $("#aiTradingHistoryBtn, #dailySummaryBtn").removeClass('ai_button_gradient_small');
                $("#myAiBotsBtn").addClass('ai_button_gradient_small');
            });

            $("#aiTradingHistoryBtn").on("click", function() {
                $("#aiTradingHistory").slideDown().removeClass('hidden');
                $("#myAiBots, #dailySummary").slideUp().addClass('hidden');

                $("#myAiBotsBtn, #dailySummaryBtn").removeClass('ai_button_gradient_small');
                $("#aiTradingHistoryBtn").addClass('ai_button_gradient_small');
            });

            $("#dailySummaryBtn").on("click", function() {
                $("#dailySummary").slideDown().removeClass('hidden');
                $("#myAiBots, #aiTradingHistory").slideUp().addClass('hidden');

                $("#aiTradingHistoryBtn, #myAiBotsBtn").removeClass('ai_button_gradient_small');
                $("#dailySummaryBtn").addClass('ai_button_gradient_small');
            });
        });
    </script>

    @foreach ($activations as $item)
        <script>
            $(document).ready(function() {
                var target = "{{ 'bot_timer_' . $loop->iteration }}";
                var expires_in = {{ $item->expires_in }};

                // Get the current time in milliseconds
                var currentTime = new Date().getTime();

                // Calculate the remaining time in milliseconds
                var remainingTime = expires_in * 1000 - currentTime;

                // Calculate days, hours, minutes, and seconds
                var days = Math.floor(remainingTime / (1000 * 60 * 60 * 24));
                var hours = Math.floor((remainingTime % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                var minutes = Math.floor((remainingTime % (1000 * 60 * 60)) / (1000 * 60));
                var seconds = Math.floor((remainingTime % (1000 * 60)) / 1000);

                // Display the countdown
                var countdownElement = document.getElementById(target);
                countdownElement.innerHTML = days + "d " + hours + "h " + minutes + "m " + seconds + "s";

                // Update the countdown every second
                var countdownInterval = setInterval(function() {
                    if (remainingTime > 0) {
                        remainingTime -= 1000;

                        days = Math.floor(remainingTime / (1000 * 60 * 60 * 24));
                        hours = Math.floor((remainingTime % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                        minutes = Math.floor((remainingTime % (1000 * 60 * 60)) / (1000 * 60));
                        seconds = Math.floor((remainingTime % (1000 * 60)) / 1000);

                        countdownElement.innerHTML = days + "d " + hours + "h " + minutes + "m " + seconds +
                            "s";
                    } else {
                        clearInterval(countdownInterval);
                        countdownElement.innerHTML = "Expired";
                    }
                }, 1000);
            });
        </script>
    @endforeach

    <script>
        let interval;


        // select the bot bot
        $(document).on('click', ".bot", function(e) {


            var bot_id = $(this).data('bot_id');
            var bot_name = $(this).data('bot_name');

            var bot_min = $(this).data('bot_min');
            var bot_max = $(this).data('bot_max');

            $('#aiBotActivationModal').addClass('hidden');

            var modalContent = `
            <div class="flex justify-between items-center lg:mb-10 mb-4">
                    <h2 class="text-xl font-semibold mb-4 text-white">Ai Activation</h2>
                    <button id="closeAiBotActivateModal" class="text-gray-400 hover:text-gray-600">
                        <img src="{{ asset('/assets/templates/dome/images/dash/icon/pink-close-line-icons_close.svg') }}"
                            alt="icon">
                    </button>
                </div>

                <!-- Modal Content -->
                <form action="{{ route('user.bots.new') }}" method="post" id="botForm">
                    @csrf

                    <input type="hidden" name="bot_id" id="bot_id">

                    <p class="mb-3 text-white">You have chosen to activate <span style="color:#A22ADA;"
                            id="dispay_bot_name"></span> Ai bot</p>

                    <p class="mb-3 text-[#EA0A0E] text-xs" id="errorMessage"></p>

                    <div class="lg:flex block gap-6 py-10">
                        <div class="block lg:w-3/5 mb-3">
                            <div class="w-full mb-10">
                                <label for="amount" class="text-white">Capital {{ site('currency') }}</label>
                                <div class="w-full text-white flex gap-4 border rounded-2xl ">
                                    <div
                                        class="bg-[#E39DFF] bg-opacity-25 rounded-l-2xl w-32 flex items-center justify-center">
                                        <img src="{{ asset('/assets/templates/dome/images/dash/icon/dollar-sign.svg') }}"
                                            alt="icon">
                                    </div>
                                    <div class="w-full">
                                        <input type="number" placeholder="Capital ({{ site('currency') }})"
                                            id="capital"
                                            class="w-full p-6 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                            name="capital" value="0" required>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="block lg:w-2/5">
                            <div class="w-full lg:mb-10 mb-4 lg:px-10 px-4">
                                <div class="flex gap-4 mb-3">
                                    <p class="text-xs text-white">Important Information</p>
                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/blue-caution-mdi-light_information.svg') }}"
                                        alt="icon">
                                </div>

                                <div class="w-full py-4 text-xs">
                                    <table class="mb-3">
                                        <tr>
                                            <td><span class="text-[#40DDFF]">Minimum Capital:</span></td>
                                            <td><span class="text-white px-10" id="dispay_bot_min"></span></td>
                                        </tr>
                                        <tr>
                                            <td><span class="text-[#40DDFF]">Maximum Capital:</span></td>
                                            <td><span class="text-white px-10" id="dispay_bot_max"></span></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                            <div class="w-full px-6">
                                <div class="flex items-center justify-center">
                                    <button type="submit" id="activateButton"
                                        class="w-full border rounded-full py-3 px-10 block text-center text-white text-lg bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)] hover:text-white flex items-center justify-center">Activate</button>
                                </div>
                            </div>

                        </div>
                    </div>
                </form>
                `;



            $('#aiBotActivateModal').removeClass("hidden");
            $('#modalDisplay').html(modalContent);

            $('#dispay_bot_name').html(bot_name);
            $("#bot_id").val(bot_id);

            /////////my update
            $('#dispay_bot_min').html(bot_min);
            $('#dispay_bot_max').html(bot_max);

        });

        // handle bot form
        $(document).on('submit', '#botForm', function(e) {
            e.preventDefault();

            var form = $(this);
            var formData = new FormData(this);

            var submitButton = $(this).find('button[type="submit"]');
            submitButton.addClass('relative disabled bg-gray-500');
            submitButton.append('<span class="button-spinner"></span>');
            submitButton.prop('disabled', true);

            // new modification
            submitButton.removeClass(
                'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
            );
            submitButton.addClass('not-allowed-cursor');

            $.ajax({
                url: form.attr('action'),
                method: 'POST',
                data: formData,
                dataType: 'json',
                contentType: false,
                processData: false,
                success: function(response) {
                    var link = window.location.href;
                    var targetDiv = '#bots';
                    $.ajax({
                        url: link,
                        method: 'GET',
                        success: function(response) {
                            $(targetDiv).html($(response).find(targetDiv).html());

                            var scrollTo = $(targetDiv).offset().top - 100;
                            $('.rescron-card').addClass('hidden');
                            $(targetDiv).removeClass('hidden');
                            $('html, body').animate({
                                scrollTop: scrollTo
                            }, 800);
                        }
                    });
                    toastNotify('success', 'Bot activated successfully');

                    // new modification
                    submitButton.addClass(
                        'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                    );
                    submitButton.removeClass('not-allowed-cursor');

                    $('#aiBotActivateModal').addClass('hidden');
                },

                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;

                    if (errors) {
                        $.each(errors, function(field, messages) {
                            var fieldErrors = '';
                            $.each(messages, function(index, message) {
                                fieldErrors += message + '<br>';
                            });
                            $('#errorMessage').html(fieldErrors);
                        });
                    } else {
                        $('#errorMessage').html('error', 'An Error occured, try again later');
                    }


                },
                complete: function() {
                    submitButton.removeClass('disabled');
                    submitButton.find('.button-spinner').remove();
                    submitButton.prop('disabled', false);

                    submitButton.addClass(
                        'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                    );
                    submitButton.removeClass('not-allowed-cursor');

                }
            });

        });
    </script>

    {{-- view trading history chart --}}
    <script src="https://s3.tradingview.com/tv.js"></script>
    <script>
        $(document).on('click', '.view-chart', function(e) {
            var pair = $(this).data('pair'); // BTCUSDT

            //fetch trading view chart for the pair
            Swal.fire({
                html: `
                        <div class="mt-5 sm:overflow-x-scroll">
                            <div id="chart-container"></div>
                        </div>
                        `,
                toast: false,
                background: 'rgb(7, 3, 12, 0)',
                showConfirmButton: false,
                showCloseButton: true,
                position: 'top-left',
                allowEscapeKey: false, // Prevent closing by escape key
                allowOutsideClick: false, // Prevent closing by clicking backdrop
                willClose: () => {
                    //delete the previously generated qrcode
                    // $('#single_wallet_qrcode').html('');
                }
            });

            new TradingView.widget({
                // Define the container element for the widget
                container_id: 'chart-container', // Replace 'chart-container' with your actual container ID

                // Specify the symbol (pair) you want to display
                symbol: pair,

                // Specify the interval for the chart (e.g., '1D' for 1 day)
                interval: '1D',

                // Choose the style of the chart (e.g., 'Line' or 'Candles')
                style: 'Candles',

                // Specify the timezone for the chart
                timezone: 'Etc/UTC',
                theme: 'Dark'

            });

        });
    </script>
@endsection
