@extends('templates.' . site('template') . '.layouts.user')


@section('css')
@endsection

@section('contents')
    {{-- search form --}}
    <div class="mx-auto py-10">
        <!--search form-->
        <div action="" class="block lg:w-[50%] mx-auto" id="filterForm">
            <div class="w-full flex border rounded-full">
                <input type="text" placeholder="Txn ref" id="search-deposit-input" value="{{ request()->s }}"
                    class="py-3 h-14s px-6 rounded-l-full bg-transparent w-full text-white">

                <div class="simple-pagination" data-paginator="deposits">
                    <a id="search-deposit-button" data-link="{{ route('user.deposits.index') }}" href=""
                        class="paginator-link flex gap-4 items-center bg-gradient-to-tr from-[#95E3FD] to-[#A320D8] t-[40%] py-3 px-8 rounded-r-full text-white">
                        <img src="{{ asset('/assets/templates/dome/images/dash/icon/white-icons_search-outline.svg') }}"
                            alt="icon">
                        <span>Search</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="" id="deposits">

        {{-- tile and modal btn --}}
        <section class="lg:w-full w-screenw py-6" data-aos="fade-up">
            <div class="max-w-screen-2xl mx-auto mb-5">
                <div class="w-full px-3">
                    <div class="flex gap-4 justify-between items-center">
                        <p
                            class="text-xl lg:text-2xl font-bold mb-6 bg-gradient-to-r from-[#3F7DF2] via-[#60A4F6] to-[#A320D8] lg:to-[70%] to-[50%] bg-clip-text text-transparent">
                            Deposit</p>
                        <button id="NewDepositModalBtn"
                            class="lg:w-52 border rounded-full lg:py-4 py-2 lg:px-10 px-5 block text-center text-white text-lg bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)] hover:text-white">New
                            Deposit</button>
                    </div>
                </div>
            </div>
        </section>


        {{-- deposit history --}}
        <section class="lg:w-full w-screen py-6" data-aos="fade-up">
            <div class="max-w-screen-2xl mx-auto mb-5">
                <div id="responsiveTable" class="block overflow-x-auto mb-5">
                    <table class="w-full table-auto" id="depositTable">
                        <thead class="text-white">
                            <th class="p-6 text-left font-light lg:min-w-52 min-w-[50vw]">AI Bots/ID</th>
                            <th class="p-6 text-left font-light">Amount</th>
                            <th class="p-6 text-left font-light">Data</th>
                            <th class="p-6 text-left">Time</th>
                            <th class="p-6 text-left font-light gap-2 relative">
                                <button id="status-dropdown-btn-dep" class="flex gap-3 items-center">Status
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                        viewBox="0 0 24 24" style="fill: rgb(255, 255, 255);transform: ;msFilter:;">
                                        <path
                                            d="M11.178 19.569a.998.998 0 0 0 1.644 0l9-13A.999.999 0 0 0 21 5H3a1.002 1.002 0 0 0-.822 1.569l9 13z">
                                        </path>
                                    </svg>
                                </button>
                                <aside id="status-dropdown-dep"
                                    class="hidden absolute bg-[#2d3039] lg:bg-opacity-25 lg:backdrop-blur-md rounded-xl overflow-y-auto h-72">
                                    <ul class="py-4 px-6 text-sm">
                                        <li class="mb-3">
                                            <a href=""
                                                class="block w-40 bg-[#fff] bg-opacity-10 p-2 rounded-lg border-[#fff] border border-opacity-25">
                                                <p class="text-white">All</p>
                                            </a>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#E9790A] bg-opacity-10 p-2 rounded-lg border-[#E9790A] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/yellow-confirming-icon-Frame221.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#E9790A]">Confirming</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#D8D8D8] bg-opacity-10 p-2 rounded-lg border-[#D8D8D8] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/white-waiting-icon-Frame221.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#D8D8D8]">Waiting</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#40DDFF] bg-opacity-10 p-2 rounded-lg border-[#40DDFF] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/blue-partly-paid-icon-Frame221.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#40DDFF]">Partly Paid</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#08C949] bg-opacity-10 p-2 rounded-lg border-[#08C949] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/green-finished-icon-Frame221.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#08C949]">Finished</p>
                                                </a>
                                            </div>
                                        </li>
                                        <li class="mb-3">
                                            <div
                                                class="block w-40 bg-[#EA0A0E] bg-opacity-10 p-2 rounded-lg border-[#EA0A0E] border border-opacity-25">
                                                <a href="" class="flex gap-4">
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/red-expire-Frame221.svg') }}"
                                                        alt="icon" class="w-5 h-5">
                                                    <p class="text-[#EA0A0E]">Expired</p>
                                                </a>
                                            </div>
                                        </li>
                                    </ul>
                                </aside>
                            </th>
                            <th class="p-6 text-left"></th>
                        </thead>
                        <tbody>
                            @forelse ($deposits as $deposit)
                                <tr class="border-b border-opacity-25 border-blue-400 text-white">
                                    <td data-label="AI Bots/ID" class="p-6" data-deposit_tnx="{{ $deposit->ref }}">
                                        <div class="flex items-center gap-4 ">
                                            <img src="{{ 'https://nowpayments.io' . $deposit->depositCoin->logo_url }}"
                                                alt="coin" width="50px">
                                            <div class="block">
                                                <p class="text-xl">{{ $deposit->depositCoin->name }}</p>
                                                <p class=" text-gray-400">{{ $deposit->payment_wallet }}</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td data-label="Amount" class="text-left p-6">
                                        <p class="text-lg">{{ formatAmount($deposit->amount) }} </p>
                                        <p class=" text-gray-400">
                                            {{ $deposit->converted_amount . ' ' . $deposit->currency }}</p>
                                    </td>
                                    <td data-label="Data" class="text-left p-6">
                                        <p class="">{{ date('d-m-y', strtotime($deposit->created_at)) }}</p>
                                    </td>
                                    <td data-label="Time" class="text-left p-6">
                                        <p class="">{{ date('H:i:s', strtotime($deposit->created_at)) }}</p>
                                    </td>
                                    <td data-label="Status" class="text-left p-6">
                                        @if ($deposit->status == 'waiting')
                                            <div
                                                class="block w-40 bg-[#D8D8D8] bg-opacity-10 p-2 rounded-lg border-[#D8D8D8] border">
                                                <div class="flex gap-4">
                                                    <svg width="19" height="19" viewBox="0 0 19 19"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <rect x="0.0830078" y="0.801758" width="18" height="18"
                                                            rx="9" fill="#D8D8D8" fill-opacity="0.11" />
                                                        <circle cx="5" cy="5" r="5"
                                                            transform="matrix(-1 0 0 1 14.083 4.80176)" fill="#D8D8D8" />
                                                    </svg>

                                                    <p class="text-[#ffffff] capitalize">{{ $deposit->status }}</p>
                                                </div>
                                            </div>
                                        @elseif ($deposit->status == 'finished')
                                            <div
                                                class="block w-40 bg-[#08C949] bg-opacity-10 p-2 rounded-lg border-[#08C949] border">
                                                <div class="flex gap-4">
                                                    <svg width="19" height="19" viewBox="0 0 19 19"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M8.6553 2.22869C8.92079 1.96354 9.27601 1.80753 9.65088 1.79142C10.0258 1.77532 10.393 1.90029 10.6803 2.14169L10.7763 2.22944L12.2013 3.65369H14.2158C14.5941 3.65376 14.9584 3.79677 15.2357 4.05407C15.5131 4.31136 15.6829 4.66395 15.7113 5.04119L15.7158 5.15369V7.16819L17.1408 8.59319C17.4062 8.85872 17.5623 9.21409 17.5784 9.58914C17.5945 9.96418 17.4694 10.3316 17.2278 10.6189L17.14 10.7142L15.715 12.1392V14.1537C15.7152 14.5321 15.5722 14.8966 15.3149 15.1741C15.0576 15.4516 14.7049 15.6216 14.3275 15.6499L14.2158 15.6537H12.202L10.777 17.0787C10.5115 17.344 10.1561 17.5002 9.7811 17.5163C9.40605 17.5324 9.0386 17.4073 8.7513 17.1657L8.65605 17.0787L7.23105 15.6537H5.2158C4.83737 15.6538 4.47287 15.5109 4.19539 15.2536C3.9179 14.9962 3.74793 14.6436 3.71955 14.2662L3.7158 14.1537V12.1392L2.2908 10.7142C2.02544 10.4487 1.8693 10.0933 1.85319 9.71824C1.83708 9.34319 1.96219 8.97574 2.2038 8.68844L2.2908 8.59319L3.7158 7.16819V5.15369C3.71587 4.77539 3.85888 4.41108 4.11618 4.13375C4.37347 3.85643 4.72606 3.68656 5.1033 3.65819L5.2158 3.65369H7.2303L8.6553 2.22869Z"
                                                            fill="#08C949" />
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M12.0251 7.39095L8.84212 10.574L7.51612 9.24795C7.37539 9.10732 7.18456 9.02836 6.9856 9.02843C6.78665 9.0285 6.59588 9.1076 6.45524 9.24833C6.31461 9.38906 6.23565 9.57989 6.23572 9.77884C6.23579 9.9778 6.31489 10.1686 6.45562 10.3092L8.25862 12.1122C8.33523 12.1889 8.4262 12.2497 8.52632 12.2911C8.62644 12.3326 8.73375 12.354 8.84212 12.354C8.95049 12.354 9.0578 12.3326 9.15792 12.2911C9.25804 12.2497 9.34901 12.1889 9.42562 12.1122L13.0856 8.45145C13.2222 8.31 13.2978 8.12055 13.2961 7.9239C13.2944 7.72726 13.2155 7.53915 13.0765 7.40009C12.9374 7.26103 12.7493 7.18216 12.5527 7.18045C12.356 7.17874 12.1666 7.25434 12.0251 7.39095Z"
                                                            fill="#F0FCFF" />
                                                    </svg>

                                                    <p class="text-[#08C949] capitalize">{{ $deposit->status }}</p>
                                                </div>
                                            </div>
                                        @elseif ($deposit->status == 'expired' || $deposit->status == 'failed' || $deposit->status == 'refunded')
                                            <div
                                                class="block w-40 bg-[#EA0A0E] bg-opacity-10 p-2 rounded-lg border-[#EA0A0E] border">
                                                <div class="flex gap-4">
                                                    <svg width="19" height="18" viewBox="0 0 19 18"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M8.6553 1.57488C8.92079 1.30973 9.27601 1.15372 9.65088 1.13761C10.0258 1.12151 10.393 1.24648 10.6803 1.48788L10.7763 1.57563L12.2013 2.99988H14.2158C14.5941 2.99995 14.9584 3.14296 15.2357 3.40026C15.5131 3.65756 15.6829 4.01014 15.7113 4.38738L15.7158 4.49988V6.51438L17.1408 7.93938C17.4062 8.20491 17.5623 8.56028 17.5784 8.93533C17.5945 9.31037 17.4694 9.67783 17.2278 9.96513L17.14 10.0604L15.715 11.4854V13.4999C15.7152 13.8783 15.5722 14.2428 15.3149 14.5203C15.0576 14.7978 14.7049 14.9677 14.3275 14.9961L14.2158 14.9999H12.202L10.777 16.4249C10.5115 16.6902 10.1561 16.8464 9.7811 16.8625C9.40605 16.8786 9.0386 16.7535 8.7513 16.5119L8.65605 16.4249L7.23105 14.9999H5.2158C4.83737 15 4.47287 14.8571 4.19539 14.5998C3.9179 14.3424 3.74793 13.9897 3.71955 13.6124L3.7158 13.4999V11.4854L2.2908 10.0604C2.02544 9.79485 1.8693 9.43948 1.85319 9.06443C1.83708 8.68938 1.96219 8.32193 2.2038 8.03463L2.2908 7.93938L3.7158 6.51438V4.49988C3.71587 4.12158 3.85888 3.75727 4.11618 3.47994C4.37347 3.20262 4.72606 3.03275 5.1033 3.00438L5.2158 2.99988H7.2303L8.6553 1.57488Z"
                                                            fill="#EA0A0E" />
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M12.0251 6.73715L8.84212 9.92015L7.51612 8.59415C7.37539 8.45351 7.18456 8.37455 6.9856 8.37462C6.78665 8.37469 6.59588 8.45379 6.45524 8.59452C6.31461 8.73525 6.23565 8.92608 6.23572 9.12504C6.23579 9.32399 6.31489 9.51476 6.45562 9.6554L8.25862 11.4584C8.33523 11.535 8.4262 11.5958 8.52632 11.6373C8.62644 11.6788 8.73375 11.7002 8.84212 11.7002C8.95049 11.7002 9.0578 11.6788 9.15792 11.6373C9.25804 11.5958 9.34901 11.535 9.42562 11.4584L13.0856 7.79765C13.2222 7.65619 13.2978 7.46674 13.2961 7.27009C13.2944 7.07345 13.2155 6.88534 13.0765 6.74628C12.9374 6.60723 12.7493 6.52835 12.5527 6.52664C12.356 6.52493 12.1666 6.60053 12.0251 6.73715Z"
                                                            fill="#F0FCFF" />
                                                    </svg>

                                                    <p class="text-[#EA0A0E]">{{ $deposit->status }}</p>
                                                </div>
                                            </div>
                                        @else
                                            <div
                                                class="block w-40 bg-[#D8D8D8] bg-opacity-10 p-2 rounded-lg border-[#D8D8D8] border">
                                                <div class="flex gap-4">
                                                    <svg width="19" height="19" viewBox="0 0 19 19"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <rect x="0.0830078" y="0.801758" width="18" height="18"
                                                            rx="9" fill="#D8D8D8" fill-opacity="0.11" />
                                                        <circle cx="5" cy="5" r="5"
                                                            transform="matrix(-1 0 0 1 14.083 4.80176)" fill="#D8D8D8" />
                                                    </svg>

                                                    <p class="text-[#ffffff] capitalize">{{ $deposit->status }}</p>
                                                </div>
                                            </div>
                                        @endif
                                    </td>
                                    <td>
                                        <button type="button" id="view_deposit" class="view-single-deposit flex gap-2"
                                            data-link="{{ route('user.deposits.view', ['ref' => $deposit->ref]) }}"
                                            style="cursor: pointer;">
                                            <img src="{{ asset('/assets/templates/dome/images/dash/icon/pink-eye-Group.svg') }}"
                                                alt="icon" class="w-4 h-5">
                                            <span class="text-sm text-[#D386F2]">View</span>
                                        </button>
                                    </td>
                                </tr>

                            @empty

                                <div
                                    class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg border border-slate-800 hover:border-slate-600 cursor-pointer">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-orange-500"
                                        fill="currentColor" class="bi bi-exclamation-triangle-fill" viewBox="0 0 16 16">
                                        <path
                                            d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                    </svg>
                                    <span>Empty Record. No depsoit found!</span>
                                </div>
                            @endforelse

                        </tbody>

                    </table>
                </div>

                <div class="cursor-pointer simple-pagination" data-paginator="deposits">
                    {{ $deposits->links('templates.' . site('template') . '.paginations.simple') }}
                </div>

            </div>
        </section>


        <!-- new deposit Modal -->
        <div id="NewDepositModal"
            class="hidden #fixed absolute z-50 inset-0 bg-opacity-50 flex items-center justify-center lg:px-6 px-2">
            <div
                class="border-t border-t-[#A320D8] border-r border-r-[#A320D8] border-b border-b-[#3F7DF2] border-l border-l-[#3F7DF2] bg-[#E39DFF] bg-opacity-10 backdrop-blur-lg rounded-xl lg:w-3/5 w-full lg:p-10 p-4 relative  lg:mr-20">

                <div class="flex justify-between items-center lg:mb-10 mb-4">
                    <h2 class="text-xl font-semibold mb-4 text-white">New Deposit</h2>
                    <button id="closeNewDepositModal" class="text-gray-400 hover:text-gray-600">
                        <img src="{{ asset('/assets/templates/dome/images/dash/icon/pink-close-line-icons_close.svg') }}"
                            alt="icon">
                    </button>
                </div>

                <!-- Modal Content -->
                <form action="{{ route('user.deposits.new') }}" method="post" id="depositForm">
                    @csrf
                    <div class="xl:flex block gap-6">
                        <div class="block xl:w-3/5 mb-3">
                            <div class="w-full mb-10">
                                <label for="amount" class="text-white">Amount ({{ site('currency') }})</label>
                                <div class="w-full text-white flex gap-4 border rounded-2xl ">
                                    <div
                                        class="bg-[#E39DFF] bg-opacity-25 rounded-l-2xl w-32 flex items-center justify-center">
                                        <img src="{{ asset('/assets/templates/dome/images/dash/icon/dollar-sign.svg') }}"
                                            alt="icon">
                                    </div>
                                    <div class="w-full">
                                        <input type="number" step="any"
                                            placeholder="Amount ({{ site('currency') }})" id="amount" name="amount"
                                            class="w-full p-6 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                            value="0" required>
                                    </div>
                                </div>
                            </div>

                            <!--Coin for deposit Dropdown -->
                            <div class="w-full lg:mb-10 mb-4">
                                <label for="amount" class="text-white">Coin for deposit</label>
                                <div class="relative border py-1 px-3 rounded-2xl">
                                    <button id="coinForDepositDropdownButton"
                                        class="w-full p-6 bg-transparent text-xl text-white border-0 focus:outline-none flex-1 flex gap-2"
                                        type="button">
                                        <div class="flex items-center w-full">
                                            <img src="" alt="" class=" rounded-full mr-2"
                                                id="selectedCoinImg" />
                                            <span id="selectedCoinText">Select Coin</span>
                                        </div>
                                        <img src="{{ asset('/assets/templates/dome/images/dash/icon/dropdown_arrow_blue.svg') }}"
                                            alt="icon">
                                    </button>

                                    <!-- Dropdown Menu -->
                                    <ul id="coinForDepositDropdownMenu"
                                        class="absolute z-10 hidden mt-1 max-h-60 lg:w-60 w-full overflow-auto rounded-md bg-gray-600 bg-opacity-90 shadow-lg right-0">
                                        @foreach ($coins as $coin)
                                            <li class="flex items-center px-4 py-2 text-gray-900 cursor-pointer hover:bg-blue-600"
                                                data-value="{{ $coin->code }}" data-label="{{ $coin->name }}"
                                                data-img="{{ 'https://nowpayments.io' . $coin->logo_url }}">
                                                <img src="{{ 'https://nowpayments.io' . $coin->logo_url }}"
                                                    alt="coin" class="h-8 w-8 rounded-full mr-2" />
                                                <p class="">
                                                    <span class="text-white" style="text-transform: uppercase;">
                                                        @if ($coin->network)
                                                            {{ $coin->network }}
                                                        @endif
                                                    </span>
                                                    <span class="text-white"> {{ $coin->name }}</span>
                                                </p>
                                            </li>
                                        @endforeach

                                    </ul>
                                </div>
                                <!-- Hidden Input for selected coin -->
                                <input type="hidden" value="" name="currency_code" id="currency_code" />
                            </div>

                        </div>

                        <div class="block xl:w-2/5">
                            <div class="w-full lg:mb-10 mb-4 lg:px-10 px-4">
                                <div class="flex gap-4 mb-3">
                                    <p class="text-sm text-white">Important Information</p>
                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/blue-caution-mdi-light_information.svg') }}"
                                        alt="icon">
                                </div>

                                <div class="w-full py-4 text-xs">
                                    <table class="mb-3">
                                        <tr>
                                            <td><span class="text-[#A320D8]">Minimum Deposit:</span></td>
                                            <td><span class="text-white">{{ formatAmount(site('min_deposit')) }}</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><span class="text-[#A320D8]">Maximum Deposit:</span></td>
                                            <td><span class="text-white">{{ formatAmount(site('max_deposit')) }}</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><span class="text-[#A320D8]">Maximum Waiting Duration :</span></td>
                                            <td><span class="text-white">7 Days</span></td>
                                        </tr>
                                    </table>
                                    <p class="text-xs text-justify">
                                        <span class="text-[#95E3FD]">Warning: </span>
                                        <span class="text-[#D8D8D8]">After selecting your preferred payment method and
                                            entering the amount you want to deposit, a new wallet address will be generated
                                            for your deposit. Send only the specified token and network to the generated
                                            address or qrcode. Sending wrong token or sending to a wrong wallet address will
                                            lead to permanent</span>
                                    </p>
                                </div>
                            </div>

                            <div class="w-full px-6">
                                <div class="flex items-center justify-center">
                                    <button type="submit"
                                        class="w-full border rounded-full py-4 px-10 block text-center text-white text-lg bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)] hover:text-white flex items-center justify-center">Pay
                                        Now</button>
                                </div>
                            </div>

                        </div>
                    </div>
                </form>

            </div>
        </div>
        <!--new deposit modal-->

        <!-- new deposit information Modal -->
        <div id="NewDepositInformationModal"
            class="hidden #fixed absolute z-50 inset-0  bg-opacity-50 flex items-center justify-center lg:px-6 px-2">
            <div
                class="border-t border-t-[#A320D8] border-r border-r-[#A320D8] border-b border-b-[#3F7DF2] border-l border-l-[#3F7DF2] bg-[#60A4F6] bg-opacity-10 backdrop-blur-lg rounded-xl lg:w-3/5 w-full lg:p-10 p-4 relative mt-20 lg:mr-20">

                <div class="flex justify-between items-center lg:mb-10 mb-4">
                    <h2 class="text-xl font-semibold mb-4 text-white">New Deposit</h2>

                    <div id="paymentLink" class="hidden mt-5 mb-5 w-full flex items-center justify-center">
                        <a href="" id="paymentLinkHref" target="_blank" rel="noopener noreferrer"
                            class="w-full bg-blue-500 px-5 py-1 rounded uppercase">Pay Now</a>
                    </div>


                    <button id="closeNewDepositInfoModal" class="text-gray-400 hover:text-gray-600">
                        <img src="{{ asset('/assets/templates/dome/images/dash/icon/pink-close-line-icons_close.svg') }}"
                            alt="icon">
                    </button>
                </div>

                <!-- Modal Content -->
                <div class="xl:flex block gap-6">
                    <div class="block xl:w-3/5 mb-3">
                        <div class="grid grid-cols-2 border-b border-blue-200 border-opacity-25 py-3">
                            <p class="text-left text-white">Status </p>
                            <p class="text-right text-gray-400 flex gap-3 justify-end items-center">
                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/white-waiting-icon-Frame221.svg') }}"
                                    alt="">
                                <span id="display_deposit_status"></span>
                            </p>
                        </div>
                        <div class="grid grid-cols-2 border-b border-blue-200 border-opacity-25 py-3">
                            <p class="text-left text-white">Valid Until </p>
                            <p class="text-right text-gray-400"><span id="display_deposit_valid_until"></span> </p>
                        </div>
                        <div class="grid grid-cols-2 border-b border-blue-200 border-opacity-25 py-3">
                            <p class="text-left text-white">Amount </p>
                            <p class="text-right text-gray-400">
                                {{ site('currency') }}<span id="display_deposit_amount"></span>
                            </p>
                        </div>
                        <div class="grid grid-cols-2 border-b border-blue-200 border-opacity-25 py-3">
                            <p class="text-left text-white">Fee </p>
                            <p class="text-right text-gray-400">{{ site('currency') }}<span
                                    id="display_deposit_fee"></span> </p>
                        </div>
                        <div class="grid grid-cols-2 border-b border-blue-200 border-opacity-25 py-3">
                            <p class="text-left text-white">Pay Amount </p>
                            <p class="text-right text-gray-400">
                                <span id="display_deposit_converted_amount" class="clipboard cursor-pointer"
                                    data-copy=""> </span>
                                <span id="display_deposit_currency"></span>
                            </p>
                        </div>

                        <div class="grid grid-cols-2 border-b border-blue-200 border-opacity-25 py-3">
                            <p class="text-left text-white">Network </p>
                            <p class="text-right text-gray-400">
                                <span id="display_deposit_network" class="clipboard cursor-pointer"
                                    data-copy=""></span>
                            </p>
                        </div>

                        <div class="grid grid-cols-2 border-b border-blue-200 border-opacity-25 py-3">
                            <p class="text-left text-white">Wallet Address </p>
                            <p class="text-right text-gray-400 flex gap-3 justify-end items-center">
                                <span id="wallet_address" class="wallet-address lg:text-md text-[12px]">
                                    <span id="display_deposit_payment_wallet" class="clipboard cursor-pointer"
                                        data-copy=""></span>
                                </span>
                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/copy_icon.svg') }}"
                                    alt="icon" id="display_deposit_payment_wallet_icon" data-copy=""
                                    class="clipboard" style="cursor: pointer;">
                            </p>
                        </div>
                        <div class="grid grid-cols-2 border-b border-blue-200 border-opacity-25 py-3">
                            <p class="text-left text-white">Txn Ref </p>
                            <p class="text-right text-gray-400">
                                <span id="display_deposit_ref" class="clipboard cursor-pointer" data-copy=""></span>
                            </p>
                        </div>
                    </div>

                    <div class="flex items-center justify-center xl:w-2/5 mb-3">
                        <div class="bg-blue-100 rounded-xl bg-opacity-20 p-2 lg:mb-10 mb-4 mx-auto">
                            <div id="wallet_qrcode" class="clipboard" data-copy=""></div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <!--new deposit modal-->

    </div>

    {{-- modal content --}}
    <div class="w-full bg-black">
        <div id="modalContent"
            class="hidden #fixed absolute z-50 inset-0  bg-opacity-50 flex items-center justify-center lg:px-6 px-2">
            <div id="modalDisplay"
                class="border-t border-t-[#A320D8] border-r border-r-[#A320D8] border-b border-b-[#3F7DF2] border-l border-l-[#3F7DF2] bg-[#60A4F6] bg-opacity-10 backdrop-blur-lg rounded-xl lg:w-3/5 w-full lg:p-10 p-4 relative mt-20 lg:mr-20">



            </div>
        </div>
    </div>
@endsection





@section('scripts')
    <script>
        //# // search deposit
        $(document).on('input keyup', '#search-deposit-input', function(e) {
            var ref = $(this).val();
            var base_link = $('#search-deposit-button').data('link');
            var encodedRef = encodeURIComponent(ref);

            // Append the query parameter to the URL
            var link = base_link + '?s=' + encodedRef;
            $('#search-deposit-button').attr('href', link);
        });
    </script>


    <script>
        $(document).ready(function() {
            // Toggle status dropdown visibility
            $('#status-dropdown-btn-dep').click(function() {
                $('#status-dropdown-dep').toggleClass('hidden');
            });
        });
    </script>

    <script>
        //close dposit details modal
        $('#modalDisplay').on('click', '#closeDepositDetail', function() {
            // You can add code to hide the modal here.
            $('#modalContent').addClass('hidden');
        });



        function initializeDepositModals() {

            // Open Deposit Modal
            $(document).off("click", "#NewDepositModalBtn").on("click", "#NewDepositModalBtn", function() {
                $('#NewDepositModal').removeClass('hidden opacity-0').addClass('opacity-100');
            });

            // Close Deposit Modal
            $(document).off("click", "#closeNewDepositModal").on("click", "#closeNewDepositModal", function() {
                $('#NewDepositModal').removeClass('opacity-100').addClass('opacity-0');
                setTimeout(function() {
                    $('#NewDepositModal').addClass('hidden');
                }, 300); // Matches transition duration
            });

            // Close Deposit Information Modal
            $(document).off("click", "#closeNewDepositInfoModal").on("click", "#closeNewDepositInfoModal", function() {
                $('#NewDepositInformationModal').toggleClass('hidden');
            });
        }

        // Run initialization on page load
        $(document).ready(function() {
            initializeDepositModals();
        });





        let interval;
        //single deposit
        $(document).on('click', '.view-single-deposit', function(e) {
            var clicked = $(this);
            clicked.addClass('relative disabled');
            clicked.append('<span class="button-spinner"></span>');
            clicked.prop('disabled', true);
            var link = $(this).data('link');

            $('#modalContent').removeClass('hidden');
            var html = $('#single-display-new-deposit-information');

            $.ajax({
                url: link,
                method: 'GET',
                success: function(response) {
                    var deposit = response.deposit;

                    var modalContent = `
                    <div id="single-display-new-deposit-information">

                    <div class="flex justify-between items-center lg:mb-10 mb-4">
                        <h2 class="text-xl font-semibold mb-4 text-white">Deposit Information</h2>
                        <button id="closeDepositDetail" class="closeDepositDetail text-gray-400 hover:text-gray-600">
                            <img src="{{ asset('/assets/templates/dome/images/dash/icon/pink-close-line-icons_close.svg') }}"
                                alt="icon">
                        </button>
                    </div>

                    <!-- Modal Content -->
                    <div class="xl:flex block gap-6">
                        <div class="block xl:w-3/5 mb-3">
                            <div class="grid grid-cols-2 border-b border-blue-200 border-opacity-25 py-3">
                                <p class="text-left text-white">Status </p>
                                <p class="text-right text-gray-400 flex gap-3 justify-end items-center">
                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/white-waiting-icon-Frame221.svg') }}"
                                        alt="">
                                    <span id="single_display_deposit_status"></span>
                                </p>
                            </div>
                            <div class="grid grid-cols-2 border-b border-blue-200 border-opacity-25 py-3">
                                <p class="text-left text-white">Valid Until </p>
                                <p class="text-right text-gray-400"><span id="single_display_deposit_valid_until"></span>
                                </p>
                            </div>
                            <div class="grid grid-cols-2 border-b border-blue-200 border-opacity-25 py-3">
                                <p class="text-left text-white">Amount </p>
                                <p class="text-right text-gray-400">{{ site('currency') }}<span
                                        id="single_display_deposit_amount"></span> </p>
                            </div>
                            <div class="grid grid-cols-2 border-b border-blue-200 border-opacity-25 py-3">
                                <p class="text-left text-white">Fee </p>
                                <p class="text-right text-gray-400">{{ site('currency') }}<span
                                        id="single_display_deposit_fee"></span> </p>
                            </div>
                            <div class="grid grid-cols-2 border-b border-blue-200 border-opacity-25 py-3">
                                <p class="text-left text-white">Pay Amount </p>
                                <p class="text-right text-gray-400">
                                    <span id="single_display_deposit_converted_amount" class="clipboard cursor-pointer"
                                        data-copy=""> </span>
                                    <span id="single_display_deposit_currency"></span>
                                </p>
                            </div>
                            <div class="grid grid-cols-2 border-b border-blue-200 border-opacity-25 py-3">
                                <p class="text-left text-white">Network </p>
                                <p class="text-right text-gray-400">
                                    <span id="single_display_deposit_network" class="clipboard cursor-pointer"
                                        data-copy=""></span>
                                </p>
                            </div>
                            <div class="grid grid-cols-2 border-b border-blue-200 border-opacity-25 py-3">
                                <p class="text-left text-white">Wallet Address </p>
                                <p class="text-right text-gray-400 flex gap-3 justify-end items-center">
                                    <span id="wallet_address" class="wallet-address lg:text-md text-[12px]">
                                        <span id="single_display_deposit_payment_wallet"
                                            class="wallet_address clipboard cursor-pointer" data-copy=""></span>
                                    </span>
                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/copy_icon.svg') }}"
                                        alt="icon" class="clipboard" style="cursor: pointer;" data-copy=""
                                        id="single_display_deposit_payment_wallet_icon">
                                </p>
                            </div>
                            <div class="grid grid-cols-2 border-b border-blue-200 border-opacity-25 py-3">
                                <p class="text-left text-white">Txn Ref </p>
                                <p class="text-right text-gray-400">
                                    <span id="single_display_deposit_ref" class="clipboard cursor-pointer"
                                        data-copy="">
                                    </span>
                                </p>
                            </div>
                        </div>

                        <div class="flex items-center justify-center xl:w-2/5 mb-3">
                            <div class="bg-blue-100 rounded-xl bg-opacity-20 p-2 lg:mb-10 mb-4 mx-auto">
                                <div id="single_wallet_qrcode" class="clipboard" data-copy=""></div>
                            </div>
                        </div>
                    </div>


                </div>
                    `;

                    $('#modalContent').removeClass("hidden");
                    $('#modalDisplay').html(modalContent);

                    // Loop through the deposit object's properties
                    for (var key in deposit) {
                        if (deposit.hasOwnProperty(key)) {
                            var value = deposit[key];
                            var element = $('#single_display_deposit_' + key);
                            if (element.length > 0) {
                                element.text(value);
                            }


                            //update the copy attribute
                            if (element.hasClass('clipboard')) {
                                element.attr('data-copy', value);
                            }

                            // update clipboard attribute for only wallet view icon

                            if (key == 'payment_wallet') {
                                var walletViewIcon = $('#single_display_deposit_payment_wallet_icon');
                                walletViewIcon.attr('data-copy', deposit.payment_wallet);
                            }


                        }
                    }

                    // create qrcode
                    var qrCodeElement = document.getElementById('single_wallet_qrcode');
                    var qrCode = new QRCode(qrCodeElement, {
                        text: deposit.payment_wallet,
                        width: 200,
                        height: 200
                    });

                    var walletQrCodeDiv = document.getElementById('single_wallet_qrcode');
                    walletQrCodeDiv.setAttribute('data-copy', deposit.payment_wallet);
                    var imageElement = walletQrCodeDiv.querySelector('img');
                    imageElement.classList.add('rounded-lg', 'border', 'border-slate-800',
                        'hover:border-slate-600', 'cursor-pointer', 'p-1');
                    //imageElement.setAttribute('style', '');

                    //create a count down
                    var targetId = 'single_display_deposit_valid_until';
                    var targetDateString = deposit.valid_until;
                    if (interval) {
                        clearInterval(interval);
                    }

                    interval = setInterval(function() {
                        updateCountdown(targetId, targetDateString);
                    }, 1000);

                    // Check payment status
                    var ref = deposit.ref
                    setInterval(function() {
                        $.ajax({
                            url: "{{ url('/user/deposits/view') }}" + '/' + deposit
                                .ref,
                            method: 'GET',
                            success: function(response) {
                                var status = response.deposit.status;
                                $('#single_display_deposit_status').html(status);


                            }
                        });
                    }, 10000);


                },
                complete: function() {
                    clicked.removeClass('disabled');
                    clicked.find('.button-spinner').remove();
                    clicked.prop('disabled', false);

                }
            });

        });
        // select the deposit coin
        $(document).on('click', ".coin", function(e) {
            $('.coin_select').addClass('hidden');
            var target = '#' + $(this).data('target');
            $(target).toggleClass('hidden');

            var currency_code = $(this).data('currency_code');
            $("#currency_code").val(currency_code);

        });


        // filter the coins
        $(document).on('input keyup', '#coin-search-input', function() {
            var searchText = $(this).val().toLowerCase();

            $('.coin').hide().filter(function() {
                return $(this).text().toLowerCase().includes(searchText);
            }).show();
        });


        // handle deposit form
        $(document).on('submit', '#depositForm', function(e) {
            e.preventDefault();
            var amount = $('#amount').val() * 1;
            var currency_code = $('#currency_code').val();
            var min_deposit = "{{ site('min_deposit') }}" * 1;
            var max_deposit = "{{ site('max_deposit') }}" * 1;
            var currency = "{{ site('currency') }}";

            //check the currency code
            var error = null;
            if (!currency_code) {
                error = 'You have not selected a deposit method';
            }

            //check min and max deposit
            if (amount < min_deposit) {
                error = 'Minimum deposit amount is ' + currency + min_deposit;
            }

            if (amount > max_deposit) {
                error = 'Maximum deposit amount is ' + currency + max_deposit;
            }

            if (error === null) {
                var form = $(this);
                var formData = new FormData(this);

                var submitButton = $(this).find('button[type="submit"]');
                submitButton.addClass('relative disabled bg-gray-500');
                submitButton.append('<span class="button-spinner"></span>');
                // new modification
                submitButton.removeClass(
                    'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                );
                submitButton.addClass('not-allowed-cursor');
                //
                submitButton.prop('disabled', true);
                $.ajax({
                    url: form.attr('action'),
                    method: 'POST',
                    data: formData,
                    dataType: 'json',
                    contentType: false,
                    processData: false,
                    success: function(response) {
                        $('#amount').val(0);
                        var deposit = response.deposit;
                        $('#NewDepositModal').toggleClass('hidden');
                        $('#NewDepositInformationModal').toggleClass('hidden');

                        submitButton.addClass(
                            'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                        );
                        submitButton.removeClass('not-allowed-cursor');

                        if (deposit.link !== 'nill' && deposit.link !== 'undefined') {
                            // window.location.href = deposit.link;
                            // window.open(deposit.link, "_blank");
                            $("#paymentLink").removeClass('hidden');
                            $("#paymentLinkHref").attr('href', deposit.link);
                            window.location.href = deposit.link;
                        }

                        // Loop through the deposit object's properties
                        for (var key in deposit) {
                            if (deposit.hasOwnProperty(key)) {
                                var value = deposit[key];
                                var element = $('#display_deposit_' + key);
                                if (element.length > 0) {
                                    element.text(value);
                                }

                                //update the copy attribute
                                if (element.hasClass('clipboard')) {
                                    element.attr('data-copy', value);
                                }


                            }
                        }


                        //create a count down
                        var targetId = 'display_deposit_valid_until';
                        var targetDateString = deposit.valid_until;
                        const interval = setInterval(function() {
                            updateCountdown(targetId, targetDateString);
                        }, 1000);

                        // create qrcode
                        var qrCodeElement = document.getElementById('wallet_qrcode');
                        qrCodeElement.innerHTML = '';

                        var qrCode = new QRCode(qrCodeElement, {
                            text: deposit.payment_wallet,
                            width: 200,
                            height: 200
                        });

                        var walletQrCodeDiv = document.getElementById('wallet_qrcode');
                        walletQrCodeDiv.setAttribute('data-copy', deposit.payment_wallet);
                        var imageElement = walletQrCodeDiv.querySelector('img');
                        imageElement.classList.add('rounded-lg', 'border', 'border-slate-800',
                            'hover:border-slate-600', 'cursor-pointer', 'p-1');

                        $('html, body').animate({
                            scrollTop: 0 + 100
                        }, 800);
                        toastNotify('success', 'Deposit request initated successfully');

                        // Check payment status
                        var ref = deposit.ref
                        setInterval(function() {
                            $.ajax({
                                url: "{{ url('/user/deposits/view') }}" + '/' + deposit
                                    .ref,
                                method: 'GET',
                                success: function(response) {
                                    var status = response.deposit.status;
                                    $('#display_deposit_status').html(status);
                                }
                            });
                        }, 10000);

                        ///function to update deposit table
                        var link = window.location.href;
                        var clicked = false;
                        var targetDiv = "#depositTable"
                        loadPage(link, clicked, targetDiv);


                    },
                    error: function(xhr, status, error) {
                        var errors = xhr.responseJSON.errors;

                        if (errors) {
                            $.each(errors, function(field, messages) {
                                var fieldErrors = '';
                                $.each(messages, function(index, message) {
                                    fieldErrors += message + '<br>';
                                });
                                toastNotify('error', fieldErrors);

                                submitButton.addClass(
                                    'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                                );
                                submitButton.removeClass('not-allowed-cursor');

                            });
                        } else {
                            toastNotify('error', 'An Error occured, try again later');

                            submitButton.addClass(
                                'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                            );
                            submitButton.removeClass('not-allowed-cursor');
                        }


                    },
                    complete: function() {
                        submitButton.removeClass('disabled');
                        submitButton.find('.button-spinner').remove();
                        submitButton.prop('disabled', false);

                    }
                });
            } else {

                toastNotify('error', error);

            }

        });
    </script>



    <script>
        $(document).ready(function() {

            //deposit information modal to be triggers if http status is 200
            var status = 404;
            if (status == 200) {
                $('#depositInfoModal').addClass('block').removeClass('hidden');
            }

            $("#closeNewDepositInfoModal").on("click", function() {
                $('#depositInfoModal').addClass('hidden').removeClass('block');
            });

        });

        $('#status-dropdown-btn').click(function() {
            $('#status-dropdown').toggleClass('hidden');
        });
    </script>

    <script>
        //select coin for deposit
        function initializeCoinDropdown() {
            $(document).off("click", "#coinForDepositDropdownButton").on("click", "#coinForDepositDropdownButton",
                function() {
                    const coinForDepositDropdownMenu = $('#coinForDepositDropdownMenu');
                    if (coinForDepositDropdownMenu.hasClass('hidden')) {
                        coinForDepositDropdownMenu
                            .removeClass('hidden')
                            .addClass('scale-100 opacity-100')
                            .slideDown(200);
                    } else {
                        coinForDepositDropdownMenu
                            .slideUp(200, function() {
                                $(this).addClass('hidden').removeClass('scale-100 opacity-100');
                            });
                    }
                });

            // Close dropdown when clicking outside
            $(document).on('click', function(e) {
                if (!$(e.target).closest('#coinForDepositDropdownButton, #coinForDepositDropdownMenu').length) {
                    $('#coinForDepositDropdownMenu')
                        .slideUp(200, function() {
                            $(this).addClass('hidden').removeClass('scale-100 opacity-100');
                        });
                }
            });

            // Use event delegation for dynamically added <li> elements
            $(document).on('click', '#coinForDepositDropdownMenu li', function() {
                const label = $(this).data('label');
                const imgSrc = $(this).data('img');
                const value = $(this).data('value');

                // Update the button with the selected coin
                $('#selectedCoinText').text(label);
                $('#selectedCoinImg').attr('src', imgSrc).addClass('w-8 h-8');

                // Update the hidden input value
                $('#currency_code').val(value);

                // Hide the dropdown menu
                $('#coinForDepositDropdownMenu')
                    .slideUp(200, function() {
                        $(this).addClass('hidden').removeClass('scale-100 opacity-100');
                    });
            });
        }

        // Run modal initialization on page load
        $(document).ready(function() {
            initializeCoinDropdown();
        });
    </script>
@endsection
