@extends('templates.' . site('template') . '.layouts.user')



@section('css')
@endsection


@section('contents')
    {{-- search form --}}
    <div class="mx-auto py-10">
        <!--search form-->
        <div action="" class="block lg:w-[50%] mx-auto" id="filterForm">
            <div class="w-full flex border rounded-full">
                <input type="text" placeholder="Txn ref" id="search-transfer-input" value="{{ request()->s }}"
                    class="py-3 h-14s px-6 rounded-l-full bg-transparent w-full text-white">

                <div class="simple-pagination" data-paginator="transfers">
                    <a id="search-transfer-button" data-link="{{ route('user.transfers.index') }}" href=""
                        class="paginator-link flex gap-4 items-center bg-gradient-to-tr from-[#95E3FD] to-[#A320D8] t-[40%] py-3 px-8 rounded-r-full text-white">
                        <img src="{{ asset('/assets/templates/dome/images/dash/icon/white-icons_search-outline.svg') }}"
                            alt="icon">
                        <span>Search</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!--p2p-->
    <div class="w-full py-6" id="pageContent">

        <section class="lg:w-full w-screen py-6" data-aos="fade-up">
            <div class="max-w-screen-2xl mx-auto mb-5">

                <div class="flex gap-4 justify-between items-center px-3">
                    <p
                        class="text-xl lg:text-2xl font-bold mb-6 bg-gradient-to-r from-[#3F7DF2] via-[#60A4F6] to-[#A320D8] lg:to-[70%] to-[50%] bg-clip-text text-transparent">
                        P2p History</p>
                    <button id="openNewP2pModal"
                        class="lg:w-52 border rounded-full lg:py-4 py-2 lg:px-10 px-5 block text-center text-white text-lg bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)] hover:text-white">New
                        P2p</button>
                </div>

            </div>
        </section>

        <section class="lg:w-full w-screen py-6" data-aos="fade-up">
            <div class="max-w-screen-2xl mx-auto mb-5">


                <!--my p2p history-->
                <div id="myP2pHistory" class="mb-10">
                    <div id="transfers" class="w-full border-t border-t-[#60A4F6]  rounded-2xl">

                        <div id="responsiveTable" class="block overflow-x-auto mb-5 text-white h-[70vh]">
                            <table class="w-full table-auto" id="p2pTable">
                                <thead class="text-center">
                                    <th class="p-6 text-left lg:min-w-52 min-w-[50vw] font-light">Date/Time</th>
                                    <th class="p-6 text-right lg:min-w-52 min-w-[50vw] font-light">User</th>
                                    <th class="p-6 text-right lg:min-w-52 min-w-[50vw] font-light">Ref</th>
                                    <th class="p-6 text-right lg:min-w-52 min-w-[50vw] font-light">Fee</th>
                                    <th class="p-6 text-right lg:min-w-52 min-w-[50vw] font-light">Amount</th>
                                    <th class="p-6 text-right lg:min-w-52 min-w-[50vw] font-light">Status</th>
                                </thead>
                                <tbody>
                                    @forelse ($transfers as $transfer)
                                        <tr class="border-b border-opacity-25 border-blue-200 py-6 text-sm">
                                            <td class="p-2 py-6" data-p2p_tnx="{{ $transfer->ref }}">
                                                <p class="px-4">
                                                    {{ date('d-m-y H:i:s', strtotime($transfer->created_at)) }}</p>
                                            </td>
                                            <td class="p-2 py-6 text-right">
                                                <p class="px-4">
                                                    @if ($transfer->sender_id == user()->id)
                                                        <span>to {{ $transfer->receiver_name }}</span>
                                                    @else
                                                        <span>from {{ $transfer->receiver_name }}</span>
                                                    @endif
                                                </p>
                                            </td>
                                            <td class="p-2 py-6 text-right">
                                                <p class="px-4">{{ $transfer->ref }}</p>
                                            </td>
                                            <td class="p-2 py-6 text-right">
                                                <p class="px-4">
                                                    @if ($transfer->sender_id == user()->id)
                                                        {{ formatAmount($transfer->fee) }}
                                                    @endif
                                                </p>
                                            </td>
                                            <td class="p-2 py-6 text-right">
                                                <p class="px-4">
                                                    {{ formatAmount($transfer->amount) }}
                                                </p>
                                            </td>
                                            <td class="p-2 py-6 flex justify-end">
                                                <span
                                                    class="text-end rounded-full w-auto bg-gray-500 bg-opacity-40 py-1 px-3 text-xs text-[#309AFF]">
                                                    @if ($transfer->sender_id == user()->id)
                                                        <span class=" text-[#EA0A0E]">Sent</span>
                                                    @else
                                                        <span class=" text-[#309AFF]">Received</span>
                                                    @endif
                                                </span>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td
                                                class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg border border-slate-800 hover:border-slate-600 cursor-pointer">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-orange-500"
                                                    fill="currentColor" class="bi bi-exclamation-triangle-fill"
                                                    viewBox="0 0 16 16">
                                                    <path
                                                        d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                                </svg>
                                                <span>Empty Record. No transfer found!</span>
                                            </td>
                                        </tr>
                                    @endforelse

                                </tbody>
                            </table>
                        </div>

                        <div class="cursor-pointer simple-pagination" data-paginator="transfers">
                            {{ $transfers->links('templates.' . site('template') . '.paginations.simple') }}
                        </div>

                    </div>
                </div>

            </div>
        </section>

        <!-- new p2p Modal -->
        <div id="NewP2pModal"
            class="hidden #fixed absolute z-50 inset-0 bg-opacity-50 flex items-center justify-center lg:px-6 px-2">
            <div
                class="border-t border-t-[#A320D8] border-r border-r-[#A320D8] border-b border-b-[#3F7DF2] border-l border-l-[#3F7DF2] bg-[#E39DFF] bg-opacity-10 backdrop-blur-lg rounded-xl lg:w-3/5 w-full lg:p-10 p-4 relative mt-20 lg:mr-20">

                <div class="flex justify-between items-center lg:mb-10 mb-4">
                    <h2 class="text-xl font-semibold mb-4 text-white">New P2p</h2>
                    <button id="closeNewP2pModal" class="text-gray-400 hover:text-gray-600">
                        <img src="{{ asset('/assets/templates/dome/images/dash/icon/pink-close-line-icons_close.svg') }}"
                            alt="icon">
                    </button>
                </div>

                <!-- Modal Content -->
                <form action="{{ route('user.transfers.new') }}" method="post" id="transferForm">
                    @csrf

                    <div class="lg:flex block gap-6">
                        <div class="block lg:w-3/5 mb-3">

                            <div class="w-full mb-10">
                                <label for="fullname" class="text-white">Full Name</label>
                                <div class="w-full text-white flex gap-4 border rounded-2xl ">
                                    <div class="w-full">
                                        <input type="text" name="fullname" id="fullname" required
                                            class="w-full p-6 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                            placeholder="Enter Fullname">
                                    </div>
                                </div>
                            </div>

                            <div class="w-full mb-10">
                                <label for="username" class="text-white">Username</label>
                                <div class="w-full text-white flex gap-4 border rounded-2xl ">
                                    <div class="w-full">
                                        <input type="text" name="username" id="username" required
                                            class="w-full p-6 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                            placeholder="Enter Username">
                                    </div>
                                </div>
                            </div>

                            <div class="w-full mb-10">
                                <label for="amount" class="text-white">Amount USD</label>
                                <div class="w-full text-white flex gap-4 border rounded-2xl ">
                                    <div
                                        class="bg-[#E39DFF] bg-opacity-25 rounded-l-2xl w-32 flex items-center justify-center">
                                        <img src="{{ asset('/assets/templates/dome/images/dash/icon/dollar-sign.svg') }}"
                                            alt="icon">
                                    </div>
                                    <div class="w-full">
                                        <input type="number" step="any" name="amount" id="amount" required
                                            class="w-full p-6 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                            placeholder="Amount ({{ site('currency') }})" value="0">
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="block lg:w-2/5 py-6">
                            <div class="w-full lg:mb-10 mb-4 lg:px-10 px-4">
                                <div class="flex gap-4 mb-3">
                                    <p class="text-sm text-white">Important Information</p>
                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/blue-caution-mdi-light_information.svg') }}"
                                        alt="icon">
                                </div>

                                <div class="w-full py-4 text-xs">
                                    <table class="mb-3">
                                        <tr>
                                            <td><span class="text-[#A320D8]">Minimum Deposit:</span></td>
                                            <td><span class="text-white">{{ formatAmount(site('min_transfer')) }}</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><span class="text-[#A320D8]">Maximum Deposit:</span></td>
                                            <td><span class="text-white">{{ formatAmount(site('max_transfer')) }}</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><span class="text-[#A320D8]">Fee:</span></td>
                                            <td><span class="text-white">{{ site('transfer_fee') }}%</span></td>
                                        </tr>
                                    </table>
                                    <p class="text-xs text-justify">
                                        <span class="text-[#95E3FD]">Warning: </span>
                                        <span class="text-[#D8D8D8]">Confirm the receipient's full name before proceeding
                                            to
                                            make transfer.</span>
                                    </p>
                                </div>
                            </div>

                            <div class="w-full px-6">
                                <div class="flex items-center justify-center">
                                    <button type="submit"
                                        class="w-full border rounded-full py-4 px-10 block text-center text-white text-lg bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)] hover:text-white flex items-center justify-centerflex items-center justify-centerflex items-center justify-centerflex items-center justify-centerflex items-center justify-centerflex items-center justify-centerflex items-center justify-centerflex items-center justify-centerflex items-center justify-centerflex items-center justify-centerflex items-center justify-centerflex items-center justify-centerflex items-center justify-centerflex items-center justify-centerflex items-center justify-centerflex items-center justify-center">Transfer
                                        Now</button>
                                </div>
                            </div>

                        </div>
                    </div>
                </form>



            </div>
        </div>
        <!--new p2p modal-->

    </div>
@endsection

@section('scripts')
    <script>
        // search transfer
        $(document).on('input keyup', '#search-transfer-input', function(e) {
            var ref = $(this).val();
            var base_link = $('#search-transfer-button').data('link');
            var encodedRef = encodeURIComponent(ref);

            // Append the query parameter to the URL
            var link = base_link + '?s=' + encodedRef;
            $('#search-transfer-button').attr('href', link);
        });
    </script>


    <script>
        // handle user form
        $(document).on('submit', '#userForm', function(e) {
            e.preventDefault();
            var form = $(this);
            var formData = new FormData(this);
            $.ajax({
                url: form.attr('action'),
                method: 'POST',
                data: formData,
                dataType: 'json',
                contentType: false,
                processData: false,
                success: function(response) {
                    $('#fullname').val(response.name)

                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;

                    if (errors) {
                        $.each(errors, function(field, messages) {
                            var fieldErrors = '';
                            $.each(messages, function(index, message) {
                                fieldErrors += message + '<br>';
                            });
                            toastNotify('error', fieldErrors);
                        });
                    } else {
                        toastNotify('error', 'An Error occured, try again later');
                    }


                }
            });
        });


        // handle transfer form
        $(document).on('submit', '#transferForm', function(e) {
            e.preventDefault();
            var amount = $('#amount').val() * 1;
            var min_transfer = "{{ site('min_transfer') }}" * 1;
            var max_transfer = "{{ site('max_transfer') }}" * 1;
            var currency = "{{ site('currency') }}";

            //check the currency code
            var error = null;
            //check min and max transfer
            if (amount < min_transfer) {
                error = 'Minimum transfer amount is ' + currency + min_transfer;
            }

            if (amount > max_transfer) {
                error = 'Maximum transfer amount is ' + currency + max_transfer;
            }

            if (error === null) {
                var form = $(this);
                var formData = new FormData(this);

                var submitButton = $(this).find('button[type="submit"]');
                submitButton.addClass('relative disabled bg-gray-500');
                submitButton.append('<span class="button-spinner"></span>');
                submitButton.prop('disabled', true);
                //custom button style
                submitButton.addClass(
                    'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                );
                submitButton.addClass('not-allowed-cursor');


                $.ajax({
                    url: form.attr('action'),
                    method: 'POST',
                    data: formData,
                    dataType: 'json',
                    contentType: false,
                    processData: false,
                    success: function(response) {


                        loadPage(form.attr('action'), submitButton, '#pageContent');

                        $('html, body').animate({
                            scrollTop: 0 + 100
                        }, 800);
                        toastNotify('success', response.message);




                    },
                    error: function(xhr, status, error) {
                        var errors = xhr.responseJSON.errors;

                        if (errors) {
                            $.each(errors, function(field, messages) {
                                var fieldErrors = '';
                                $.each(messages, function(index, message) {
                                    fieldErrors += message + '<br>';
                                });
                                toastNotify('error', fieldErrors);
                            });
                        } else {
                            toastNotify('error', 'An Error occured, try again later');
                        }


                    },
                    complete: function() {
                        submitButton.removeClass('disabled bg-gray-500');
                        submitButton.find('.button-spinner').remove();
                        submitButton.prop('disabled', false);

                        submitButton.removeClass(
                            'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                        );
                        submitButton.removeClass('not-allowed-cursor');

                    }
                });
            } else {

                toastNotify('error', error);

            }

        });


        //////////////// initiate p2p modal
        function initializeP2pModals() {
            // console.log("Modals Initialized");

            // Deposit modal toggle
            $(document).off("click", "#openNewP2pModal").on("click", "#openNewP2pModal", function() {
                $('#NewP2pModal').removeClass('hidden hide').addClass('show');
            });

            $(document).off("click", "#closeNewP2pModal").on("click", "#closeNewP2pModal", function() {
                $('#NewP2pModal').removeClass('show').addClass('hide');
                setTimeout(function() {
                    $('#NewP2pModal').addClass('hidden');
                }, 300);
            });

        }

        // Run modal initialization on page load
        $(document).ready(function() {
            initializeP2pModals();
        });
    </script>
@endsection
