@extends('templates.' . site('template') . '.layouts.user')

@section('contents')
    <!--my profile-->


    <section class="lg:w-full w-screen py-6" data-aos="fade-up">
        <div class="max-w-screen-2xl mx-auto mb-5">

            <div class="flex gap-4 justify-between items-center px-3">
                <p
                    class="text-xl lg:text-2xl font-bold mb-6 bg-gradient-to-r from-blue-500 via-blue-400 to-purple-600 bg-clip-text text-transparent">
                    Profile</p>
            </div>

        </div>
    </section>

    <section class="lg:w-full w-screen py-6" data-aos="fade-up">
        <div class="max-w-screen-2xl mx-auto mb-5">


            <!--my profile -->
            <div id="myDirectReferral" class="mb-10">
                <div class="w-full border-t border-t-[#60A4F6]  rounded-2xl p-6">
                    <div class="lg:flex justify-between items-center">
                        <p class="text-white mb-5">Personal Information</p>
                        <a href="{{ route('user.profile.edit') }}"
                            class="flex gap-2 justify-center text-end rounded-full bg-white bg-opacity-15 py-1 px-6 text-sm w-24">


                            <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25"
                                fill="none">
                                <path
                                    d="M15.5667 6.73308L18.5667 9.73308M13.5667 20.7331H21.5667M5.56665 16.7331L4.56665 20.7331L8.56665 19.7331L20.1527 8.14708C20.5276 7.77203 20.7382 7.26341 20.7382 6.73308C20.7382 6.20276 20.5276 5.69414 20.1527 5.31908L19.9806 5.14708C19.6056 4.77214 19.097 4.56151 18.5667 4.56151C18.0363 4.56151 17.5277 4.77214 17.1527 5.14708L5.56665 16.7331Z"
                                    stroke="white" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>

                            <span class=" text-white">Edit</span>
                        </a>
                    </div>

                    <div class="lg:flex gap-6 text-white py-6 border-b border-b-white border-opacity-20">
                        <div class="block text-center mb-6 lg:w-[300px]">
                            <img src="{{ asset('storage/profile/' . user()->photo) }}"
                                alt="{{ user()->username ?? 'Profile Photo' }}"
                                class="w-[200px] h-[200px] mb-4 mx-auto rounded-full">
                            <p>Date joined <span
                                    class="text-[#7B7979]">{{ date('M d, Y', strtotime(user()->created_at)) }}</span></p>
                        </div>

                        <div class="grid lg:grid-cols-3 grid-cols-1 gap-4 w-full">
                            <div class="text-left">
                                <p class="block text-[#7B7979] mb-3 p-0 leading-none">Name:</p>
                                <p class="block mb-3 p-0">{{ user()->name ?? 'Not Set' }}</p>
                            </div>

                            <div class="text-left">
                                <p class="block text-[#7B7979] mb-3 p-0 leading-none">Email:</p>
                                <p class="block mb-3 p-0">{{ user()->email ?? 'Not Set' }}</p>
                            </div>

                            <div class="text-left">
                                <p class="block text-[#7B7979] mb-3 p-0 leading-none">Username:</p>
                                <p class="block mb-3 p-0">{{ user()->username ?? 'Not Set' }}</p>
                            </div>
                            <!-------->
                            <div class="text-left">
                                <p class="block text-[#7B7979] mb-3 p-0 leading-none">Phone:</p>
                                <p class="block mb-3 p-0">{{ user()->phone ?? 'Not Set' }}</p>
                            </div>

                            <div class="text-left">
                                <p class="block text-[#7B7979] mb-3 p-0 leading-none">Date Of Birth:</p>
                                <p class="block mb-3 p-0">{{ user()->dob ?? 'Not Set' }}</p>
                            </div>

                            <div class="text-left">
                                <p class="block text-[#7B7979] mb-3 p-0 leading-none">Address:</p>
                                <p class="block mb-3 p-0">{{ user()->address ?? 'Not Set' }}</p>
                            </div>

                            <div class="text-left">
                                <p class="block text-[#7B7979] mb-3 p-0 leading-none">City:</p>
                                <p class="block mb-3 p-0">{{ user()->city ?? 'Not Set' }} </p>
                            </div>

                            <div class="text-left">
                                <p class="block text-[#7B7979] mb-3 p-0 leading-none">State:</p>
                                <p class="block mb-3 p-0">{{ user()->state ?? 'Not Set' }}</p>
                            </div>

                            <div class="text-left">
                                <p class="block text-[#7B7979] mb-3 p-0 leading-none">Country:</p>
                                <p class="block mb-3 p-0">{{ user()->country ?? 'Not Set' }}</p>
                            </div>
                        </div>

                    </div>

                    <div class="w-full p-4 px-10 text-white rounded-2xl mb-10">
                        <div class="flex justify-between items-center mb-10">
                            <p class="">Additional Information</p>
                        </div>

                        <div class="grid lg:grid-cols-3 grid-cols-1 gap-4 w-full mb-10 text-sm">
                            <div class="text-left lg:block flex gap-2">
                                @if (user()->email_verified_at)
                                    <div class=" mb-3">
                                        <svg width="24" height="24" viewBox="0 0 19 19" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M8.65505 1.74993C8.92055 1.48478 9.27577 1.32877 9.65064 1.31266C10.0255 1.29656 10.3928 1.42153 10.6801 1.66293L10.7761 1.75068L12.2011 3.17493H14.2156C14.5939 3.175 14.9582 3.31801 15.2355 3.57531C15.5128 3.8326 15.6827 4.18519 15.7111 4.56243L15.7156 4.67493V6.68943L17.1406 8.11443C17.4059 8.37996 17.5621 8.73533 17.5782 9.11038C17.5943 9.48542 17.4692 9.85288 17.2276 10.1402L17.1398 10.2354L15.7148 11.6604V13.6749C15.7149 14.0534 15.572 14.4179 15.3147 14.6953C15.0574 14.9728 14.7047 15.1428 14.3273 15.1712L14.2156 15.1749H12.2018L10.7768 16.5999C10.5113 16.8653 10.1559 17.0214 9.78085 17.0375C9.40581 17.0536 9.03836 16.9285 8.75105 16.6869L8.6558 16.5999L7.2308 15.1749H5.21555C4.83712 15.175 4.47263 15.0321 4.19514 14.7748C3.91766 14.5175 3.74769 14.1648 3.7193 13.7874L3.71555 13.6749V11.6604L2.29055 10.2354C2.0252 9.9699 1.86905 9.61452 1.85295 9.23948C1.83684 8.86443 1.96194 8.49698 2.20355 8.20968L2.29055 8.11443L3.71555 6.68943V4.67493C3.71562 4.29663 3.85863 3.93232 4.11593 3.65499C4.37323 3.37767 4.72582 3.2078 5.10305 3.17943L5.21555 3.17493H7.23005L8.65505 1.74993Z"
                                                fill="#08C949" />
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M12.0238 6.91219L8.84078 10.0952L7.51478 8.76919C7.37405 8.62856 7.18321 8.5496 6.98426 8.54967C6.78531 8.54974 6.59453 8.62884 6.4539 8.76957C6.31327 8.9103 6.2343 9.10113 6.23438 9.30008C6.23445 9.49904 6.31355 9.68981 6.45428 9.83044L8.25728 11.6334C8.33389 11.7101 8.42485 11.7709 8.52497 11.8124C8.62509 11.8539 8.7324 11.8752 8.84078 11.8752C8.94915 11.8752 9.05646 11.8539 9.15658 11.8124C9.2567 11.7709 9.34766 11.7101 9.42428 11.6334L13.0843 7.97269C13.2209 7.83124 13.2965 7.64179 13.2948 7.44514C13.2931 7.2485 13.2142 7.06039 13.0751 6.92133C12.9361 6.78227 12.748 6.7034 12.5513 6.70169C12.3547 6.69998 12.1652 6.77558 12.0238 6.91219Z"
                                                fill="#F0FCFF" />
                                        </svg>

                                    </div>
                                @else
                                    <div class=" mb-3">
                                        <svg width="24" height="24" viewBox="0 0 20 21" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M10.8334 8.29888H9.16675V6.63221H10.8334M10.8334 14.9655H9.16675V9.96555H10.8334M10.0001 2.46555C8.90573 2.46555 7.8221 2.68109 6.81105 3.09988C5.80001 3.51867 4.88135 4.1325 4.10752 4.90632C2.54472 6.46913 1.66675 8.58874 1.66675 10.7989C1.66675 13.009 2.54472 15.1286 4.10752 16.6914C4.88135 17.4653 5.80001 18.0791 6.81105 18.4979C7.8221 18.9167 8.90573 19.1322 10.0001 19.1322C12.2102 19.1322 14.3298 18.2542 15.8926 16.6914C17.4554 15.1286 18.3334 13.009 18.3334 10.7989C18.3334 9.70453 18.1179 8.6209 17.6991 7.60985C17.2803 6.5988 16.6665 5.68014 15.8926 4.90632C15.1188 4.1325 14.2002 3.51867 13.1891 3.09988C12.1781 2.68109 11.0944 2.46555 10.0001 2.46555Z"
                                                fill="#EA0A0E" />
                                        </svg>
                                    </div>
                                @endif
                                <p class="inline mb-3 p-0">Email</p>
                            </div>

                            <div class="text-left lg:block flex gap-2">
                                @if (user()->kyc_verified_at)
                                    <div class=" mb-3">
                                        <svg width="24" height="24" viewBox="0 0 19 19" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M8.65505 1.74993C8.92055 1.48478 9.27577 1.32877 9.65064 1.31266C10.0255 1.29656 10.3928 1.42153 10.6801 1.66293L10.7761 1.75068L12.2011 3.17493H14.2156C14.5939 3.175 14.9582 3.31801 15.2355 3.57531C15.5128 3.8326 15.6827 4.18519 15.7111 4.56243L15.7156 4.67493V6.68943L17.1406 8.11443C17.4059 8.37996 17.5621 8.73533 17.5782 9.11038C17.5943 9.48542 17.4692 9.85288 17.2276 10.1402L17.1398 10.2354L15.7148 11.6604V13.6749C15.7149 14.0534 15.572 14.4179 15.3147 14.6953C15.0574 14.9728 14.7047 15.1428 14.3273 15.1712L14.2156 15.1749H12.2018L10.7768 16.5999C10.5113 16.8653 10.1559 17.0214 9.78085 17.0375C9.40581 17.0536 9.03836 16.9285 8.75105 16.6869L8.6558 16.5999L7.2308 15.1749H5.21555C4.83712 15.175 4.47263 15.0321 4.19514 14.7748C3.91766 14.5175 3.74769 14.1648 3.7193 13.7874L3.71555 13.6749V11.6604L2.29055 10.2354C2.0252 9.9699 1.86905 9.61452 1.85295 9.23948C1.83684 8.86443 1.96194 8.49698 2.20355 8.20968L2.29055 8.11443L3.71555 6.68943V4.67493C3.71562 4.29663 3.85863 3.93232 4.11593 3.65499C4.37323 3.37767 4.72582 3.2078 5.10305 3.17943L5.21555 3.17493H7.23005L8.65505 1.74993Z"
                                                fill="#08C949" />
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M12.0238 6.91219L8.84078 10.0952L7.51478 8.76919C7.37405 8.62856 7.18321 8.5496 6.98426 8.54967C6.78531 8.54974 6.59453 8.62884 6.4539 8.76957C6.31327 8.9103 6.2343 9.10113 6.23438 9.30008C6.23445 9.49904 6.31355 9.68981 6.45428 9.83044L8.25728 11.6334C8.33389 11.7101 8.42485 11.7709 8.52497 11.8124C8.62509 11.8539 8.7324 11.8752 8.84078 11.8752C8.94915 11.8752 9.05646 11.8539 9.15658 11.8124C9.2567 11.7709 9.34766 11.7101 9.42428 11.6334L13.0843 7.97269C13.2209 7.83124 13.2965 7.64179 13.2948 7.44514C13.2931 7.2485 13.2142 7.06039 13.0751 6.92133C12.9361 6.78227 12.748 6.7034 12.5513 6.70169C12.3547 6.69998 12.1652 6.77558 12.0238 6.91219Z"
                                                fill="#F0FCFF" />
                                        </svg>

                                    </div>
                                @else
                                    <div class=" mb-3">
                                        <svg width="24" height="24" viewBox="0 0 20 21" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M10.8334 8.29888H9.16675V6.63221H10.8334M10.8334 14.9655H9.16675V9.96555H10.8334M10.0001 2.46555C8.90573 2.46555 7.8221 2.68109 6.81105 3.09988C5.80001 3.51867 4.88135 4.1325 4.10752 4.90632C2.54472 6.46913 1.66675 8.58874 1.66675 10.7989C1.66675 13.009 2.54472 15.1286 4.10752 16.6914C4.88135 17.4653 5.80001 18.0791 6.81105 18.4979C7.8221 18.9167 8.90573 19.1322 10.0001 19.1322C12.2102 19.1322 14.3298 18.2542 15.8926 16.6914C17.4554 15.1286 18.3334 13.009 18.3334 10.7989C18.3334 9.70453 18.1179 8.6209 17.6991 7.60985C17.2803 6.5988 16.6665 5.68014 15.8926 4.90632C15.1188 4.1325 14.2002 3.51867 13.1891 3.09988C12.1781 2.68109 11.0944 2.46555 10.0001 2.46555Z"
                                                fill="#EA0A0E" />
                                        </svg>
                                    </div>
                                @endif
                                <p class="inline mb-3 p-0">KYC</p>
                            </div>

                            <div class="text-left lg:block flex gap-2">
                                @if (user()->deposits()->where('status', 'finished')->first())
                                    <div class=" mb-3">
                                        <svg width="24" height="24" viewBox="0 0 19 19" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M8.65505 1.74993C8.92055 1.48478 9.27577 1.32877 9.65064 1.31266C10.0255 1.29656 10.3928 1.42153 10.6801 1.66293L10.7761 1.75068L12.2011 3.17493H14.2156C14.5939 3.175 14.9582 3.31801 15.2355 3.57531C15.5128 3.8326 15.6827 4.18519 15.7111 4.56243L15.7156 4.67493V6.68943L17.1406 8.11443C17.4059 8.37996 17.5621 8.73533 17.5782 9.11038C17.5943 9.48542 17.4692 9.85288 17.2276 10.1402L17.1398 10.2354L15.7148 11.6604V13.6749C15.7149 14.0534 15.572 14.4179 15.3147 14.6953C15.0574 14.9728 14.7047 15.1428 14.3273 15.1712L14.2156 15.1749H12.2018L10.7768 16.5999C10.5113 16.8653 10.1559 17.0214 9.78085 17.0375C9.40581 17.0536 9.03836 16.9285 8.75105 16.6869L8.6558 16.5999L7.2308 15.1749H5.21555C4.83712 15.175 4.47263 15.0321 4.19514 14.7748C3.91766 14.5175 3.74769 14.1648 3.7193 13.7874L3.71555 13.6749V11.6604L2.29055 10.2354C2.0252 9.9699 1.86905 9.61452 1.85295 9.23948C1.83684 8.86443 1.96194 8.49698 2.20355 8.20968L2.29055 8.11443L3.71555 6.68943V4.67493C3.71562 4.29663 3.85863 3.93232 4.11593 3.65499C4.37323 3.37767 4.72582 3.2078 5.10305 3.17943L5.21555 3.17493H7.23005L8.65505 1.74993Z"
                                                fill="#08C949" />
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M12.0238 6.91219L8.84078 10.0952L7.51478 8.76919C7.37405 8.62856 7.18321 8.5496 6.98426 8.54967C6.78531 8.54974 6.59453 8.62884 6.4539 8.76957C6.31327 8.9103 6.2343 9.10113 6.23438 9.30008C6.23445 9.49904 6.31355 9.68981 6.45428 9.83044L8.25728 11.6334C8.33389 11.7101 8.42485 11.7709 8.52497 11.8124C8.62509 11.8539 8.7324 11.8752 8.84078 11.8752C8.94915 11.8752 9.05646 11.8539 9.15658 11.8124C9.2567 11.7709 9.34766 11.7101 9.42428 11.6334L13.0843 7.97269C13.2209 7.83124 13.2965 7.64179 13.2948 7.44514C13.2931 7.2485 13.2142 7.06039 13.0751 6.92133C12.9361 6.78227 12.748 6.7034 12.5513 6.70169C12.3547 6.69998 12.1652 6.77558 12.0238 6.91219Z"
                                                fill="#F0FCFF" />
                                        </svg>

                                    </div>
                                @else
                                    <div class=" mb-3">
                                        <svg width="24" height="24" viewBox="0 0 20 21" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M10.8334 8.29888H9.16675V6.63221H10.8334M10.8334 14.9655H9.16675V9.96555H10.8334M10.0001 2.46555C8.90573 2.46555 7.8221 2.68109 6.81105 3.09988C5.80001 3.51867 4.88135 4.1325 4.10752 4.90632C2.54472 6.46913 1.66675 8.58874 1.66675 10.7989C1.66675 13.009 2.54472 15.1286 4.10752 16.6914C4.88135 17.4653 5.80001 18.0791 6.81105 18.4979C7.8221 18.9167 8.90573 19.1322 10.0001 19.1322C12.2102 19.1322 14.3298 18.2542 15.8926 16.6914C17.4554 15.1286 18.3334 13.009 18.3334 10.7989C18.3334 9.70453 18.1179 8.6209 17.6991 7.60985C17.2803 6.5988 16.6665 5.68014 15.8926 4.90632C15.1188 4.1325 14.2002 3.51867 13.1891 3.09988C12.1781 2.68109 11.0944 2.46555 10.0001 2.46555Z"
                                                fill="#EA0A0E" />
                                        </svg>
                                    </div>
                                @endif
                                <p class="inline mb-3 p-0">1st Deposit</p>
                            </div>

                            <div class="text-left lg:block flex gap-2">
                                @if (user()->withdrawals()->where('status', 'approved')->first())
                                    <div class=" mb-3">
                                        <svg width="24" height="24" viewBox="0 0 19 19" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M8.65505 1.74993C8.92055 1.48478 9.27577 1.32877 9.65064 1.31266C10.0255 1.29656 10.3928 1.42153 10.6801 1.66293L10.7761 1.75068L12.2011 3.17493H14.2156C14.5939 3.175 14.9582 3.31801 15.2355 3.57531C15.5128 3.8326 15.6827 4.18519 15.7111 4.56243L15.7156 4.67493V6.68943L17.1406 8.11443C17.4059 8.37996 17.5621 8.73533 17.5782 9.11038C17.5943 9.48542 17.4692 9.85288 17.2276 10.1402L17.1398 10.2354L15.7148 11.6604V13.6749C15.7149 14.0534 15.572 14.4179 15.3147 14.6953C15.0574 14.9728 14.7047 15.1428 14.3273 15.1712L14.2156 15.1749H12.2018L10.7768 16.5999C10.5113 16.8653 10.1559 17.0214 9.78085 17.0375C9.40581 17.0536 9.03836 16.9285 8.75105 16.6869L8.6558 16.5999L7.2308 15.1749H5.21555C4.83712 15.175 4.47263 15.0321 4.19514 14.7748C3.91766 14.5175 3.74769 14.1648 3.7193 13.7874L3.71555 13.6749V11.6604L2.29055 10.2354C2.0252 9.9699 1.86905 9.61452 1.85295 9.23948C1.83684 8.86443 1.96194 8.49698 2.20355 8.20968L2.29055 8.11443L3.71555 6.68943V4.67493C3.71562 4.29663 3.85863 3.93232 4.11593 3.65499C4.37323 3.37767 4.72582 3.2078 5.10305 3.17943L5.21555 3.17493H7.23005L8.65505 1.74993Z"
                                                fill="#08C949" />
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M12.0238 6.91219L8.84078 10.0952L7.51478 8.76919C7.37405 8.62856 7.18321 8.5496 6.98426 8.54967C6.78531 8.54974 6.59453 8.62884 6.4539 8.76957C6.31327 8.9103 6.2343 9.10113 6.23438 9.30008C6.23445 9.49904 6.31355 9.68981 6.45428 9.83044L8.25728 11.6334C8.33389 11.7101 8.42485 11.7709 8.52497 11.8124C8.62509 11.8539 8.7324 11.8752 8.84078 11.8752C8.94915 11.8752 9.05646 11.8539 9.15658 11.8124C9.2567 11.7709 9.34766 11.7101 9.42428 11.6334L13.0843 7.97269C13.2209 7.83124 13.2965 7.64179 13.2948 7.44514C13.2931 7.2485 13.2142 7.06039 13.0751 6.92133C12.9361 6.78227 12.748 6.7034 12.5513 6.70169C12.3547 6.69998 12.1652 6.77558 12.0238 6.91219Z"
                                                fill="#F0FCFF" />
                                        </svg>

                                    </div>
                                @else
                                    <div class=" mb-3">
                                        <svg width="24" height="24" viewBox="0 0 20 21" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M10.8334 8.29888H9.16675V6.63221H10.8334M10.8334 14.9655H9.16675V9.96555H10.8334M10.0001 2.46555C8.90573 2.46555 7.8221 2.68109 6.81105 3.09988C5.80001 3.51867 4.88135 4.1325 4.10752 4.90632C2.54472 6.46913 1.66675 8.58874 1.66675 10.7989C1.66675 13.009 2.54472 15.1286 4.10752 16.6914C4.88135 17.4653 5.80001 18.0791 6.81105 18.4979C7.8221 18.9167 8.90573 19.1322 10.0001 19.1322C12.2102 19.1322 14.3298 18.2542 15.8926 16.6914C17.4554 15.1286 18.3334 13.009 18.3334 10.7989C18.3334 9.70453 18.1179 8.6209 17.6991 7.60985C17.2803 6.5988 16.6665 5.68014 15.8926 4.90632C15.1188 4.1325 14.2002 3.51867 13.1891 3.09988C12.1781 2.68109 11.0944 2.46555 10.0001 2.46555Z"
                                                fill="#f97316" />
                                        </svg>
                                    </div>
                                @endif
                                <p class="inline mb-3 p-0">1st Withdrawal</p>
                            </div>

                            <div class="text-left lg:block flex gap-2">
                                @if (user()->botActivations()->first())
                                    <div class=" mb-3">
                                        <svg width="24" height="24" viewBox="0 0 19 19" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M8.65505 1.74993C8.92055 1.48478 9.27577 1.32877 9.65064 1.31266C10.0255 1.29656 10.3928 1.42153 10.6801 1.66293L10.7761 1.75068L12.2011 3.17493H14.2156C14.5939 3.175 14.9582 3.31801 15.2355 3.57531C15.5128 3.8326 15.6827 4.18519 15.7111 4.56243L15.7156 4.67493V6.68943L17.1406 8.11443C17.4059 8.37996 17.5621 8.73533 17.5782 9.11038C17.5943 9.48542 17.4692 9.85288 17.2276 10.1402L17.1398 10.2354L15.7148 11.6604V13.6749C15.7149 14.0534 15.572 14.4179 15.3147 14.6953C15.0574 14.9728 14.7047 15.1428 14.3273 15.1712L14.2156 15.1749H12.2018L10.7768 16.5999C10.5113 16.8653 10.1559 17.0214 9.78085 17.0375C9.40581 17.0536 9.03836 16.9285 8.75105 16.6869L8.6558 16.5999L7.2308 15.1749H5.21555C4.83712 15.175 4.47263 15.0321 4.19514 14.7748C3.91766 14.5175 3.74769 14.1648 3.7193 13.7874L3.71555 13.6749V11.6604L2.29055 10.2354C2.0252 9.9699 1.86905 9.61452 1.85295 9.23948C1.83684 8.86443 1.96194 8.49698 2.20355 8.20968L2.29055 8.11443L3.71555 6.68943V4.67493C3.71562 4.29663 3.85863 3.93232 4.11593 3.65499C4.37323 3.37767 4.72582 3.2078 5.10305 3.17943L5.21555 3.17493H7.23005L8.65505 1.74993Z"
                                                fill="#08C949" />
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M12.0238 6.91219L8.84078 10.0952L7.51478 8.76919C7.37405 8.62856 7.18321 8.5496 6.98426 8.54967C6.78531 8.54974 6.59453 8.62884 6.4539 8.76957C6.31327 8.9103 6.2343 9.10113 6.23438 9.30008C6.23445 9.49904 6.31355 9.68981 6.45428 9.83044L8.25728 11.6334C8.33389 11.7101 8.42485 11.7709 8.52497 11.8124C8.62509 11.8539 8.7324 11.8752 8.84078 11.8752C8.94915 11.8752 9.05646 11.8539 9.15658 11.8124C9.2567 11.7709 9.34766 11.7101 9.42428 11.6334L13.0843 7.97269C13.2209 7.83124 13.2965 7.64179 13.2948 7.44514C13.2931 7.2485 13.2142 7.06039 13.0751 6.92133C12.9361 6.78227 12.748 6.7034 12.5513 6.70169C12.3547 6.69998 12.1652 6.77558 12.0238 6.91219Z"
                                                fill="#F0FCFF" />
                                        </svg>

                                    </div>
                                @else
                                    <div class=" mb-3">
                                        <svg width="24" height="24" viewBox="0 0 20 21" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M10.8334 8.29888H9.16675V6.63221H10.8334M10.8334 14.9655H9.16675V9.96555H10.8334M10.0001 2.46555C8.90573 2.46555 7.8221 2.68109 6.81105 3.09988C5.80001 3.51867 4.88135 4.1325 4.10752 4.90632C2.54472 6.46913 1.66675 8.58874 1.66675 10.7989C1.66675 13.009 2.54472 15.1286 4.10752 16.6914C4.88135 17.4653 5.80001 18.0791 6.81105 18.4979C7.8221 18.9167 8.90573 19.1322 10.0001 19.1322C12.2102 19.1322 14.3298 18.2542 15.8926 16.6914C17.4554 15.1286 18.3334 13.009 18.3334 10.7989C18.3334 9.70453 18.1179 8.6209 17.6991 7.60985C17.2803 6.5988 16.6665 5.68014 15.8926 4.90632C15.1188 4.1325 14.2002 3.51867 13.1891 3.09988C12.1781 2.68109 11.0944 2.46555 10.0001 2.46555Z"
                                                fill="#EA0A0E" />
                                        </svg>
                                    </div>
                                @endif
                                <p class="inline mb-3 p-0">1st Ai Bot</p>
                            </div>
                        </div>

                        <div class="w-full p-4 px-10 mb-10">
                            <div class="lg:flex gap-10 justify-center text-sm">
                                <p>Referral link</p>
                                <p class="text-right text-gray-400 flex gap-3 items-center overflow-hidden copy-icon">
                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/copy_icon.svg') }}"
                                        alt="icon" class="clipboard" style="cursor: pointer;"
                                        data-copy="{{ route('user.register', ['ref' => user()->username ?? 'notset']) }}">
                                    <span id="referral_link" class="lg:text-lg text-[12px] cursor-pointer clipboard"
                                        data-copy="{{ route('user.register', ['ref' => user()->username ?? 'notset']) }}">
                                        {{ route('user.register', ['ref' => user()->username ?? 'notset']) }}
                                    </span>
                                </p>
                            </div>
                        </div>

                    </div>

                </div>
            </div>

        </div>
    </section>



    <!--end my profile-->
@endsection
