@extends('templates.' . site('template') . '.layouts.user')

@section('css')
@endsection


@section('contents')

    {{-- search form --}}
    <div class="mx-auto py-10">
        <!--search form-->
        <div action="" class="block lg:w-[50%] mx-auto" id="filterForm">
            <div class="w-full flex border rounded-full">
                <input type="text" placeholder="Txn ref" id="search-withdrawal-input" value="{{ request()->s }}"
                    class="py-3 h-14s px-6 rounded-l-full bg-transparent w-full text-white">

                <div class="simple-pagination" data-paginator="withdrawals">
                    <a id="search-withdrawal-button" data-link="{{ route('user.withdrawals.index') }}" href=""
                        class="paginator-link flex gap-4 items-center bg-gradient-to-tr from-[#95E3FD] to-[#A320D8] t-[40%] py-3 px-8 rounded-r-full text-white">
                        <img src="{{ asset('/assets/templates/dome/images/dash/icon/white-icons_search-outline.svg') }}"
                            alt="icon">
                        <span>Search</span>
                    </a>
                </div>
            </div>
        </div>
    </div>



    {{-- withdrawal --}}
    <div class="w-full py-6" data-aos="fade-up" id="pageContent">
        <div class="lg:max-w-screen-xl mx-auto lg:p-4 mb-3 text-white" id="refresh">


            <section class="lg:w-full w-screen py-6" data-aos="fade-up">
                <div class="max-w-screen-2xl mx-auto mb-5">

                    <div class="lg:flex justify-between items-center px-3">
                        <div class="block lg:mb-3 mb-10">
                            <p
                                class="text-xl lg:text-2xl font-bold mb-6 bg-gradient-to-r from-[#3F7DF2] via-[#60A4F6] to-[#A320D8] to-[10%] bg-clip-text text-transparent">
                                Withdrawal</p>
                            <div class="flex gap-4 text-white text-sm">
                                <button id="myWithdrawalWalletsBtn"
                                    class="block withdrawal_button_gradient_small">Withdrawal Wallets </button>
                                <button id="myWithdrawalHistoryBtn" class="block">My Withdrawal History</button>
                            </div>
                        </div>

                        <div class="block mb-3">
                            <button id="openWithdrawalModal"
                                class="lg:w-60 border rounded-full lg:py-4 py-2 lg:px-10 px-5 block text-center text-white text-lg bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)] hover:text-white">New
                                Withdrawal</button>
                        </div>
                    </div>

                </div>
            </section>

            <section class="lg:w-full w-screen py-6" data-aos="fade-up">
                <div class="max-w-screen-2xl mx-auto mb-5">


                    <!--withdrawal wallet-->
                    <div id="myWithdrawalWallets" class="block mb-10">
                        <div class="lg:grid grid-cols-2 gap-10" id="withdrawal-wallets">

                            <div class="block mb-10">
                                <div id="wallets"
                                    class="block mb-10  border-r border-r-[#A320D8] rounded-t-2xl overflow-auto h-[70vh] w-full text-white p-6">
                                    <table class="w-full table-auto">
                                        <thead class="text-center">
                                            <th class="p-6 text-left font-light">Wallets/ID</th>
                                            <th class="p-6 text-right min-w-52"></th>
                                        </thead>
                                        <tbody>
                                            @forelse ($auto_wallets as $wallet)
                                                <tr class="border-t border-opacity-25 border-blue-200">
                                                    <td class="p-6">
                                                        <div class="flex items-center gap-4 ">
                                                            <img src="{{ 'https://nowpayments.io' . $wallet->depositCoin->logo_url }}"
                                                                alt="bitcoin" width="50px">
                                                            <div class="block">
                                                                <p class="text-xl">{{ $wallet->depositCoin->name }}</p>
                                                                <div class="flex text-xs">
                                                                    <p id="copy_item"
                                                                        class="clipboard cursor-pointer text-left text-gray-400"
                                                                        data-copy="{{ $wallet->wallet_address }}">
                                                                        {{ $wallet->wallet_address }}
                                                                    </p>
                                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/copy_icon.svg') }}"
                                                                        alt="icon" class="clipboard"
                                                                        data-copy="{{ $wallet->wallet_address }}"
                                                                        style="cursor: pointer;">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td class="p-2 text-right text-sm">
                                                        <p class=" px-4">
                                                            @if ($wallet->whitelisted == 1)
                                                                <span class="text-[#EA0A0E]">No</span>
                                                            @else
                                                                <span class="text-[#08C949]">Yes</span>
                                                            @endif
                                                        </p>
                                                    </td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td
                                                        class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg border border-slate-800 hover:border-slate-600 cursor-pointer">
                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                            class="w-5 h-5 text-orange-500" fill="currentColor"
                                                            class="bi bi-exclamation-triangle-fill" viewBox="0 0 16 16">
                                                            <path
                                                                d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                                        </svg>
                                                        <span>Empty Record!</span>
                                                    </td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="block">
                                <div id="addWalletsAddress"
                                    class="block mb-10 border-l border-l-[#3F7DF2] rounded-t-2xl overflow-auto h-[70vh] w-full text-white p-6">

                                    <div class="flex justify-between items-center lg:mb-10 mb-4">
                                        <h2 class="text-xl font-semibold mb-4 text-white">Add Wallet Address</h2>
                                    </div>

                                    <!-- Modal Content -->
                                    <form action="{{ route('user.auto-wallets.new') }}" method="post" id="addWalletForm"
                                        class="dgen-form" data-action="reload">
                                        @csrf

                                        <div class="w-full mb-10">
                                            <label for="wallet" class="text-white text-sm">Wallet Address</label>
                                            <div
                                                class="w-full text-white flex gap-4 border border-white border-opacity-50 rounded-2xl p-2 mt-5">
                                                <input type="text" id="wallet_address2" name="wallet_address"
                                                    class="w-full p-4 bg-transparent text-white border-0 focus:outline-none flex-1"
                                                    placeholder="Wallet address" required>
                                            </div>
                                        </div>


                                        <!--Coin for deposit Dropdown -->
                                        <div class="w-full lg:mb-10 mb-4">


                                            <label for="coin" class="text-white text-sm">Coin for withdrawal</label>

                                            <div
                                                class="relative  border border-white border-opacity-50 rounded-2xl p-2 mt-5">
                                                <button id="coinForDepositDropdownButton_2"
                                                    class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1 flex gap-2"
                                                    type="button">
                                                    <div class="flex items-center w-full">
                                                        <img src="" class=" rounded-full mr-2"
                                                            id="selectedCoinImg_2" />
                                                        <span id="selectedCoinText_2">Select Coin</span>
                                                    </div>
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/dropdown_arrow_blue.svg') }}"
                                                        alt="icon">
                                                </button>

                                                <!-- Dropdown Menu -->
                                                <ul id="coinForDepositDropdownMenu_2"
                                                    class="absolute z-10 hidden mt-1 max-h-60 lg:w-60 w-full overflow-auto rounded-md bg-gray-600 bg-opacity-90 shadow-lg right-0">
                                                    @foreach ($coins as $coin)
                                                        @if (!array_key_exists($coin->code, $auto_wallets_array))
                                                            <li class="flex items-center px-4 py-2 text-gray-900 cursor-pointer hover:bg-blue-600"
                                                                data-value="{{ $coin->code }}"
                                                                data-label="{{ $coin->name }}"
                                                                data-target="{{ $coin->code . 2 }}"
                                                                data-currency_code="{{ $coin->code }}"
                                                                data-img="{{ 'https://nowpayments.io' . $coin->logo_url }}">
                                                                <img src="{{ 'https://nowpayments.io' . $coin->logo_url }}"
                                                                    alt="coin" class="h-8 w-8 rounded-full mr-2" />
                                                                <p class="" id="{{ $coin->code . 2 }}">
                                                                    <span class="text-white"
                                                                        style="text-transform: uppercase;">
                                                                        @if ($coin->network)
                                                                            {{ $coin->network }}
                                                                        @endif
                                                                    </span>
                                                                    <span class="text-white">
                                                                        {{ $coin->name }}</span>
                                                                </p>
                                                            </li>
                                                        @endif
                                                    @endforeach

                                                </ul>
                                            </div>

                                            <!-- Hidden Input for selected coin -->
                                            <input type="hidden" value="" name="currency_code"
                                                id="currency_code_2" />

                                        </div>




                                        <div class="w-full lg:mb-10 mb-4 lg:px-10 px-4 lg:py-10">
                                            <div class="flex gap-4 mb-3">
                                                <p class="text-white text-sm">Important Information</p>
                                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/blue-caution-mdi-light_information.svg') }}"
                                                    alt="icon">
                                            </div>

                                            <div class="w-full px-6 py-4 text-xs">
                                                <p class="text-sm">
                                                    <span class="text-[#60A4F6]">Warning: </span>
                                                    <span class="text-[#D8D8D8]">For security reasons, newly added wallet
                                                        address will be on security lock until the address is whitelisted.
                                                        During this period, you wouldn't be able to use them for
                                                        withdrawal.</span>
                                                </p>
                                            </div>
                                        </div>


                                        <div class="w-full">
                                            <div class="flex items-center justify-center">
                                                <button type="submit"
                                                    class="withdrawal_button_gradient_big rounded-full px-10 py-4 lg:w-96 w-full mx-auto flex items-center justify-center">Add
                                                    Address</button>
                                            </div>
                                        </div>

                                    </form>

                                </div>
                            </div>

                        </div>
                    </div>

                    <!--my withdrawal history-->
                    <div id="myWithdrawalHistory" class="hidden mb-10">
                        <div id="withdrawals" class="w-full border-t border-t-[#A320D8]  rounded-2xl">

                            <div id="all_history" class="block overflow-x-auto mb-5">
                                <table class="w-full table-auto" id="withdrawalTable">
                                    <thead class="text-white">
                                        <th class="p-6 text-left font-light lg:min-w-52 min-w-[50vw]">AI Bots/ID</th>
                                        <th class="p-6 text-right font-light">Amount</th>
                                        <th class="p-6 text-left font-light">Data</th>
                                        <th class="p-6 text-left">Time</th>
                                        <th class="p-6 text-left font-light gap-2 relative">
                                            <button id="status-dropdown-btn-wth"
                                                class="status-dropdown-btn flex gap-3 items-center">Status
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                    viewBox="0 0 24 24"
                                                    style="fill: rgb(255, 255, 255);transform: ;msFilter:;">
                                                    <path
                                                        d="M11.178 19.569a.998.998 0 0 0 1.644 0l9-13A.999.999 0 0 0 21 5H3a1.002 1.002 0 0 0-.822 1.569l9 13z">
                                                    </path>
                                                </svg>
                                            </button>
                                            <aside id="status-dropdown-wth"
                                                class="status-dropdown hidden absolute bg-[#2d3039] lg:bg-opacity-25 lg:backdrop-blur-md rounded-xl overflow-y-auto h-72">
                                                <ul class="py-4 px-6 text-sm">
                                                    <li class="mb-3">
                                                        <a href=""
                                                            class="block w-40 bg-[#fff] bg-opacity-10 p-2 rounded-lg border-[#fff] border border-opacity-25">
                                                            <p class="text-white">All</p>
                                                        </a>
                                                    </li>
                                                    <li class="mb-3">
                                                        <div
                                                            class="block w-40 bg-[#E9790A] bg-opacity-10 p-2 rounded-lg border-[#E9790A] border border-opacity-25">
                                                            <a href="" class="flex gap-4">
                                                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/yellow-confirming-icon-Frame221.svg') }}"
                                                                    alt="icon" class="w-5 h-5">
                                                                <p class="text-[#E9790A]">Confirming</p>
                                                            </a>
                                                        </div>
                                                    </li>
                                                    <li class="mb-3">
                                                        <div
                                                            class="block w-40 bg-[#D8D8D8] bg-opacity-10 p-2 rounded-lg border-[#D8D8D8] border border-opacity-25">
                                                            <a href="" class="flex gap-4">
                                                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/white-waiting-icon-Frame221.svg') }}"
                                                                    alt="icon" class="w-5 h-5">
                                                                <p class="text-[#D8D8D8]">Waiting</p>
                                                            </a>
                                                        </div>
                                                    </li>
                                                    <li class="mb-3">
                                                        <div
                                                            class="block w-40 bg-[#40DDFF] bg-opacity-10 p-2 rounded-lg border-[#40DDFF] border border-opacity-25">
                                                            <a href="" class="flex gap-4">
                                                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/blue-partly-paid-icon-Frame221.svg') }}"
                                                                    alt="icon" class="w-5 h-5">
                                                                <p class="text-[#40DDFF]">Partly Paid</p>
                                                            </a>
                                                        </div>
                                                    </li>
                                                    <li class="mb-3">
                                                        <div
                                                            class="block w-40 bg-[#08C949] bg-opacity-10 p-2 rounded-lg border-[#08C949] border border-opacity-25">
                                                            <a href="" class="flex gap-4">
                                                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/green-finished-icon-Frame221.svg') }}"
                                                                    alt="icon" class="w-5 h-5">
                                                                <p class="text-[#08C949]">Finished</p>
                                                            </a>
                                                        </div>
                                                    </li>
                                                    <li class="mb-3">
                                                        <div
                                                            class="block w-40 bg-[#EA0A0E] bg-opacity-10 p-2 rounded-lg border-[#EA0A0E] border border-opacity-25">
                                                            <a href="" class="flex gap-4">
                                                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/red-expire-Frame221.svg') }}"
                                                                    alt="icon" class="w-5 h-5">
                                                                <p class="text-[#EA0A0E]">Expired</p>
                                                            </a>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </aside>
                                        </th>
                                    </thead>
                                    <tbody>
                                        @forelse ($withdrawals as $withdrawal)
                                            <tr class="border-b border-opacity-25 border-blue-400 text-white">
                                                <td class="p-6" data-withdrawal_tnx="{{ $withdrawal->ref }}">
                                                    <div class="flex items-center gap-4 ">
                                                        <img src="{{ 'https://nowpayments.io' . $withdrawal->depositCoin->logo_url }}"
                                                            alt="coin" width="50px">
                                                        <div class="block">
                                                            <p class="text-xl">{{ $withdrawal->depositCoin->name }}</p>
                                                            <p class="clipboard cursor-pointer text-gray-400 text-sm"
                                                                data-copy="{{ $withdrawal->wallet_address }}">
                                                                {{ $withdrawal->wallet_address }}</p>
                                                            <p class="clipboard cursor-pointer text-gray-400 text-sm"
                                                                data-copy="{{ $withdrawal->ref }}">
                                                                {{ $withdrawal->ref }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td class="text-right p-6">
                                                    <p class="text-lg">
                                                        {{ formatAmount($withdrawal->amount - $withdrawal->fee) }}</p>
                                                    <p class=" text-gray-400">
                                                        <span>{{ $withdrawal->converted_amount . ' ' . $withdrawal->depositCoin->code }}</span>
                                                        <span class="text-xs text-[#EA0A0E]">
                                                            /{{ $withdrawal->depositCoin->network ?? $withdrawal->depositCoin->code }}</span>
                                                    </p>
                                                </td>
                                                <td class="text-left p-6">
                                                    <p class="local-time">
                                                        {{ date('d-m-y', strtotime($withdrawal->created_at)) }}</p>
                                                </td>
                                                <td class="text-left p-6">
                                                    <p class="local-time">
                                                        {{ date('H:i:s', strtotime($withdrawal->created_at)) }}</p>
                                                </td>
                                                <td class="text-left p-6">
                                                    @if ($withdrawal->status == 'pending')
                                                        <div
                                                            class="block w-40 bg-[#D8D8D8] bg-opacity-10 p-2 rounded-lg border-[#D8D8D8] border">
                                                            <div class="flex gap-4">
                                                                <svg width="19" height="19" viewBox="0 0 19 19"
                                                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <rect x="0.0830078" y="0.801758" width="18"
                                                                        height="18" rx="9" fill="#D8D8D8"
                                                                        fill-opacity="0.11" />
                                                                    <circle cx="5" cy="5" r="5"
                                                                        transform="matrix(-1 0 0 1 14.083 4.80176)"
                                                                        fill="#D8D8D8" />
                                                                </svg>

                                                                <p class="text-[#ffffff] capitalize">
                                                                    {{ $withdrawal->status }}</p>
                                                            </div>
                                                        </div>
                                                    @elseif ($withdrawal->status == 'approved')
                                                        <div
                                                            class="block w-40 bg-[#08C949] bg-opacity-10 p-2 rounded-lg border-[#08C949] border">
                                                            <div class="flex gap-4">
                                                                <svg width="19" height="19" viewBox="0 0 19 19"
                                                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                                        d="M8.6553 2.22869C8.92079 1.96354 9.27601 1.80753 9.65088 1.79142C10.0258 1.77532 10.393 1.90029 10.6803 2.14169L10.7763 2.22944L12.2013 3.65369H14.2158C14.5941 3.65376 14.9584 3.79677 15.2357 4.05407C15.5131 4.31136 15.6829 4.66395 15.7113 5.04119L15.7158 5.15369V7.16819L17.1408 8.59319C17.4062 8.85872 17.5623 9.21409 17.5784 9.58914C17.5945 9.96418 17.4694 10.3316 17.2278 10.6189L17.14 10.7142L15.715 12.1392V14.1537C15.7152 14.5321 15.5722 14.8966 15.3149 15.1741C15.0576 15.4516 14.7049 15.6216 14.3275 15.6499L14.2158 15.6537H12.202L10.777 17.0787C10.5115 17.344 10.1561 17.5002 9.7811 17.5163C9.40605 17.5324 9.0386 17.4073 8.7513 17.1657L8.65605 17.0787L7.23105 15.6537H5.2158C4.83737 15.6538 4.47287 15.5109 4.19539 15.2536C3.9179 14.9962 3.74793 14.6436 3.71955 14.2662L3.7158 14.1537V12.1392L2.2908 10.7142C2.02544 10.4487 1.8693 10.0933 1.85319 9.71824C1.83708 9.34319 1.96219 8.97574 2.2038 8.68844L2.2908 8.59319L3.7158 7.16819V5.15369C3.71587 4.77539 3.85888 4.41108 4.11618 4.13375C4.37347 3.85643 4.72606 3.68656 5.1033 3.65819L5.2158 3.65369H7.2303L8.6553 2.22869Z"
                                                                        fill="#08C949" />
                                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                                        d="M12.0251 7.39095L8.84212 10.574L7.51612 9.24795C7.37539 9.10732 7.18456 9.02836 6.9856 9.02843C6.78665 9.0285 6.59588 9.1076 6.45524 9.24833C6.31461 9.38906 6.23565 9.57989 6.23572 9.77884C6.23579 9.9778 6.31489 10.1686 6.45562 10.3092L8.25862 12.1122C8.33523 12.1889 8.4262 12.2497 8.52632 12.2911C8.62644 12.3326 8.73375 12.354 8.84212 12.354C8.95049 12.354 9.0578 12.3326 9.15792 12.2911C9.25804 12.2497 9.34901 12.1889 9.42562 12.1122L13.0856 8.45145C13.2222 8.31 13.2978 8.12055 13.2961 7.9239C13.2944 7.72726 13.2155 7.53915 13.0765 7.40009C12.9374 7.26103 12.7493 7.18216 12.5527 7.18045C12.356 7.17874 12.1666 7.25434 12.0251 7.39095Z"
                                                                        fill="#F0FCFF" />
                                                                </svg>

                                                                <p class="text-[#08C949] capitalize">
                                                                    {{ $withdrawal->status }}</p>
                                                            </div>
                                                        </div>
                                                    @elseif ($withdrawal->status == 'rejected' || $withdrawal->status == 'failed' || $withdrawal->status == 'refunded')
                                                        <div
                                                            class="block w-40 bg-[#EA0A0E] bg-opacity-10 p-2 rounded-lg border-[#EA0A0E] border">
                                                            <div class="flex gap-4">
                                                                <svg width="19" height="18" viewBox="0 0 19 18"
                                                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                                        d="M8.6553 1.57488C8.92079 1.30973 9.27601 1.15372 9.65088 1.13761C10.0258 1.12151 10.393 1.24648 10.6803 1.48788L10.7763 1.57563L12.2013 2.99988H14.2158C14.5941 2.99995 14.9584 3.14296 15.2357 3.40026C15.5131 3.65756 15.6829 4.01014 15.7113 4.38738L15.7158 4.49988V6.51438L17.1408 7.93938C17.4062 8.20491 17.5623 8.56028 17.5784 8.93533C17.5945 9.31037 17.4694 9.67783 17.2278 9.96513L17.14 10.0604L15.715 11.4854V13.4999C15.7152 13.8783 15.5722 14.2428 15.3149 14.5203C15.0576 14.7978 14.7049 14.9677 14.3275 14.9961L14.2158 14.9999H12.202L10.777 16.4249C10.5115 16.6902 10.1561 16.8464 9.7811 16.8625C9.40605 16.8786 9.0386 16.7535 8.7513 16.5119L8.65605 16.4249L7.23105 14.9999H5.2158C4.83737 15 4.47287 14.8571 4.19539 14.5998C3.9179 14.3424 3.74793 13.9897 3.71955 13.6124L3.7158 13.4999V11.4854L2.2908 10.0604C2.02544 9.79485 1.8693 9.43948 1.85319 9.06443C1.83708 8.68938 1.96219 8.32193 2.2038 8.03463L2.2908 7.93938L3.7158 6.51438V4.49988C3.71587 4.12158 3.85888 3.75727 4.11618 3.47994C4.37347 3.20262 4.72606 3.03275 5.1033 3.00438L5.2158 2.99988H7.2303L8.6553 1.57488Z"
                                                                        fill="#EA0A0E" />
                                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                                        d="M12.0251 6.73715L8.84212 9.92015L7.51612 8.59415C7.37539 8.45351 7.18456 8.37455 6.9856 8.37462C6.78665 8.37469 6.59588 8.45379 6.45524 8.59452C6.31461 8.73525 6.23565 8.92608 6.23572 9.12504C6.23579 9.32399 6.31489 9.51476 6.45562 9.6554L8.25862 11.4584C8.33523 11.535 8.4262 11.5958 8.52632 11.6373C8.62644 11.6788 8.73375 11.7002 8.84212 11.7002C8.95049 11.7002 9.0578 11.6788 9.15792 11.6373C9.25804 11.5958 9.34901 11.535 9.42562 11.4584L13.0856 7.79765C13.2222 7.65619 13.2978 7.46674 13.2961 7.27009C13.2944 7.07345 13.2155 6.88534 13.0765 6.74628C12.9374 6.60723 12.7493 6.52835 12.5527 6.52664C12.356 6.52493 12.1666 6.60053 12.0251 6.73715Z"
                                                                        fill="#F0FCFF" />
                                                                </svg>

                                                                <p class="text-[#EA0A0E]">{{ $withdrawal->status }}</p>
                                                            </div>
                                                        </div>
                                                    @else
                                                        <div
                                                            class="block w-40 bg-[#D8D8D8] bg-opacity-10 p-2 rounded-lg border-[#D8D8D8] border">
                                                            <div class="flex gap-4">
                                                                <svg width="19" height="19" viewBox="0 0 19 19"
                                                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <rect x="0.0830078" y="0.801758" width="18"
                                                                        height="18" rx="9" fill="#D8D8D8"
                                                                        fill-opacity="0.11" />
                                                                    <circle cx="5" cy="5" r="5"
                                                                        transform="matrix(-1 0 0 1 14.083 4.80176)"
                                                                        fill="#D8D8D8" />
                                                                </svg>

                                                                <p class="text-[#ffffff] capitalize">
                                                                    {{ $withdrawal->status }}</p>
                                                            </div>
                                                        </div>
                                                    @endif
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td
                                                    class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg border border-slate-800 hover:border-slate-600 cursor-pointer">
                                                    <svg xmlns="http://www.w3.org/2000/svg"
                                                        class="w-5 h-5 text-orange-500" fill="currentColor"
                                                        class="bi bi-exclamation-triangle-fill" viewBox="0 0 16 16">
                                                        <path
                                                            d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                                    </svg>
                                                    <span>Empty Record. No withdrawal found!</span>
                                                </td>
                                            </tr>
                                        @endforelse
                                    </tbody>

                                </table>
                            </div>

                            <div class="cursor-pointer simple-pagination" data-paginator="withdrawals">
                                {{ $withdrawals->links('templates.' . site('template') . '.paginations.simple') }}
                            </div>

                        </div>
                    </div>


                </div>
            </section>

            <!-- new withdrawal Modal -->
            <div id="NewWithdrawalModal"
                class="hidden #fixed absolute z-50 inset-0 bg-opacity-50 flex items-center justify-center lg:px-6 px-2">
                <div
                    class="border-t border-t-[#A320D8] border-r border-r-[#A320D8] border-b border-b-[#3F7DF2] border-l border-l-[#3F7DF2] bg-[#E39DFF] bg-opacity-10 backdrop-blur-lg rounded-xl lg:w-3/5 w-full lg:p-10 p-4 relative lg:mr-20">

                    <div class="flex justify-between items-center lg:mb-10 mb-4">
                        <h2 class="text-xl font-semibold mb-4 text-white">New Withdrawal</h2>
                        <button id="closeWithdrawalModal" class="text-gray-400 hover:text-gray-600">
                            <img src="{{ asset('/assets/templates/dome/images/dash/icon/pink-close-line-icons_close.svg') }}"
                                alt="icon">
                        </button>
                    </div>

                    <!-- Modal Content -->
                    <form action="{{ route('user.withdrawals.new') }}" method="post" id="withdrawalForm"
                        {{-- class="sgen-form" --}} data-action="reload">
                        @csrf

                        <div class="lg:flex block gap-6">
                            <div class="block lg:w-3/5 mb-3">

                                <div class="w-full mb-10">
                                    <label for="amount" class="text-white">Amount ({{ site('currency') }})</label>
                                    <div class="w-full text-white flex gap-4 border rounded-2xl ">
                                        <div
                                            class="bg-[#E39DFF] bg-opacity-25 rounded-l-2xl w-32 flex items-center justify-center">
                                            <img src="{{ asset('/assets/templates/dome/images/dash/icon/dollar-sign.svg') }}"
                                                alt="icon">
                                        </div>
                                        <div class="w-full">
                                            <input type="number" step="any" name="amount" id="amount"
                                                class="w-full p-6 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                                value="0" placeholder="Amount ({{ site('currency') }})" required>
                                        </div>
                                    </div>
                                </div>

                                <!--Coin for deposit Dropdown -->
                                <div class="w-full lg:mb-10 mb-4">

                                    @if (site('auto_withdraw') == 1)
                                        @if ($auto_wallets->count() > 0)
                                            <label for="amount" class="text-white">Coin for withdrawal</label>
                                            <div class="relative  border py-1 px-3 rounded-2xl">
                                                <button id="coinForDepositDropdownButton"
                                                    class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1 flex gap-2"
                                                    type="button">
                                                    <div class="flex items-center w-full">
                                                        <img src="" class=" rounded-full mr-2"
                                                            id="selectedCoinImg" />
                                                        <span id="selectedCoinText">Select Coin</span>
                                                    </div>
                                                    <img src="{{ asset('/assets/templates/dome/images/dash/icon/dropdown_arrow_blue.svg') }}"
                                                        alt="icon">
                                                </button>

                                                <!-- Dropdown Menu -->
                                                <ul id="coinForDepositDropdownMenu"
                                                    class="absolute z-10 hidden mt-1 max-h-60 lg:w-60 w-full overflow-auto rounded-md bg-gray-600 bg-opacity-90 shadow-lg right-0">
                                                    @foreach ($coins as $coin)
                                                        @if (array_key_exists($coin->code, $auto_wallets_array))
                                                            <li class="flex items-center px-4 py-2 text-gray-900 cursor-pointer hover:bg-blue-600"
                                                                data-target="{{ $coin->code }}"
                                                                data-wallet="{{ $auto_wallets_array[$coin->code] }}"
                                                                data-currency_code="{{ $coin->code }}"
                                                                data-img="{{ 'https://nowpayments.io' . $coin->logo_url }}">
                                                                <img src="{{ 'https://nowpayments.io' . $coin->logo_url }}"
                                                                    alt="coin" class="h-8 w-8 rounded-full mr-2" />
                                                                <p class="" id="{{ $coin->code }}">
                                                                    <span class="text-white"
                                                                        style="text-transform: uppercase;">
                                                                        @if ($coin->network)
                                                                            {{ $coin->network }}
                                                                        @endif
                                                                    </span>
                                                                    <span class="text-white">
                                                                        {{ $coin->name }}</span>
                                                                </p>
                                                            </li>
                                                        @endif
                                                    @endforeach

                                                </ul>


                                            </div>
                                            <!-- Hidden Input for selected coin -->
                                            <input type="hidden" value="" name="currency_code"
                                                id="currency_code" />
                                        @else
                                            <div
                                                class="w-full flex justify-center items-center ts-gray-3 p-2 rounded-lg border border-slate-800 hover:border-slate-600 cursor-pointer">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-orange-500"
                                                    fill="currentColor" class="bi bi-exclamation-triangle-fill"
                                                    viewBox="0 0 16 16">
                                                    <path
                                                        d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                                </svg>
                                                <span>You have not added any withdrawal wallet!</span>
                                            </div>
                                        @endif
                                    @else
                                        <label for="amount" class="text-white">Coin for withdrawal</label>
                                        <div class="relative  border py-1 px-3 rounded-2xl">
                                            <button id="coinForDepositDropdownButton"
                                                class="w-full p-4 bg-transparent text-xl text-white border-0 focus:outline-none flex-1 flex gap-2"
                                                type="button">
                                                <div class="flex items-center w-full">
                                                    <img src="" class=" rounded-full mr-2"
                                                        id="selectedCoinImg" />
                                                    <span id="selectedCoinText">Select Coin</span>
                                                </div>
                                                <img src="{{ asset('/assets/templates/dome/images/dash/icon/dropdown_arrow_blue.svg') }}"
                                                    alt="icon">
                                            </button>

                                            <!-- Dropdown Menu -->
                                            <ul id="coinForDepositDropdownMenu"
                                                class="absolute z-10 hidden mt-1 max-h-60 lg:w-60 w-full overflow-auto rounded-md bg-gray-600 bg-opacity-90 shadow-lg right-0">
                                                @foreach ($coins as $coin)
                                                    <li class="flex items-center px-4 py-2 text-gray-900 cursor-pointer hover:bg-blue-600"
                                                        data-value="{{ $coin->code }}"
                                                        data-label="{{ $coin->name }}"
                                                        data-img="{{ 'https://nowpayments.io' . $coin->logo_url }}">
                                                        <img src="{{ 'https://nowpayments.io' . $coin->logo_url }}"
                                                            alt="coin" class="h-8 w-8 rounded-full mr-2" />
                                                        <p class="">
                                                            <span class="text-white" style="text-transform: uppercase;">
                                                                @if ($coin->network)
                                                                    {{ $coin->network }}
                                                                @endif
                                                            </span>
                                                            <span class="text-white"> {{ $coin->name }}</span>
                                                        </p>
                                                    </li>
                                                @endforeach

                                            </ul>


                                        </div>
                                        <!-- Hidden Input for selected coin -->
                                        <input type="hidden" value="" name="currency_code" id="currency_code" />
                                    @endif

                                </div>

                                <div class="w-full mb-10">
                                    <label for="wallet" class="text-white">Wallet Addrress</label>
                                    <div class="w-full text-white flex gap-4 border rounded-2xl ">
                                        <div class="w-full">
                                            <input type="text" id="wallet_address" name="wallet_address"
                                                value="" @if (site('auto_withdraw') == 1) readonly @endif
                                                class="w-full p-6 bg-transparent text-xl text-white border-0 focus:outline-none flex-1"
                                                placeholder="Wallet address" required>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="block lg:w-2/5 py-6">
                                <div class="w-full lg:mb-10 mb-4 lg:px-10 px-4">
                                    <div class="flex gap-4 mb-3">
                                        <p class="text-sm text-white">Important Information</p>
                                        <img src="{{ asset('/assets/templates/dome/images/dash/icon/blue-caution-mdi-light_information.svg') }}"
                                            alt="icon">
                                    </div>

                                    <div class="w-full py-4 text-xs">
                                        <table class="mb-3">
                                            <tr>
                                                <td><span class="text-[#A320D8]">Minimum Withdrawal:</span></td>
                                                <td><span
                                                        class="text-white">{{ formatAmount(site('min_withdrawal')) }}</span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><span class="text-[#A320D8]">Maximum Withdrawal:</span></td>
                                                <td><span
                                                        class="text-white">{{ formatAmount(site('max_withdrawal')) }}</span>
                                                </td>
                                            </tr>
                                        </table>
                                        <p class="text-xs text-justify">
                                            <span class="text-[#95E3FD]">Warning: </span>
                                            <span class="text-[#D8D8D8]">Ensure your wallet address is valid.
                                                Withdrawals
                                                to wrong or invalid wallet address are not reversible.</span>
                                        </p>
                                    </div>
                                </div>

                                <div class="w-full px-6">
                                    <div class="flex items-center justify-center">
                                        <button type="submit"
                                            class="w-full border rounded-full py-4 px-10 block text-center text-white text-lg bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)] hover:text-white flex items-center justify-center">Withdraw
                                            Now</button>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </form>

                </div>
            </div>
            <!--new withdrawal modal-->


        </div>
    </div>
@endsection

@section('scripts')
    <script>
        // search withdrawal
        $(document).on('input keyup', '#search-withdrawal-input', function(e) {
            var ref = $(this).val();
            var base_link = $('#search-withdrawal-button').data('link');
            var encodedRef = encodeURIComponent(ref);

            // Append the query parameter to the URL
            var link = base_link + '?s=' + encodedRef;
            $('#search-withdrawal-button').attr('href', link);
        });
    </script>


    <script>
        let interval;

        // handle withdrawal form
        $(document).on('submit', '#withdrawalForm', function(e) {
            e.preventDefault();
            var amount = $('#amount').val() * 1;
            var currency_code = $('#currency_code').val();
            var min_withdrawal = "{{ site('min_withdrawal') }}" * 1;
            var max_withdrawal = "{{ site('max_withdrawal') }}" * 1;
            var currency = "{{ site('currency') }}";

            //check the currency code
            var error = null;
            if (!currency_code) {
                error = 'You have not selected a withdrawal method';
            }

            //check min and max withdrawal
            if (amount < min_withdrawal) {
                error = 'Minimum withdrawal amount is ' + currency + min_withdrawal;
            }

            if (amount > max_withdrawal) {
                error = 'Maximum withdrawal amount is ' + currency + max_withdrawal;
            }

            if (error === null) {
                var form = $(this);
                var formData = new FormData(this);

                var submitButton = $(this).find('button[type="submit"]');
                submitButton.addClass('relative disabled bg-gray-500');
                submitButton.append('<span class="button-spinner"></span>');
                submitButton.prop('disabled', true);

                submitButton.removeClass(
                    'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                );
                submitButton.addClass('not-allowed-cursor');

                $.ajax({
                    url: form.attr('action'),
                    method: 'POST',
                    data: formData,
                    dataType: 'json',
                    contentType: false,
                    processData: false,
                    success: function(response) {


                        //$('#NewWithdrawalModal').removeClass('show').addClass('hide');

                        //loadPage(window.location.href, submitButton, '#pageContent');
                        $("#pageContent").load(location.href + " #pageContent");

                        $('html, body').animate({
                            scrollTop: 0 + 100
                        }, 800);
                        toastNotify('success', 'withdrawal request initated successfully');

                        submitButton.addClass(
                            'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                        );
                        submitButton.removeClass('not-allowed-cursor');




                    },
                    error: function(xhr, status, error) {

                        if (xhr.status == 422) {
                            var errors = xhr.responseJSON.errors;

                            if (errors) {
                                $.each(errors, function(field, messages) {
                                    var fieldErrors = '';
                                    $.each(messages, function(index, message) {
                                        fieldErrors += message + '<br>';
                                    });

                                    toastNotify('error', fieldErrors);
                                });
                            } else {
                                toastNotify('error', 'An Error occured, try again later');

                                submitButton.addClass(
                                    'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                                );
                                submitButton.removeClass('not-allowed-cursor');
                            }
                        } else {
                            toastNotify('error', 'Server Error occured, try again later');

                            submitButton.addClass(
                                'bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)]'
                            );
                            submitButton.removeClass('not-allowed-cursor');
                        }



                    },
                    complete: function() {
                        submitButton.removeClass('disabled');
                        submitButton.find('.button-spinner').remove();
                        submitButton.prop('disabled', false);

                    }
                });
            } else {

                toastNotify('error', error);

            }

        });
    </script>


    <script>
        /////////////////////--ADD WALLET ADDRESS--///////////////////////////////
        $(document).on('submit', '#addWalletForm', function(e) {
            e.preventDefault();

            var form = $(this);
            var successAction = form.data('action');
            var redirectUrl = form.data('url');
            var formData = new FormData(this);

            var submitButton = form.find('button[type="submit"]');
            submitButton.addClass('relative disabled').prop('disabled', true);
            submitButton.append('<span class="button-spinner"></span>');
            var passwordInputs = form.find('input[type="password"]');

            submitButton.addClass('not-allowed-cursor');

            $.ajax({
                url: form.attr('action'),
                method: 'POST',
                data: formData,
                dataType: 'json',
                contentType: false,
                processData: false,
                success: function(response) {
                    var message = response.message;

                    // Clear password fields after success
                    if (successAction !== 'none' && passwordInputs.length > 0) {
                        passwordInputs.val('');
                    }

                    /////////////////// notification
                    toastNotify('success', message);

                    if (successAction === 'reload') {
                        $.ajax({
                            url: window.location.href,
                            method: 'GET',
                            success: function(response) {
                                $('#refresh').html($(response).find('#refresh').html());

                                // Reinitialize func after reload
                                initializeDropdown();
                                initializeTabsSlide();
                            },
                            error: function() {
                                //console.error('Error fetching new content');
                            }
                        });
                    } else if (successAction === 'redirect' && redirectUrl) {
                        window.location.href = redirectUrl;
                    } else if (successAction === 'reset') {
                        form.find('input[type!="hidden"]').val('');
                    }
                },
                error: function(xhr) {
                    var errors = xhr.responseJSON ? xhr.responseJSON.errors : null;
                    var errorMessage = 'An error occurred. Please try again later.';

                    if (errors) {
                        errorMessage = '';
                        $.each(errors, function(field, messages) {
                            $.each(messages, function(index, message) {
                                errorMessage += message + '<br>';
                            });
                        });
                    }

                    /////////////////// notification
                    toastNotify('error', errorMessage);
                },
                complete: function() {
                    submitButton.removeClass('disabled').prop('disabled', false);
                    submitButton.find('.button-spinner').remove();
                    submitButton.removeClass('not-allowed-cursor');
                }
            });
        });

        function initializeDropdown() {

            // Toggle dropdown visibility
            $(document).off('click', '#coinForDepositDropdownButton_2').on('click', '#coinForDepositDropdownButton_2',
                function() {
                    const menu = $('#coinForDepositDropdownMenu_2');
                    if (menu.hasClass('hidden')) {
                        menu.removeClass('hidden').hide().slideDown(200);
                    } else {
                        menu.slideUp(200, function() {
                            $(this).addClass('hidden');
                        });
                    }
                });

            // Close dropdown when clicking outside
            $(document).off('click', 'body').on('click', 'body', function(e) {
                if (!$(e.target).closest('#coinForDepositDropdownButton_2, #coinForDepositDropdownMenu_2').length) {
                    $('#coinForDepositDropdownMenu_2').slideUp(200, function() {
                        $(this).addClass('hidden');
                    });
                }
            });

            // Handle dropdown item selection
            $(document).off('click', '#coinForDepositDropdownMenu_2 li').on('click', '#coinForDepositDropdownMenu_2 li',
                function() {
                    const label = $(this).data('label');
                    const imgSrc = $(this).data('img');
                    const value = $(this).data('value');

                    // Update the button with the selected coin
                    $('#selectedCoinText_2').text(label);
                    $('#selectedCoinImg_2').attr('src', imgSrc).addClass('w-8 h-8');

                    // Update the hidden input value
                    $('#currency_code_2').val(value);

                    // Hide the dropdown menu
                    $('#coinForDepositDropdownMenu_2').slideUp(200, function() {
                        $(this).addClass('hidden');
                    });
                });
        }

        // Run dropdown initialization on page load
        $(document).ready(function() {
            initializeDropdown();
        });

        // Run tab slide initialization on page load
        function initializeTabsSlide() {
            //hide filter form
            $('#filterForm').hide();


            // Toggle modal
            $(document).off("click", "#myWithdrawalWalletsBtn").on("click", "#myWithdrawalWalletsBtn", function() {
                $("#myWithdrawalWallets").slideDown().removeClass('hidden');
                $("#myWithdrawalHistory").slideUp().addClass('hidden');

                $("#myWithdrawalHistoryBtn").removeClass('withdrawal_button_gradient_small');
                $("#myWithdrawalWalletsBtn").addClass('withdrawal_button_gradient_small');

                $('#filterForm').hide();
            });

            // Swap between tabs
            $(document).off("click", "#myWithdrawalHistoryBtn").on("click", "#myWithdrawalHistoryBtn", function() {
                $("#myWithdrawalHistory").slideDown().removeClass('hidden');
                $("#myWithdrawalWallets").slideUp().addClass('hidden');

                $("#myWithdrawalWalletsBtn").removeClass('withdrawal_button_gradient_small');
                $("#myWithdrawalHistoryBtn").addClass('withdrawal_button_gradient_small');

                $('#filterForm').show();
            });
        }

        // Run tabs initialization on page load
        $(document).ready(function() {
            initializeTabsSlide();
        });
    </script>


    <script>
        function initializeWithdrawalModals() {
            // console.log("Modals Initialized");

            // Deposit modal toggle
            $(document).off("click", "#openWithdrawalModal").on("click", "#openWithdrawalModal", function() {
                $('#NewWithdrawalModal').removeClass('hidden hide').addClass('show');
            });

            $(document).off("click", "#closeWithdrawalModal").on("click", "#closeWithdrawalModal", function() {
                $('#NewWithdrawalModal').removeClass('show').addClass('hide');
                setTimeout(function() {
                    $('#NewWithdrawalModal').addClass('hidden');
                }, 300);
            });
        }

        // Run modal initialization on page load
        $(document).ready(function() {
            initializeWithdrawalModals();
        });


        //select coin for deposit
        function initializeDepositDropdown() {
            // console.log("Dropdown Initialized");

            // Toggle dropdown visibility with animation
            $(document).off("click", "#coinForDepositDropdownButton").on("click", "#coinForDepositDropdownButton",
                function() {
                    const coinForDepositDropdownMenu = $("#coinForDepositDropdownMenu");
                    if (coinForDepositDropdownMenu.hasClass("hidden")) {
                        coinForDepositDropdownMenu
                            .removeClass("hidden")
                            .addClass("scale-100 opacity-100")
                            .hide()
                            .slideDown(200);
                    } else {
                        coinForDepositDropdownMenu
                            .slideUp(200, function() {
                                $(this).addClass("hidden").removeClass("scale-100 opacity-100");
                            });
                    }
                });

            // Close dropdown when clicking outside
            $(document).off("click", "body").on("click", "body", function(e) {
                if (!$(e.target).closest("#coinForDepositDropdownButton, #coinForDepositDropdownMenu").length) {
                    $("#coinForDepositDropdownMenu")
                        .slideUp(200, function() {
                            $(this).addClass("hidden").removeClass("scale-100 opacity-100");
                        });
                }
            });

            // Handle selection
            $(document).off("click", "#coinForDepositDropdownMenu li").on("click", "#coinForDepositDropdownMenu li",
                function() {
                    const label = $(this).data("label");
                    const imgSrc = $(this).data("img");
                    const value = $(this).data("value");

                    // Update the button with the selected coin
                    $("#selectedCoinText").text(label);
                    $("#selectedCoinImg").attr("src", imgSrc).addClass("w-8 h-8");

                    // Update the hidden input value
                    $("#currency_code").val(value);

                    // Hide the dropdown menu
                    $("#coinForDepositDropdownMenu").slideUp(200, function() {
                        $(this).addClass("hidden").removeClass("scale-100 opacity-100");
                    });
                });
        }

        // Run dropdown initialization on page load
        $(document).ready(function() {
            initializeDepositDropdown();
        });
    </script>


    <script>
        $(document).ready(function() {

            $('#status-dropdown-btn-wth').click(function() {
                $('#status-dropdown-wth').toggleClass('hidden');
            });
        });
    </script>
@endsection
