<?php
    use App\Models\DepositCoin;
    use App\Models\Bot;
    use Faker\Factory as Faker;

    $page_title = 'Home';
    $faker = Faker::create();
    //    $logos = DepositCoin::inRandomOrder()->take(20)->get('logo_url');

    $bots = Bot::get();

    // $deposit_methods = ['usdttrc20'];
    // $methods = DepositCoin::where('status', 1)->get();
    // foreach ($methods as $method) {
    //     array_push($deposit_methods, $method->code);
    // }

    // // Check if the count is less than 20
    // while (count($deposit_methods) < 20) {
    //     $deposit_methods[] = 'usdttrc20';
    // }

    $actions = [
        'deposited',
        'withdrew',
        'withdrew',
        'deposited',
        'withdrew',
        'deposited',
        'withdrew',
        'withdrew',
        'withdrew',
        'withdrew',
        'withdrew',
        'withdrew',
    ];

    $whys = [
        'Cutting-Edge Precision',
        'Trendsetter Advantage',
        'Adaptive Excellence',
        'Seamless Profits',
        'Data-Driven Triumph',
        'Strategic Partner',
        'Constant Success',
        'Market Pioneer',
        'Automated Mastery',
    ];
    $reviews = [
        [
            'image' => 'review-image-1.jpg',
            'name' => 'Adrian',
            'country' => 'UK',
            'testimony' =>
                site('name') .
                "'s precision trading is a game-changer, consistently delivering impressive profits. I trust it for my financial success.",
            'date' => '5/03/2023',
        ],
        [
            'image' => 'review-image-2.jpg',
            'name' => 'Madison',
            'country' => 'USA',
            'testimony' =>
                'Effortless trading with ' .
                site('name') .
                '. Its adaptability and data-driven approach make it a standout choice. Highly recommended!',
            'date' => '7/02/2024',
        ],
        [
            'image' => 'review-image-3.jpg',
            'name' => 'Schneider',
            'country' => 'Germany',
            'testimony' =>
                'Seamless trades, constant profits - ' .
                site('name') .
                " simplifies trading. It's a must-have for anyone in the market.",
            'date' => '5/04/2024',
        ],
        [
            'image' => 'review-image-4.jpg',
            'name' => 'Tommy',
            'country' => 'South Africa',
            'testimony' =>
                site('name') .
                "'s innovative strategies and consistent returns have transformed my trading experience. It's a valuable asset to any trader.",
            'date' => '2/05/2024',
        ],
        [
            'image' => 'review-image-5.jpg',
            'name' => 'Jannet',
            'country' => 'USA',
            'testimony' =>
                'I rely on ' .
                site('name') .
                " for its adaptability in fluctuating markets. It's a proven partner in achieving financial goals.",
            'date' => '13/06/2024',
        ],
        [
            'image' => 'review-image-6.jpg',
            'name' => 'Thomas',
            'country' => 'England',
            'testimony' =>
                site('name') .
                "'s automated precision is remarkable. It's a powerful tool for navigating today's complex trading landscape.",
            'date' => '27/08/2024',
        ],
        [
            'image' => 'review-image-7.jpg',
            'name' => 'Atlan',
            'country' => 'Germany',
            'testimony' =>
                'Maximized profits with ' .
                site('name') .
                '. Its results speak volumes. A reliable and intelligent trading companion.',
            'date' => '1/10/2024',
        ],
        [
            'image' => 'review-image-8.jpg',
            'name' => 'Kelvin',
            'country' => 'UK',
            'testimony' =>
                'Trading with ' .
                site('name') .
                ' is effortless and rewarding. It adapts to market changes seamlessly. Truly impressive!',
            'date' => '15/10/2024',
        ],
        [
            'image' => 'review-image-9.jpg',
            'name' => 'Jude',
            'country' => 'Canada',
            'testimony' =>
                site('name') .
                ' has changed my trading game. Its data-driven approach delivers consistent gains. An invaluable tool for success.',
            'date' => '7/11/2024',
        ],
        [
            'image' => 'review-image-10.jpg',
            'name' => 'Jude',
            'country' => 'Australia',
            'testimony' =>
                'Effortless trading made possible by ' .
                site('name') .
                ' .  Its strategic prowess sets it apart. A game-changer for traders.',
            'date' => '23/1/2025',
        ],
    ];

    $short_description = site('seo_description');
    $counter = 0;

?>



<?php $__env->startSection('css'); ?>
    <style>
        /*** slider for testimonial***/
        .swiper-slide {
            transition: transform 0.4s ease, opacity 0.3s ease, filter 0.3s ease;
            height: 40vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .swiper-slide-active {
            height: 60vh !important;
            z-index: 10;
        }


        /* glide */
        .glide__slides {
            display: flex;
            gap: 30px !important;
            /* Adjust the value as needed */
        }

        /* particle js */
        #particles-canvas {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
    <canvas id="particles-canvas"></canvas>

    <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto flex-1 lg:py-32 relative">
        <img src="<?php echo e(asset('/assets/templates/dome/images/front/3d_shield_image15.png')); ?>" alt="3d-sheld"
            class="w-[800px] 3xl:w-[40vw] absolute top-0 right-0 mt-20 -z-10 lg:block hidden" data-aos="fade-up">
        <div class="lg:pt-52 pt-32 px-3" data-aos="fade-up">
            <div class="block">
                <p class="text-white font-bold lg:text-7xl text-2xl lg:mb-3">
                    <span
                        class="font-bold bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[20%] to-[#D198F9] to-[50%] bg-clip-text text-transparent block">Easy
                        Trading, Steady</span>
                    <span
                        class="font-bold bg-gradient-to-r from-[#95E3FD] from-[10%] to-[#D198F9] to-[50%] bg-clip-text text-transparent block">Profits
                        – Enabled by AI</span>
                    <span class="font-bold text-[#95E3FD]">Brilliance</span>
                </p>
                <p
                    class="lg:text-2xl text-lg bg-gradient-to-r from-[#ffffff] to-[#B4B1B1] bg-clip-text text-transparent max-w-screen-lg">
                    <?php echo e(site('name')); ?> leverages cutting-edge AI robots, meticulously trained on vast trading data and
                    sophisticated algorithms, to decode market trends and execute trades with pinpoint accuracy. Our AI bots
                    consistently deliver an impressive average of 5% daily PNL.</p>

                <div class="flex gap-10 py-20 text-left">
                    <a href="<?php echo e(route('user.register')); ?>"
                        class="lg:w-52 w-32 border rounded-full py-4 lg:px-10  block text-center text-white text-lg bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)] hover:text-white">Sign
                        Up</a>
                    <a href="<?php echo e(route('user.login')); ?>" class="button_gradient">Login</a>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('contents'); ?>
    
    <section class="w-full mb-20 bg-gradient-to-r from-[#77c6fe44] to-[#a45bdb41] backdrop-blur-md relative"
        data-aos="fade-up">
        <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto py-10">
            <div class="flex items-center justify-center w-full">
                <div class="glide w-full px-10">
                    <div class="glide__track" data-glide-el="track">
                        <ul class="glide__slides gap-2">
                            <li class="glide__slide"><img
                                    src="<?php echo e(asset('/assets/templates/dome/images/front/icon/slide_image.svg')); ?>"
                                    alt="icon"></li>
                            <li class="glide__slide"><img
                                    src="<?php echo e(asset('/assets/templates/dome/images/front/icon/slide_image1.svg')); ?>"
                                    alt="icon"></li>
                            <li class="glide__slide"><img
                                    src="<?php echo e(asset('/assets/templates/dome/images/front/icon/slide_image2.svg')); ?>"
                                    alt="icon"></li>
                            <li class="glide__slide"><img
                                    src="<?php echo e(asset('/assets/templates/dome/images/front/icon/slide_image3.svg')); ?>"
                                    alt="icon"></li>
                            <li class="glide__slide"><img
                                    src="<?php echo e(asset('/assets/templates/dome/images/front/icon/slide_image4.svg')); ?>"
                                    alt="icon"></li>
                            <li class="glide__slide"><img
                                    src="<?php echo e(asset('/assets/templates/dome/images/front/icon/slide_image5.svg')); ?>"
                                    alt="icon"></li>
                            <li class="glide__slide"><img
                                    src="<?php echo e(asset('/assets/templates/dome/images/front/icon/slide_image6.svg')); ?>"
                                    alt="icon"></li>
                            <li class="glide__slide"><img
                                    src="<?php echo e(asset('/assets/templates/dome/images/front/icon/slide_image7.svg')); ?>"
                                    alt="icon"></li>
                            <li class="glide__slide"><img
                                    src="<?php echo e(asset('/assets/templates/dome/images/front/icon/slide_image8.svg')); ?>"
                                    alt="icon"></li>
                            <li class="glide__slide"><img
                                    src="<?php echo e(asset('/assets/templates/dome/images/front/icon/slide_image9.svg')); ?>"
                                    alt="icon"></li>
                            <li class="glide__slide"><img
                                    src="<?php echo e(asset('/assets/templates/dome/images/front/icon/slide_image10.svg')); ?>"
                                    alt="icon"></li>
                            <li class="glide__slide"><img
                                    src="<?php echo e(asset('/assets/templates/dome/images/front/icon/slide_image11.svg')); ?>"
                                    alt="icon"></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <img src="<?php echo e(asset('/assets/templates/dome/images/front/3d_atom_trans.png')); ?>" alt="atom"
            class="absolute right-0 lg:block hidden">
    </section>

    
    <section class="w-full mb-10" data-aos="fade-up">
        <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto py-10">
            <div class="flex justify-center w-full">
                <p class="text-center font-bold lg:text-6xl text-2xl lg:mb-3 lg:max-w-screen-lg">
                    <span
                        class="font-bold bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[20%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">Unlocking
                        Markets, Amplifying Returns</span>
                </p>
            </div>
            <div class="flex justify-center w-full">
                <p class="text-center lg:text-2xl text-lg text-[#A49F9F] lg:max-w-[44vw]">Your ultimate trading companion,
                    utilizing cutting-edge technology to unlock new market potentials and amplify your investment returns
                    like never before.</p>
            </div>

            <div class="w-full grid xl:grid-cols-3 grid-cols-1 py-20 px-4 gap-40">

                <div class="col-span-1 mb-6" data-aos="fade-up">
                    <div
                        class="block p-14 rounded-2xl border border-[#E39DFF] bg-[#022BA6] bg-opacity-15 border-opacity-50">
                        <img src="<?php echo e(asset('/assets/templates/dome/images/front/3d-rendering-arrow-icon-b1.png')); ?>"
                            alt="icon" class="mx-auto mb-10">
                        <p class="font-bold text-2xl text-white text-center mb-2">Guaranteed Profit</p>
                        <p class="text-xl text-white text-center">Leveraging advanced technology to navigate challenging
                            market conditions, ensuring your financial goals remain achievable even in bearish market
                            scenarios.</p>
                    </div>
                </div>

                <div class="col-span-1 mb-6" data-aos="fade-up">
                    <div
                        class="block p-14 rounded-2xl border border-[#E39DFF] bg-[#022BA6] bg-opacity-15 border-opacity-50">
                        <img src="<?php echo e(asset('/assets/templates/dome/images/front/3d-rendering-social-media-icon-b1.png')); ?>"
                            alt="icon" class="mx-auto mb-10">
                        <p class="font-bold text-2xl text-white text-center mb-2">Automated Process</p>
                        <p class="text-xl text-white text-center">Our advanced technology streamlines processes, allowing
                            you to navigate markets seamlessly and achieve maximum success. sNavigate uncertainty with
                            <?php echo e(site('name')); ?></p>
                    </div>
                </div>

                <div class="col-span-1 mb-6" data-aos="fade-up">
                    <div
                        class="block p-14 rounded-2xl border border-[#E39DFF] bg-[#022BA6] bg-opacity-15 border-opacity-50">
                        <img src="<?php echo e(asset('/assets/templates/dome/images/front/3d-animal-shape-glowing-with-bright-holographic-colors-b1.png')); ?>"
                            alt="icon" class="mx-auto mb-10">
                        <p class="font-bold text-2xl text-white text-center mb-2">Bullish Or Bearish</p>
                        <p class="text-xl text-white text-center">Harness the power of our Guaranteed Profit approach and
                            let AI elevate your trading endeavors, ensuring consistent gains.</p>
                    </div>
                </div>

            </div>

        </div>
    </section>

    
    <section class="w-full mb-10" data-aos="fade-up">
        <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto py-10">

            <div class="block max-w-screen-lg mx-auto">
                <div class="flex justify-center items-center gap-3">
                    <div class="line"></div>
                    <div class="pricing-text text-[#95E3FD]">PRICING</div>
                    <div class="line2"></div>
                </div>
            </div>

            <div class="flex justify-center w-full">
                <p class="text-center font-bold lg:text-6xl text-2xl lg:mb-3 lg:max-w-screen-lg">
                    <span
                        class="font-bold bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[20%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">AI
                        Trading Portfolios</span>
                </p>
            </div>

            <div class="w-full grid xl:grid-cols-3 grid-cols-1 gap-10 py-16 px-3">
                <?php $__currentLoopData = $bots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $class = 'col-span-1';
                        if ($counter % 3 == 1) {
                            $class = 'xl:col-span-2';
                        } elseif ($counter % 3 == 2) {
                            $class = 'xl:col-span-3';
                        }
                        $counter++;
                    ?>
                    <div class="<?php echo e($class); ?> text-white p-10 rounded-xl border border-[#E39DFF] bg-white bg-opacity-5 border-opacity-50"
                        data-aos="fade-up">
                        <div class="flex gap-4 mb-4">
                            <img src="<?php echo e(asset('storage/bots/' . $bot->logo)); ?>" alt="icon"
                                class="h-7 w-7 rounded-full">
                            <p class="text-white"><?php echo e($bot->name); ?></p>
                        </div>

                        <div class="flex text-white py-10 justify-center items-center gap-4">
                            <p class="lg:text-6xl text-4xl font-extrabold"><?php echo e($bot->daily_min); ?>% -
                                <?php echo e($bot->daily_max); ?>%</p>
                            <p class="font-bold">/day</p>
                        </div>

                        <div class="block lg:py-7 py-4">
                            <p class="flex justify-between">
                                <span class="block text-[#B4B1B1] text-left">Portfolio Range</span>
                                <span class="block text-white text-right"><?php echo e(site('currency_symbol') . $bot->min); ?> -
                                    <?php echo e(site('currency_symbol') . $bot->max); ?></span>
                            </p>

                            <p class="flex justify-between">
                                <span class="block text-[#B4B1B1] text-left">Daily PNL</span>
                                <span class="block text-white text-right"><?php echo e($bot->daily_min); ?>% -
                                    <?php echo e($bot->daily_max); ?>%</span>
                            </p>

                            <p class="flex justify-between">
                                <span class="block text-[#B4B1B1] text-left">Trading Duration</span>
                                <span class="block text-white text-right"><?php echo e($bot->duration); ?>

                                    <?php echo e($bot->duration_type); ?></span>
                            </p>

                            <p class="flex justify-between">
                                <span class="block text-[#B4B1B1] text-left">Capital Returned</span>
                                <span class="block text-white text-right">Yes</span>
                            </p>
                        </div>

                        <div class="block text-center lg:py-7">
                            <a href="<?php echo e(route('user.bots.index')); ?>"
                                class="border rounded-full lg:py-4 py-2 px-10 block text-center text-white text-lg hover:bg-gradient-to-r hover:from-[#95E3FD] from-[50%] hover:via-[#D198F9] via-[30%] hover:to-[#ffffff] to-[70%] hover:bg-clip-text hover:text-transparent">Activate</a>
                        </div>

                        <div class="block lg:py-7 py-4">
                            <p class="text-white font-bold mb-3">Tradings Days</p>
                            <?php
                                $trading_days_display = [
                                    'monday' => in_array('monday', json_decode(site('trading_days'))),
                                    'tuesday' => in_array('tuesday', json_decode(site('trading_days'))),
                                    'wednesday' => in_array('wednesday', json_decode(site('trading_days'))),
                                    'thursday' => in_array('thursday', json_decode(site('trading_days'))),
                                    'friday' => in_array('friday', json_decode(site('trading_days'))),
                                    'saturday' => in_array('saturday', json_decode(site('trading_days'))),
                                    'sunday' => in_array('sunday', json_decode(site('trading_days'))),
                                ];
                            ?>
                            <?php $__currentLoopData = $trading_days_display; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day => $day_display): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <p class="flex justify-between">
                                    <?php if(in_array($day, json_decode(site('trading_days')))): ?>
                                        <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4.5 9L7.5 12L13.5 6" stroke="url(#paint0_linear_7_7290)"
                                                stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round" />
                                            <defs>
                                                <linearGradient id="paint0_linear_7_7290" x1="3.96774" y1="7.2"
                                                    x2="13.1761" y2="3.45383" gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#3F7DF2" />
                                                    <stop offset="0.435" stop-color="#95E3FD" />
                                                    <stop offset="1" stop-color="#A320D8" />
                                                </linearGradient>
                                            </defs>
                                        </svg>
                                    <?php else: ?>
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor"
                                            class="w-4 h-4 text-red-500" viewBox="0 0 16 16">
                                            <path
                                                d="M2.146 2.854a.5.5 0 1 1 .708-.708L8 7.293l5.146-5.147a.5.5 0 0 1 .708.708L8.707 8l5.147 5.146a.5.5 0 0 1-.708.708L8 8.707l-5.146 5.147a.5.5 0 0 1-.708-.708L7.293 8 2.146 2.854Z" />
                                        </svg>
                                    <?php endif; ?>
                                    <span class="block text-[#B4B1B1] text-left "><?php echo e(ucfirst($day)); ?></span>
                                </p>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>

        </div>
    </section>

    
    <section class="w-full mb-10 bg-blue-200 bg-opacity-15" data-aos="fade-up">
        <div class="flex justify-center py-10 overflow-hidden">
            <gecko-coin-price-marquee-widget locale="en" dark-mode="true" transparent-background="true"
                coin-ids="" initial-currency="usd"></gecko-coin-price-marquee-widget>
        </div>
    </section>

    
    <section class="w-full mb-10" data-aos="fade-up">
        <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto py-10">

            <div class="grid lg:grid-cols-3 grid-cols-1 gap-10 px-3">
                <div class="lg:col-span-2 col-span-1 flex items-center">
                    <div class="block w-full" data-aos="fade-up">
                        <!---->
                        <div class="block max-w-sm">
                            <div class="flex justify-start items-center gap-3">
                                <div class="pricing-text text-[#95E3FD]">Getting started</div>
                                <div class="line2"></div>
                            </div>
                        </div>

                        <div class="flex justify-start w-full">
                            <p class="text-center font-bold lg:text-6xl text-2xl lg:mb-3 lg:max-w-screen-lg">
                                <span
                                    class="font-bold bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[20%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">How
                                    It Works</span>
                            </p>
                        </div>

                        <div class="flex justify-start w-full">
                            <p class="text-left lg:text-2xl text-lg text-[#A49F9F] lg:max-w-[44vw]">Our user-friendly
                                interface and intuitive features ensure that even newcomers can quickly grasp the essentials
                                and embark on a seamless journey into the world of efficient and profitable trading.</p>
                        </div>
                        <!---->
                    </div>
                </div>

                <div class="col-span-1 flex lg:justify-end justify-center" data-aos="fade-up">
                    <img src="<?php echo e(asset('/assets/templates/dome/images/front/how_It_Works.png')); ?>" alt="diagram">
                </div>
            </div>

        </div>
    </section>

    
    <section class="w-full mb-10" data-aos="fade-up">
        <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto lg:py-10">

            <div class="block max-w-screen-lg mx-auto">
                <div class="flex justify-center items-center gap-3">
                    <div class="line"></div>
                    <div class="pricing-text text-[#95E3FD]">Supercharged Ai</div>
                    <div class="line2"></div>
                </div>
            </div>

            <div class="flex justify-center w-full">
                <p class="text-center font-bold lg:text-6xl text-2xl lg:mb-3 lg:max-w-screen-lg">
                    <span
                        class="font-bold bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[20%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">Why
                        Choose <?php echo e(site('name')); ?>?</span>
                </p>
            </div>

            <div class="flex justify-center w-full py-10">
                <p class="text-center lg:text-2xl text-lg text-[#A49F9F] lg:max-w-[55vw]"><?php echo e(site('name')); ?> doesn't just
                    follow trends - it pioneers them. It empowers traders to navigate both bullish and bearish market
                    conditions with unwavering confidence. By leveraging sophisticated algorithms and real-time data
                    streams, <?php echo e(site('name')); ?> adapts to ever-changing market dynamics, seizing opportunities while
                    minimizing risks.</p>
            </div>

            <div class="w-full grid xl:grid-cols-3 lg:grid-cols-2 grid-cols-1 gap-10 lg:py-16 py-6 px-3">
                <div class="col-span-1 mb-8" data-aos="fade-up">
                    <div class="w-full relative flex justify-center">
                        <img src="<?php echo e(asset('/assets/templates/dome/images/front/why_cutting_edge_rb_21515495711.png')); ?>"
                            alt="icon" class="max-w-32 absolute -top-14">
                    </div>
                    <div
                        class="w-full lg:bg-[url(../../assets/images/front/backgroundFrame68.png)] bg-[url(../../assets/images/front/1backgroundFrame68.png)] bg-center lg:bg-contain bg-cover bg-no-repeat h-48 flex justify-center items-center pt-10 lg:border-0 border border-white border-opacity-25 rounded-2xl">
                        <p class="text-xl text-white">Cutting-Edge Precision</p>
                    </div>
                </div>

                <div class="col-span-1 mb-8" data-aos="fade-up">
                    <div class="w-full relative flex justify-center">
                        <img src="<?php echo e(asset('/assets/templates/dome/images/front/why_trendsetter_rb_21515495631.png')); ?>"
                            alt="icon" class="max-w-32 absolute -top-14">
                    </div>
                    <div
                        class="w-full lg:bg-[url(../../assets/images/front/backgroundFrame68.png)] bg-[url(../../assets/images/front/1backgroundFrame68.png)] bg-center lg:bg-contain bg-cover bg-no-repeat h-48 flex justify-center items-center pt-10 lg:border-0 border border-white border-opacity-25 rounded-2xl">
                        <p class="text-xl text-white">Trendsetter Advantage</p>
                    </div>
                </div>

                <div class="col-span-1 mb-8" data-aos="fade-up">
                    <div class="w-full relative flex justify-center">
                        <img src="<?php echo e(asset('/assets/templates/dome/images/front/why_adaptive_rb_455291.png')); ?>"
                            alt="icon" class="max-w-32 absolute -top-14">
                    </div>
                    <div
                        class="w-full lg:bg-[url(../../assets/images/front/backgroundFrame68.png)] bg-[url(../../assets/images/front/1backgroundFrame68.png)] bg-center lg:bg-contain bg-cover bg-no-repeat h-48 flex justify-center items-center pt-10 lg:border-0 border border-white border-opacity-25 rounded-2xl">
                        <p class="text-xl text-white">Adaptive Excellence</p>
                    </div>
                </div>

                <div class="col-span-1 mb-8" data-aos="fade-up">
                    <div class="w-full relative flex justify-center">
                        <img src="<?php echo e(asset('/assets/templates/dome/images/front/why_seemless_illustration-render1.png')); ?>"
                            alt="icon" class="max-w-32 absolute -top-14">
                    </div>
                    <div
                        class="w-full lg:bg-[url(../../assets/images/front/backgroundFrame68.png)] bg-[url(../../assets/images/front/1backgroundFrame68.png)] bg-center lg:bg-contain bg-cover bg-no-repeat h-48 flex justify-center items-center pt-10 lg:border-0 border border-white border-opacity-25 rounded-2xl">
                        <p class="text-xl text-white">Seamless Profits</p>
                    </div>
                </div>

                <div class="col-span-1 mb-8" data-aos="fade-up">
                    <div class="w-full relative flex justify-center">
                        <img src="<?php echo e(asset('/assets/templates/dome/images/front/why_data_driven_3d-graph-computer-illustration1.png')); ?>"
                            alt="icon" class="max-w-32 absolute -top-14">
                    </div>
                    <div
                        class="w-full lg:bg-[url(../../assets/images/front/backgroundFrame68.png)] bg-[url(../../assets/images/front/1backgroundFrame68.png)] bg-center lg:bg-contain bg-cover bg-no-repeat h-48 flex justify-center items-center pt-10 lg:border-0 border border-white border-opacity-25 rounded-2xl">
                        <p class="text-xl text-white">Data-Driven Triumph</p>
                    </div>
                </div>

                <div class="col-span-1 mb-8" data-aos="fade-up">
                    <div class="w-full relative flex justify-center">
                        <img src="<?php echo e(asset('/assets/templates/dome/images/front/why_strategisc_abstract-illustrations-blue-sports-kabaddi-symbol-icon1.png')); ?>"
                            alt="icon" class="max-w-32 absolute -top-14">
                    </div>
                    <div
                        class="w-full lg:bg-[url(../../assets/images/front/backgroundFrame68.png)] bg-[url(../../assets/images/front/1backgroundFrame68.png)] bg-center lg:bg-contain bg-cover bg-no-repeat h-48 flex justify-center items-center pt-10 lg:border-0 border border-white border-opacity-25 rounded-2xl">
                        <p class="text-xl text-white">Strategic Partner</p>
                    </div>
                </div>

                <div class="col-span-1 mb-8" data-aos="fade-up">
                    <div class="w-full relative flex justify-center">
                        <img src="<?php echo e(asset('/assets/templates/dome/images/front/why_constant_crystal-lightbulb-idea-innovation-design-purple-pink-blue1.png')); ?>"
                            alt="icon" class="max-w-32 absolute -top-14">
                    </div>
                    <div
                        class="w-full lg:bg-[url(../../assets/images/front/backgroundFrame68.png)] bg-[url(../../assets/images/front/1backgroundFrame68.png)] bg-center lg:bg-contain bg-cover bg-no-repeat h-48 flex justify-center items-center pt-10 lg:border-0 border border-white border-opacity-25 rounded-2xl">
                        <p class="text-xl text-white">Constant Success</p>
                    </div>
                </div>

                <div class="col-span-1 mb-8" data-aos="fade-up">
                    <div class="w-full relative flex justify-center">
                        <img src="<?php echo e(asset('/assets/templates/dome/images/front/why_market_3d-shape-glowing-with-bright-holographic-colors1.png')); ?>"
                            alt="icon" class="max-w-32 absolute -top-14">
                    </div>
                    <div
                        class="w-full lg:bg-[url(../../assets/images/front/backgroundFrame68.png)] bg-[url(../../assets/images/front/1backgroundFrame68.png)] bg-center lg:bg-contain bg-cover bg-no-repeat h-48 flex justify-center items-center pt-10 lg:border-0 border border-white border-opacity-25 rounded-2xl">
                        <p class="text-xl text-white">Market Pioneer</p>
                    </div>
                </div>

                <div class="col-span-1 mb-8" data-aos="fade-up">
                    <div class="w-full relative flex justify-center">
                        <img src="<?php echo e(asset('/assets/templates/dome/images/front/why_automated_rb_21515495611.png')); ?>"
                            alt="icon" class="max-w-32 absolute -top-14">
                    </div>
                    <div
                        class="w-full lg:bg-[url(../../assets/images/front/backgroundFrame68.png)] bg-[url(../../assets/images/front/1backgroundFrame68.png)] bg-center lg:bg-contain bg-cover bg-no-repeat h-48 flex justify-center items-center pt-10 lg:border-0 border border-white border-opacity-25 rounded-2xl">
                        <p class="text-xl text-white">Automated Mastery</p>
                    </div>
                </div>

            </div>

        </div>
    </section>

    
    <section class="w-full mb-10" data-aos="fade-up">
        <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto py-10">

            <div class="grid lg:grid-cols-3 grid-cols-1 gap-10 mb-10 px-3">
                <div class="lg:col-span-2 col-span-1 flex items-center">
                    <div class="block w-full" data-aos="fade-up">
                        <!---->
                        <div class="block max-w-sm">
                            <div class="flex justify-start items-center gap-3">
                                <div class="pricing-text text-[#95E3FD]">REVIEWS</div>
                                <div class="line2"></div>
                            </div>
                        </div>

                        <div class="flex justify-start w-full">
                            <p class="text-left font-bold lg:text-6xl text-2xl lg:mb-3 lg:max-w-screen-lg">
                                <span
                                    class="block font-bold bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[20%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">Dont
                                    Just Take Our Word </span>
                                <span
                                    class="block font-bold bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[20%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">for
                                    it</span>
                            </p>
                        </div>
                        <!---->
                    </div>
                </div>

                <div class="col-span-1 mb-4" data-aos="fade-up">
                    <p class="text-left lg:text-2xl text-lg text-[#A49F9F] lg:max-w-[40vw]">Here is what our many users
                        around the world are saying about our amazing product.</p>
                </div>
            </div>


            <!--slide-->
            <div id="testimonial-slider" class="lg:3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto">

                <div class="center-carousel w-full px-4 relative">

                    <button id="prev"
                        class="absolute left-2 top-20 transform -translate-y-1/2 z-10 h-20 w-14 bg-gray-700 text-white p-2 rounded-l-full hidden lg:flex justify-center items-center border-l border-white">
                        <img src="<?php echo e(asset('/assets/templates/dome/images/front/icon/white-typcn_arrow-left.svg')); ?>"
                            alt="icon">
                    </button>
                    <button id="next"
                        class="absolute right-2 top-20 transform -translate-y-1/2 z-10 h-20 w-14 bg-[conic-gradient(from_120deg_at_25%_50%,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA,_#7D30FF,_#A22ADA)]  hover:bg-[conic-gradient(from_120deg_at_25%_50%,_#7D30FF,_#A22ADA,_#A733FF,_#52C2FF,_#225ABB,_#A22ADA)] text-white p-2 rounded-r-full hidden lg:flex justify-center items-center border-r border-white">
                        <img src="<?php echo e(asset('/assets/templates/dome/images/front/icon/white-typcn_arrow-right.svg')); ?>"
                            alt="icon">
                    </button>

                    <div class="swiper">
                        <div class="swiper-wrapper flex items-center">
                            <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div
                                    class="swiper-slide w-full p-6 text-white rounded-2xl border border-[#ffffff] bg-white bg-opacity-5 backdrop-blur-lg border-opacity-50 flex items-center">
                                    <div class="w-full block">
                                        <div class="lg:flex justify-between items-center">
                                            <div class="flex gap-4">
                                                <img src="<?php echo e(asset('/assets/templates/dome/images/front/review/' . $review['image'])); ?>"
                                                    alt="icon" class="rounded-full h-10 w-10">
                                                <div>
                                                    <p class="text-lg text-white"><?php echo e($review['name']); ?></p>
                                                    <p class="text-[#B4B1B1] "><?php echo e($review['country']); ?></p>
                                                </div>
                                            </div>
                                            <div class="flex gap-2">
                                                <img src="<?php echo e(asset('assets/templates/dome/images/front/icon/yellow-material-symbols_star.svg')); ?>"
                                                    alt="star" class="h-4 w-4">
                                                <img src="<?php echo e(asset('assets/templates/dome/images/front/icon/yellow-material-symbols_star.svg')); ?>"
                                                    alt="star" class="h-4 w-4">
                                                <img src="<?php echo e(asset('assets/templates/dome/images/front/icon/yellow-material-symbols_star.svg')); ?>"
                                                    alt="star" class="h-4 w-4">
                                                <img src="<?php echo e(asset('assets/templates/dome/images/front/icon/yellow-material-symbols_star.svg')); ?>"
                                                    alt="star" class="h-4 w-4">
                                                <img src="<?php echo e(asset('assets/templates/dome/images/front/icon/yellow-material-symbols_star.svg')); ?>"
                                                    alt="star" class="h-4 w-4">
                                            </div>
                                        </div>
                                        <div class="w-full py-14">
                                            <p class="lg:text-2xl text-lg text-white"><?php echo e($review['testimony']); ?></p>
                                        </div>
                                        <div class="w-full">
                                            <p class="text-[#B4B1B1] "><?php echo e($review['date']); ?></p>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </section>

    
    <section class="w-full mb-10 relative" data-aos="fade-up">

        <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto py-10">
            <div class="grid lg:grid-cols-3 grid-cols-1 gap-10 px-3">
                <div class="lg:col-span-2 col-span-1 flex items-center">
                    <div class="block w-full" data-aos="fade-up">
                        <!---->
                        <div class="block max-w-sm">
                            <div class="flex justify-start items-center gap-3">
                                <div class="pricing-text text-[#95E3FD]">Market Data</div>
                                <div class="line2"></div>
                            </div>
                        </div>

                        <div class="flex justify-start w-full">
                            <p class="text-left font-bold lg:text-6xl text-2xl lg:mb-3 lg:max-w-screen-lg">
                                <span
                                    class="block font-bold bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[20%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">Market
                                    HeatMap </span>
                            </p>
                        </div>
                        <!---->
                    </div>
                </div>
            </div>
        </div>

        <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto">
            <div class="grid xl:grid-cols-2 grid-cols-1 gap-4">
                <div class="col-span-1 min-h-[85vh]">

                    <div class="lg:w-[80%] w-full mx-auto">
                        <div class="grid grid-cols-1 py-6">
                            <div class="col-span-1">
                                <div id="cryptoApp" class="p-4">
                                    <div class="w-full grid lg:grid-cols-3 grid-cols-2 lg:gap-10 gap-3">
                                        <!-- Coins will be appended here by jQuery -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="col-span-1 h-[85vh] hidden xl:flex justify-end items-center ">
                    <img src="<?php echo e(asset('/assets/templates/dome/images/front/3d_hand_trans.png')); ?>" alt="3d hand"
                        class="w-[800px] 3xl:w-[40vw]">
                </div>
            </div>
        </div>

    </section>

    
    <section class="w-full mb-10 " data-aos="fade-up">
        <div class="w-full bg-[url(../../assets/images/front/miltky-way-Frame152.png)] bg-cover bg-center h-[140vh]">
            <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto lg:py-10 px-3">

                <div class="block max-w-screen-lg mx-auto">
                    <div class="flex justify-center items-center gap-3">
                        <div class="line"></div>
                        <div class="pricing-text text-[#95E3FD]">LIVE TRADE</div>
                        <div class="line2"></div>
                    </div>
                </div>

                <div class="flex justify-center w-full">
                    <p class="text-center font-bold lg:text-6xl text-2xl lg:mb-3 lg:max-w-screen-lg">
                        <span
                            class="font-bold bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[20%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">Trade
                            From Anywhere</span>
                    </p>
                </div>

                <div class="flex justify-center w-full py-10">
                    <p class="text-center lg:text-2xl text-lg text-[#A49F9F] lg:max-w-[55vw]">Whether you're at home or on
                        the go, seize market opportunities anytime, anywhere, and secure your financial future effortlessly.
                        Trade from any and every city</p>
                </div>

                <div
                    class="w-full bg-blue-200 bg-opacity-5 border border-opacity-15 border-[#E39DFF] lg:p-10 p-3 rounded-3xl">
                    <p class="text-2xl text-white mb-6">Recent Trades by <?php echo e(site('name')); ?></p>

                    <div class="block overflow-auto w-full max-h-[60vh]">
                        <table class="w-full">
                            <thead class="text-center text-white">
                                <th class="p-6 text-left lg:min-w-52 min-w-[40vw]">Market</th>
                                <th class="p-6 text-right lg:min-w-52 min-w-[40vw]">Oracle Price</th>
                                <th class="p-6 text-right lg:min-w-52 min-w-[40vw]">Time</th>
                                <th class="p-6 text-right lg:min-w-52 min-w-[40vw]">Trend</th>
                            </thead>
                            <tbody id="tradeTableBody"></tbody>
                        </table>
                    </div>

                </div>

            </div>
        </div>
    </section>

    
    <section class="w-full !mb-10 relative" data-aos="fade-up">

        <div class="3xl:w-[80vw] xl:w-[90vw] w-[100vw] mx-auto lg:py-10">

            <div class="flex justify-center w-full mb-5">
                <p class="text-center font-bold lg:text-6xl text-2xl lg:mb-3 lg:max-w-screen-lg">
                    <span
                        class="font-bold bg-gradient-to-r from-[#95E3FD] from-[10%] via-[#0E63B7] via-[20%] to-[#D198F9] to-[50%] bg-clip-text text-transparent">Unlocking
                        Wealth with <br> Simplicity</span>
                </p>
            </div>

            <div class="flex justify-center w-full">
                <img src="<?php echo e(asset('/assets/templates/dome/images/front/1unlock_Dashboard.png')); ?>" alt=""
                    class="w-full">
            </div>

        </div>
    </section>
<?php $__env->stopSection(); ?>

<script src="https://widgets.coingecko.com/gecko-coin-price-marquee-widget.js"></script>


<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('/assets/templates/dome/scripts/particle.js')); ?>"></script>
    <script>
        new Glide('.glide', {
            type: 'carousel',
            startAt: 0,
            perView: 9,
            focusAt: 'center',
            autoplay: 3000,
            hoverpause: true,
            gap: 6,
            rewind: true
        }).mount();
    </script>

    <script>
        ////////////////////// testimonials customized button
        $(document).ready(function() {
            var splide = new Splide('#testimonial-slider', {
                type: 'loop',
                perPage: 2,
                perMove: 1,
                autoplay: true,
                interval: 4000, // Adjust autoplay speed
                pauseOnHover: true,
                pagination: false, // Hide default pagination
                arrows: false, // Hide default arrows
                breakpoints: {
                    1024: {
                        perPage: 1, // Display 1 slide at a time on smaller screens
                    },
                },
            }).mount();

            // Custom Buttons Functionality
            $('#prevBtn').on('click', function() {
                splide.go('-1');
            });

            $('#nextBtn').on('click', function() {
                splide.go('+1');
            });
        });
    </script>

    <script>
        //recent trades table data

        let tradeData = <?php echo json_encode(recentTrades(), 15, 512) ?>;


        function updateTradeTable() {
            const tableBody = document.getElementById("tradeTableBody");
            tableBody.innerHTML = ""; // Clear existing rows

            tradeData.forEach((trade) => {
                const row = document.createElement("tr");
                row.className = `border-b border-opacity-25 border-blue-200 py-6 ${
                trade.profit.startsWith("-") ? "text-[#EA0A0E]" : "text-[#00AA39]"
                }`;

                row.innerHTML = `
                <td class="p-2 py-6"><p class="px-4">${trade.pair}</p></td>
                <td class="p-2 py-6 text-right"><p class="px-4">${trade.amount}</p></td>
                <td class="p-2 py-6 text-right"><p class="px-4 recent_trade_time"></p></td>
                <td class="p-2 py-6 text-right"><p class="px-4">${trade.profit}</p></td>
                `;

                tableBody.appendChild(row);
            });
        }

        function updateTradeTimes() {
            const tradeTimeElements = document.querySelectorAll('.recent_trade_time');
            const currentTime = new Date().toLocaleTimeString();

            tradeTimeElements.forEach((element) => {
                element.textContent = currentTime;
            });
        }

        // Function to swap first row to last every 2 seconds
        function rotateRows() {
            if (tradeData.length > 1) {
                const firstRow = tradeData.shift(); // Remove first row
                tradeData.push(firstRow); // Add it to the end
                updateTradeTable(); // Refresh the table with new order
                updateTradeTimes();
            }
        }

        // Initial table setup
        updateTradeTable();

        // Start row rotation every 2 seconds
        setInterval(rotateRows, 1000);
    </script>

    <script>
        //////////////////////// Market heatmap data
        $(document).ready(function() {
            const coins = [{
                    id: "bitcoin",
                    name: "Bitcoin",
                    logo: "<?php echo e(asset('/assets/templates/dome/images/heatmarket_coin/bitcoin-btc-logo.png')); ?>",
                    price: 0,
                    change: 0,
                    symbol: "BTC",
                },
                {
                    id: "ethereum",
                    name: "Ethereum",
                    logo: "<?php echo e(asset('/assets/templates/dome/images/heatmarket_coin/ethereum-eth-logo.png')); ?>",
                    price: 0,
                    change: 0,
                    symbol: "ETH",
                },
                {
                    id: "ripple",
                    name: "Ripple",
                    logo: "<?php echo e(asset('/assets/templates/dome/images/heatmarket_coin/ripple-logo.webp')); ?>",
                    price: 0,
                    change: 0,
                    symbol: "XRP",
                },
                {
                    id: "binancecoin",
                    name: "Binance Coin",
                    logo: "<?php echo e(asset('/assets/templates/dome/images/heatmarket_coin/binance-coin-bnb-logo.png')); ?>",
                    price: 0,
                    change: 0,
                    symbol: "BNB",
                },
                {
                    id: "solana",
                    name: "Solana",
                    logo: "<?php echo e(asset('/assets/templates/dome/images/heatmarket_coin/solana-sol-logo.png')); ?>",
                    price: 0,
                    change: 0,
                    symbol: "SOL",
                },
                {
                    id: "dogecoin",
                    name: "Dogecoin",
                    logo: "<?php echo e(asset('/assets/templates/dome/images/heatmarket_coin/dogecoin-doge-logo.png')); ?>",
                    price: 0,
                    change: 0,
                    symbol: "DOGE",
                },
                {
                    id: "cardano",
                    name: "Cardano",
                    logo: "<?php echo e(asset('/assets/templates/dome/images/heatmarket_coin/cardano-ada-logo.png')); ?>",
                    price: 0,
                    change: 0,
                    symbol: "ADA",
                },
                {
                    id: "tron",
                    name: "Tron",
                    logo: "<?php echo e(asset('/assets/templates/dome/images/heatmarket_coin/tron-trx-logo.png')); ?>",
                    price: 0,
                    change: 0,
                    symbol: "TRX",
                },
                {
                    id: "avalanche-2",
                    name: "Avalanche",
                    logo: "<?php echo e(asset('/assets/templates/dome/images/heatmarket_coin/avalanche-avax-logo.png')); ?>",
                    price: 0,
                    change: 0,
                    symbol: "AVAX",
                },
                {
                    id: "sui",
                    name: "Sui",
                    logo: "<?php echo e(asset('/assets/templates/dome/images/heatmarket_coin/sui-sui-logo.png')); ?>",
                    price: 0,
                    change: 0,
                    symbol: "SUI",
                },
                {
                    id: "pepe",
                    name: "Pepe",
                    logo: "<?php echo e(asset('/assets/templates/dome/images/heatmarket_coin/pepe-pepe-logo.png')); ?>",
                    price: 0,
                    change: 0,
                    symbol: "PEPE",
                },
                {
                    id: "toncoin",
                    name: "Toncoin",
                    logo: "<?php echo e(asset('/assets/templates/dome/images/heatmarket_coin/toncoin-ton-logo.png')); ?>",
                    price: 0,
                    change: 0,
                    symbol: "TON",
                },
                {
                    id: "stellar",
                    name: "Stellar",
                    logo: "<?php echo e(asset('/assets/templates/dome/images/heatmarket_coin/stellar-xlm-logo.png')); ?>",
                    price: 0,
                    change: 0,
                    symbol: "XLM",
                },
                {
                    id: "chainlink",
                    name: "Chainlink",
                    logo: "<?php echo e(asset('/assets/templates/dome/images/heatmarket_coin/chainlink-link-logo.png')); ?>",
                    price: 0,
                    change: 0,
                    symbol: "LINK",
                },
                {
                    id: "shiba-inu",
                    name: "Shiba Inu",
                    logo: "<?php echo e(asset('/assets/templates/dome/images/heatmarket_coin/shiba-inu-shib-logo.png')); ?>",
                    price: 0,
                    change: 0,
                    symbol: "SHIB",
                },
            ];

            function fetchData() {
                const apiUrl =
                    `https://api.coingecko.com/api/v3/simple/price?ids=${coins.map(coin => coin.id).join(",")}&vs_currencies=usd&include_24hr_change=true`;

                $.ajax({
                    url: apiUrl,
                    type: "GET",
                    success: function(data) {
                        coins.forEach(coin => {
                            if (data[coin.id]) {
                                coin.price = parseFloat(data[coin.id].usd).toFixed(2);
                                coin.change = parseFloat(data[coin.id].usd_24h_change);
                            }
                        });
                        renderCoins();
                    },
                    error: function(error) {
                        console.error("Error fetching cryptocurrency data:", error);
                    }
                });
            }

            function renderCoins() {
                const container = $('#cryptoApp .grid');
                container.empty(); // Clear previous data before appending new

                coins.forEach(coin => {
                    const coinElement = `
                        <div class="bg-white bg-opacity-10 text-white p-4 rounded-lg shadow-md border-t-2 border-l-2 border-[#09C241] border-opacity-20">
                            <div class="flex items-center mb-4">
                                <img src="${coin.logo}" alt="${coin.name}" class="w-8 h-8 mr-2" />
                                <div>
                                    <h3 class="font-bold">${coin.name}</h3>
                                    <p class="text-sm text-gray-400">${coin.symbol}</p>
                                </div>
                            </div>
                            <p class="text-sm text-[#6F6A6A]">Price</p>
                            <p class="text-lg font-bold">$${coin.price}</p>
                            <p class="text-sm mt-2 ${coin.change > 0 ? 'text-green-500' : 'text-red-500'}">
                                ${coin.change > 0 ? '+' : ''}${coin.change.toFixed(2)}%
                            </p>
                        </div>
                    `;
                    container.append(coinElement);
                });
            }

            fetchData(); // Fetch data on page load
            setInterval(fetchData, 30000); // Refresh data every 30 seconds
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('templates.' . site('template') . '.layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ygnbmjdo/galaxytrade/resources/views/templates/dome/pages/index.blade.php ENDPATH**/ ?>