<div class="flex justify-center items-center mt-4 gap-4">
    <?php if($paginator->onFirstPage()): ?>
        <span class="px-2 py-1 bg-gray-500 border border-blue-200 rounded-md" aria-disabled="true">
            <img src="<?php echo e(asset('/assets/templates/valent/images/icon/arrow_left.svg')); ?>" alt="">
        </span>
    <?php else: ?>
        <a href="<?php echo e($paginator->previousPageUrl()); ?>" rel="prev"
            class="px-2 py-1 bg-gradient-to-r from-[#0038A3] via-[#0038A3] to-[#02215B] border border-blue-200 rounded-md paginator-link flex items-center justify-center"
            aria-disabled="true">
            <img src="<?php echo e(asset('/assets/templates/valent/images/icon/arrow_left.svg')); ?>" alt="">
        </a>
    <?php endif; ?>

    <!-- Pagination Links -->
    

    <?php
        $pageCount = $paginator->lastPage();
        $currentPage = $paginator->currentPage();

        if ($currentPage <= 2) {
            $startIndex = 1;
            $endIndex = min(3, $pageCount);
        } else {
            $startIndex = $currentPage - 1;
            $endIndex = min($currentPage + 1, $pageCount);
        }
    ?>

    <?php for($i = $startIndex; $i <= $endIndex; $i++): ?>
        <?php if($i == $currentPage): ?>
            <div
                class="px-2 py-1 text-white bg-[#0038A3] border border-blue-200 rounded-md paginator-link not-allowed-cursor">
                <span><?php echo e($i); ?></span>
            </div>
        <?php else: ?>
            <a class="px-2 py-1 text-white bg-gradient-to-r from-black to-gray0700 border border-blue-200 rounded-md paginator-link flex items-center justify-center"
                href="<?php echo e($paginator->url($i)); ?>"><?php echo e($i); ?></a>
        <?php endif; ?>
    <?php endfor; ?>

    <?php if($currentPage < $pageCount - 1): ?>
        <div class="disabled"><span>...</span></div>
        <a href="<?php echo e($paginator->url($pageCount)); ?>"
            class="px-3 py-1 text-white bg-gradient-to-r from-black to-gray0700 border border-blue-200 rounded-md paginator-link flex items-center justify-center">
            <?php echo e($pageCount); ?>

        </a>
    <?php endif; ?>


    <?php if($paginator->hasMorePages()): ?>
        <a href="<?php echo e($paginator->nextPageUrl()); ?>" rel="next"
            class=" paginator-link px-2 py-1  bg-[#0038A3] border border-blue-200 rounded-md paginator-link flex items-center justify-center">
            <img src="<?php echo e(asset('/assets/templates/valent/images/icon/arrow_right.svg')); ?>" alt="">
        </a>
    <?php else: ?>
        <span class="px-2 py-1  bg-gray-500 border border-blue-200 rounded-md">
            <img src="<?php echo e(asset('/assets/templates/valent/images/icon/arrow_right.svg')); ?>" alt="">
        </span>
    <?php endif; ?>

</div>
<?php /**PATH /home/ygnbmjdo/galaxytrade/resources/views/templates/valent/paginations/simple.blade.php ENDPATH**/ ?>