<?php
    //format file size
    if (!function_exists('fileSizeConvert')) {
        function fileSizeConvert($bytes)
        {
            $bytes = floatval($bytes);
            $arBytes = [
                0 => [
                    'UNIT' => 'TB',
                    'VALUE' => pow(1024, 4),
                ],
                1 => [
                    'UNIT' => 'GB',
                    'VALUE' => pow(1024, 3),
                ],
                2 => [
                    'UNIT' => 'MB',
                    'VALUE' => pow(1024, 2),
                ],
                3 => [
                    'UNIT' => 'KB',
                    'VALUE' => 1024,
                ],
                4 => [
                    'UNIT' => 'B',
                    'VALUE' => 1,
                ],
            ];

            foreach ($arBytes as $arItem) {
                if ($bytes >= $arItem['VALUE']) {
                    $result = $bytes / $arItem['VALUE'];
                    $result = str_replace('.', '.', strval(round($result, 2))) . ' ' . $arItem['UNIT'];
                    break;
                }
            }
            return $result ?? 000;
        }
    }

?>



<?php $__env->startSection('contents'); ?>
    <div class="w-full p-3" id="refresh">
        <div class="w-full lg:flex lg:gap-3">
            <div class="w-full lg:w-1/3 h-52 ts-gray-2 rounded-lg p-5 mb-3 hidden">
                <div class="w-full grid grid-cols-1 gap-3 p-2">
                    





                </div>
            </div>
            <div class="w-full ">
                <div class="w-full p-5 mb-5 ts-gray-2 rounded-lg transition-all rescron-card" id="backups">


                    <div class="w-full">


                        <div class="grid grid-cols-1 gap-3 mt-5 md:p-10">
                            
                            <table class="datatable-skeleton-table text-[#bfc9d4] text-xs md:text-sm">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>Date</th>
                                        <th>File</th>
                                        <th>Size</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody width="100%">
                                    <?php $__currentLoopData = $backups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $backup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($loop->iteration); ?></td>
                                            <td><span
                                                    class="local-time"><?php echo e(date('d-m-y H:i:s', filemtime($backup))); ?></span>
                                            </td>
                                            <td><?php echo e(pathinfo($backup)['basename']); ?></td>
                                            <td><?php echo e(fileSizeConvert(filesize($backup))); ?></td>
                                            <td>
                                                <a class="flex justify-end items-center text-blue-500"
                                                    href="<?php echo e(route('admin.backups.download', ['file' => pathinfo($backup)['basename']])); ?>">
                                                    <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor"
                                                        class="w-5 h-5" viewBox="0 0 16 16">
                                                        <path
                                                            d="M4.406 1.342A5.53 5.53 0 0 1 8 0c2.69 0 4.923 2 5.166 4.579C14.758 4.804 16 6.137 16 7.773 16 9.569 14.502 11 12.687 11H10a.5.5 0 0 1 0-1h2.688C13.979 10 15 8.988 15 7.773c0-1.216-1.02-2.228-2.313-2.228h-.5v-.5C12.188 2.825 10.328 1 8 1a4.53 4.53 0 0 0-2.941 1.1c-.757.652-1.153 1.438-1.153 2.055v.448l-.445.049C2.064 4.805 1 5.952 1 7.318 1 8.785 2.23 10 3.781 10H6a.5.5 0 0 1 0 1H3.781C1.708 11 0 9.366 0 7.318c0-1.763 1.266-3.223 2.942-3.593.143-.863.698-1.723 1.464-2.383z" />
                                                        <path
                                                            d="M7.646 15.854a.5.5 0 0 0 .708 0l3-3a.5.5 0 0 0-.708-.708L8.5 14.293V5.5a.5.5 0 0 0-1 0v8.793l-2.146-2.147a.5.5 0 0 0-.708.708l3 3z" />
                                                    </svg>
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>

                            </table>







                        </div>
                    </div>

                </div>





            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    

    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ygnbmjdo/galaxytrade/resources/views/admin/backups/index.blade.php ENDPATH**/ ?>